/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup.cache;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.cache.RocksDBLookupRowEncoder;
import org.apache.kylin.metadata.model.TableDesc;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBLookupBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBLookupBuilder.class);
    private Options options;
    private String dbPath;
    private TableDesc tableDesc;
    private RocksDBLookupRowEncoder encoder;
    private int writeBatchSize;

    public RocksDBLookupBuilder(TableDesc tableDesc, String[] keyColumns, String dbPath) {
        this.tableDesc = tableDesc;
        this.encoder = new RocksDBLookupRowEncoder(tableDesc, keyColumns);
        this.dbPath = dbPath;
        this.writeBatchSize = 500;
        this.options = new Options();
        this.options.setCreateIfMissing(true).setWriteBufferSize(8192L).setMaxWriteBufferNumber(3).setMaxBackgroundCompactions(5).setCompressionType(CompressionType.SNAPPY_COMPRESSION).setCompactionStyle(CompactionStyle.UNIVERSAL);
    }

    public void build(ILookupTable srcLookupTable) {
        File dbFolder = new File(this.dbPath);
        if (dbFolder.exists()) {
            logger.info("remove rocksdb folder:{} to rebuild table cache:{}", (Object)this.dbPath, (Object)this.tableDesc.getIdentity());
            FileUtils.deleteQuietly((File)dbFolder);
        } else {
            logger.info("create new rocksdb folder:{} for table cache:{}", (Object)this.dbPath, (Object)this.tableDesc.getIdentity());
            dbFolder.mkdirs();
        }
        logger.info("start to build lookup table:{} to rocks db:{}", (Object)this.tableDesc.getIdentity(), (Object)this.dbPath);
        try (RocksDB rocksDB = RocksDB.open((Options)this.options, (String)this.dbPath);){
            for (String[] row : srcLookupTable) {
                RocksDBLookupRowEncoder.KV kv = this.encoder.encode(row);
                rocksDB.put(kv.getKey(), kv.getValue());
            }
        }
        catch (RocksDBException e) {
            logger.error("error when put data to rocksDB", (Throwable)e);
            throw new RuntimeException("error when write data to rocks db", e);
        }
        logger.info("source table:{} has been written to rocks db:{}", (Object)this.tableDesc.getIdentity(), (Object)this.dbPath);
    }

    static {
        RocksDB.loadLibrary();
    }
}

