/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.measure.topn.TopNAggregator;
import org.apache.kylin.measure.topn.TopNCounter;
import org.apache.kylin.measure.topn.TopNCounterSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNMeasureType
extends MeasureType<TopNCounter<ByteArray>> {
    private static final Logger logger = LoggerFactory.getLogger(TopNMeasureType.class);
    public static final String FUNC_TOP_N = "TOP_N";
    public static final String DATATYPE_TOPN = "topn";
    public static final String CONFIG_ENCODING_PREFIX = "topn.encoding.";
    public static final String CONFIG_ENCODING_VERSION_PREFIX = "topn.encoding_version.";
    public static final String CONFIG_AGG = "topn.aggregation";
    public static final String CONFIG_ORDER = "topn.order";
    private boolean cuboidCanAnswer;
    private final DataType dataType;

    public TopNMeasureType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) {
        this.validate(functionDesc.getExpression(), functionDesc.getReturnDataType(), true);
    }

    private void validate(String funcName, DataType dataType, boolean checkDataType) {
        if (!FUNC_TOP_N.equals(funcName)) {
            throw new IllegalArgumentException();
        }
        if (!DATATYPE_TOPN.equals(dataType.getName())) {
            throw new IllegalArgumentException();
        }
        if (dataType.getPrecision() < 1 || dataType.getPrecision() > 10000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<TopNCounter<ByteArray>> newIngester() {
        return new MeasureIngester<TopNCounter<ByteArray>>(){
            private DimensionEncoding[] dimensionEncodings = null;
            private List<TblColRef> literalCols = null;
            private int keyLength = 0;
            private DimensionEncoding[] newDimensionEncodings = null;
            private int newKeyLength = 0;
            private boolean needReEncode = true;

            @Override
            public TopNCounter<ByteArray> valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                double counter;
                double d = counter = values[0] == null ? 0.0 : Double.parseDouble(values[0]);
                if (this.dimensionEncodings == null) {
                    this.literalCols = TopNMeasureType.this.getTopNLiteralColumn(measureDesc.getFunction());
                    for (DimensionEncoding encoding : this.dimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, dictionaryMap)) {
                        this.keyLength += encoding.getLengthOfEncoding();
                    }
                    if (values.length != this.literalCols.size() + 1) {
                        throw new IllegalArgumentException();
                    }
                }
                ByteArray key = new ByteArray(this.keyLength);
                int offset = 0;
                for (int i = 0; i < this.dimensionEncodings.length; ++i) {
                    if (values[i + 1] == null) {
                        Arrays.fill(key.array(), offset, offset + this.dimensionEncodings[i].getLengthOfEncoding(), (byte)-1);
                    } else {
                        this.dimensionEncodings[i].encode(values[i + 1], key.array(), offset);
                    }
                    offset += this.dimensionEncodings[i].getLengthOfEncoding();
                }
                TopNCounter<ByteArray> topNCounter = new TopNCounter<ByteArray>(TopNMeasureType.this.dataType.getPrecision() * 50);
                topNCounter.offer(key, counter);
                return topNCounter;
            }

            @Override
            public void reset() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public TopNCounter<ByteArray> reEncodeDictionary(TopNCounter<ByteArray> value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                TopNCounter<ByteArray> topNCounter = value;
                if (this.newDimensionEncodings == null) {
                    Class<MeasureIngester> clazz = MeasureIngester.class;
                    // MONITORENTER : org.apache.kylin.measure.MeasureIngester.class
                    if (this.newDimensionEncodings == null) {
                        this.initialize(measureDesc, oldDicts, newDicts);
                    }
                    // MONITOREXIT : clazz
                }
                if (!this.needReEncode) {
                    return topNCounter;
                }
                int topNSize = topNCounter.size();
                byte[] newIdBuf = new byte[topNSize * this.newKeyLength];
                int bufOffset = 0;
                Iterator<Counter<ByteArray>> iterator = topNCounter.iterator();
                while (iterator.hasNext()) {
                    Counter<ByteArray> counter = iterator.next();
                    int offset = counter.getItem().offset();
                    int innerBuffOffset = 0;
                    for (int i = 0; i < this.dimensionEncodings.length; innerBuffOffset += this.newDimensionEncodings[i].getLengthOfEncoding(), offset += this.dimensionEncodings[i].getLengthOfEncoding(), ++i) {
                        String dimValue = this.dimensionEncodings[i].decode(counter.getItem().array(), offset, this.dimensionEncodings[i].getLengthOfEncoding());
                        this.newDimensionEncodings[i].encode(dimValue, newIdBuf, bufOffset + innerBuffOffset);
                    }
                    counter.getItem().reset(newIdBuf, bufOffset, this.newKeyLength);
                    bufOffset += this.newKeyLength;
                }
                return topNCounter;
            }

            private void initialize(MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                this.literalCols = TopNMeasureType.this.getTopNLiteralColumn(measureDesc.getFunction());
                this.dimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, oldDicts);
                this.keyLength = 0;
                boolean hasDictEncoding = false;
                for (DimensionEncoding encoding : this.dimensionEncodings) {
                    this.keyLength += encoding.getLengthOfEncoding();
                    if (!(encoding instanceof DictionaryDimEnc)) continue;
                    hasDictEncoding = true;
                }
                this.newDimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, newDicts);
                this.newKeyLength = 0;
                for (DimensionEncoding encoding : this.newDimensionEncodings) {
                    this.newKeyLength += encoding.getLengthOfEncoding();
                }
                this.needReEncode = hasDictEncoding;
            }
        };
    }

    @Override
    public MeasureAggregator<TopNCounter<ByteArray>> newAggregator() {
        return new TopNAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        int start;
        ArrayList<TblColRef> columnsNeedDict = Lists.newArrayList();
        List<TblColRef> allCols = functionDesc.getParameter().getColRefs();
        for (int i = start = functionDesc.getParameter().isColumnType() ? 1 : 0; i < allCols.size(); ++i) {
            TblColRef tblColRef = allCols.get(i);
            String encoding = TopNMeasureType.getEncoding(functionDesc, tblColRef).getFirst();
            if (!StringUtils.isEmpty((CharSequence)encoding) && !"dict".equals(encoding)) continue;
            columnsNeedDict.add(tblColRef);
        }
        return columnsNeedDict;
    }

    @Override
    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, final SQLDigest digest, final MeasureDesc topN) {
        boolean b;
        this.cuboidCanAnswer = true;
        List<TblColRef> literalCol = this.getTopNLiteralColumn(topN.getFunction());
        for (TblColRef colRef2 : literalCol) {
            if (!digest.filterColumns.contains(colRef2)) continue;
            return null;
        }
        if (!digest.groupbyColumns.containsAll(literalCol)) {
            return null;
        }
        List retainList = unmatchedDimensions.stream().filter(colRef -> literalCol.contains(colRef)).collect(Collectors.toList());
        if (!retainList.isEmpty()) {
            this.cuboidCanAnswer = false;
        }
        if (digest.aggregations.size() == 1) {
            FunctionDesc onlyFunction = digest.aggregations.iterator().next();
            if (!this.isTopNCompatibleSum(topN.getFunction(), onlyFunction)) {
                return null;
            }
            unmatchedDimensions.removeAll(literalCol);
            unmatchedAggregations.remove(onlyFunction);
            return new CapabilityResult.CapabilityInfluence(){

                @Override
                public double suggestCostMultiplier() {
                    if (TopNMeasureType.this.totallyMatchTopN(digest)) {
                        return 0.3;
                    }
                    if (TopNMeasureType.this.cuboidCanAnswer) {
                        return 1.3;
                    }
                    return 2.0;
                }

                @Override
                public MeasureDesc getInvolvedMeasure() {
                    return topN;
                }
            };
        }
        if (digest.aggregations.isEmpty() && (b = unmatchedDimensions.removeAll(literalCol))) {
            return new CapabilityResult.CapabilityInfluence(){

                @Override
                public double suggestCostMultiplier() {
                    return 2.0;
                }

                @Override
                public MeasureDesc getInvolvedMeasure() {
                    return topN;
                }
            };
        }
        return null;
    }

    private boolean checkSortAndOrder(List<TblColRef> sort, List<SQLDigest.OrderEnum> order) {
        return CollectionUtils.isNotEmpty(sort) && CollectionUtils.isNotEmpty(order) && sort.size() == order.size();
    }

    private boolean totallyMatchTopN(SQLDigest digest) {
        if (!this.checkSortAndOrder(digest.sortColumns, digest.sortOrders)) {
            return false;
        }
        TblColRef sortColumn = digest.sortColumns.get(0);
        if (digest.groupbyColumns.contains(sortColumn)) {
            return false;
        }
        if (!SQLDigest.OrderEnum.DESCENDING.equals((Object)digest.sortOrders.get(0))) {
            return false;
        }
        return digest.hasLimit;
    }

    private boolean isTopNCompatibleSum(FunctionDesc topN, FunctionDesc sum) {
        if (sum == null) {
            return false;
        }
        if (!this.isTopN(topN)) {
            return false;
        }
        TblColRef topnNumCol = this.getTopNNumericColumn(topN);
        if (topnNumCol == null) {
            return sum.isCount();
        }
        if (!sum.isSum()) {
            return false;
        }
        if (sum.getParameter() == null || sum.getParameter().getColRefs() == null || sum.getParameter().getColRefs().isEmpty()) {
            return false;
        }
        TblColRef sumCol = sum.getParameter().getColRefs().get(0);
        return sumCol.equals(topnNumCol);
    }

    @Override
    public boolean needRewrite() {
        return false;
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
        if (sqlDigest.isBorrowedContext) {
            return;
        }
        if (sqlDigest.aggregations.size() > 1) {
            return;
        }
        for (MeasureDesc measureDesc : measureDescs) {
            FunctionDesc topnFunc;
            List<TblColRef> topnLiteralCol;
            if (!sqlDigest.involvedMeasure.contains(measureDesc) || !sqlDigest.groupbyColumns.containsAll(topnLiteralCol = this.getTopNLiteralColumn(topnFunc = measureDesc.getFunction()))) continue;
            if (!sqlDigest.aggregations.isEmpty()) {
                FunctionDesc origFunc = sqlDigest.aggregations.iterator().next();
                if (!origFunc.isSum() && !origFunc.isCount()) {
                    logger.warn("When query with topN, only SUM/Count function is allowed.");
                    return;
                }
                if (!this.isTopNCompatibleSum(measureDesc.getFunction(), origFunc) || !this.totallyMatchTopN(sqlDigest) && this.cuboidCanAnswer) continue;
                logger.info("Rewrite function {} to {}", (Object)origFunc, (Object)topnFunc);
            }
            sqlDigest.aggregations = Lists.newArrayList(topnFunc);
            sqlDigest.groupbyColumns.removeAll(topnLiteralCol);
            sqlDigest.metricColumns.addAll(topnLiteralCol);
            break;
        }
    }

    @Override
    public boolean needAdvancedTupleFilling() {
        return true;
    }

    @Override
    public void fillTupleSimply(Tuple tuple, int indexInTuple, Object measureValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MeasureType.IAdvMeasureFiller getAdvancedTupleFiller(FunctionDesc function, TupleInfo tupleInfo, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        int numericTupleIdx;
        List<TblColRef> literalCols = this.getTopNLiteralColumn(function);
        TblColRef numericCol = this.getTopNNumericColumn(function);
        final int[] literalTupleIdx = new int[literalCols.size()];
        final DimensionEncoding[] dimensionEncodings = TopNMeasureType.getDimensionEncodings(function, literalCols, dictionaryMap);
        for (int i = 0; i < literalCols.size(); ++i) {
            TblColRef colRef = literalCols.get(i);
            literalTupleIdx[i] = tupleInfo.hasColumn(colRef) ? tupleInfo.getColumnIndex(colRef) : -1;
        }
        if (numericCol != null) {
            FunctionDesc sumFunc = FunctionDesc.newInstance("SUM", ParameterDesc.newInstance(numericCol), numericCol.getType().toString());
            String sumFieldName = sumFunc.getRewriteFieldName();
            numericTupleIdx = tupleInfo.hasField(sumFieldName) ? tupleInfo.getFieldIndex(sumFieldName) : -1;
        } else {
            FunctionDesc countFunction = FunctionDesc.newInstance("COUNT", ParameterDesc.newInstance("1"), "bigint");
            numericTupleIdx = tupleInfo.getFieldIndex(countFunction.getRewriteFieldName());
        }
        return new MeasureType.IAdvMeasureFiller(){
            private TopNCounter<ByteArray> topNCounter;
            private Iterator<Counter<ByteArray>> topNCounterIterator;
            private int expectRow = 0;

            @Override
            public void reload(Object measureValue) {
                this.topNCounter = (TopNCounter)measureValue;
                this.topNCounterIterator = this.topNCounter.iterator();
                this.expectRow = 0;
            }

            @Override
            public int getNumOfRows() {
                return this.topNCounter.size();
            }

            @Override
            public void fillTuple(Tuple tuple, int row) {
                if (this.expectRow++ != row) {
                    throw new IllegalStateException();
                }
                Counter<ByteArray> counter = this.topNCounterIterator.next();
                int offset = counter.getItem().offset();
                for (int i = 0; i < dimensionEncodings.length; ++i) {
                    String colValue = dimensionEncodings[i].decode(counter.getItem().array(), offset, dimensionEncodings[i].getLengthOfEncoding());
                    tuple.setDimensionValue(literalTupleIdx[i], colValue);
                    offset += dimensionEncodings[i].getLengthOfEncoding();
                }
                tuple.setMeasureValue(numericTupleIdx, (Object)counter.getCount());
            }
        };
    }

    private static DimensionEncoding[] getDimensionEncodings(FunctionDesc function, List<TblColRef> literalCols, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        DimensionEncoding[] dimensionEncodings = new DimensionEncoding[literalCols.size()];
        for (int i = 0; i < literalCols.size(); ++i) {
            TblColRef colRef = literalCols.get(i);
            Pair<String, String> topNEncoding = TopNMeasureType.getEncoding(function, colRef);
            String encoding = topNEncoding.getFirst();
            String encodingVersionStr = topNEncoding.getSecond();
            if (StringUtils.isEmpty((CharSequence)encoding) || "dict".equals(encoding)) {
                dimensionEncodings[i] = new DictionaryDimEnc(dictionaryMap.get(colRef));
                continue;
            }
            int encodingVersion = 1;
            if (!StringUtils.isEmpty((CharSequence)encodingVersionStr)) {
                try {
                    encodingVersion = Integer.parseInt(encodingVersionStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(CONFIG_ENCODING_VERSION_PREFIX + colRef.getName() + " has to be an integer");
                }
            }
            Object[] encodingConf = DimensionEncoding.parseEncodingConf(encoding);
            String encodingName = (String)encodingConf[0];
            String[] encodingArgs = (String[])encodingConf[1];
            encodingArgs = DateDimEnc.replaceEncodingArgs(encoding, encodingArgs, encodingName, literalCols.get(i).getType());
            dimensionEncodings[i] = DimensionEncodingFactory.create(encodingName, encodingArgs, encodingVersion);
        }
        return dimensionEncodings;
    }

    private TblColRef getTopNNumericColumn(FunctionDesc functionDesc) {
        if (functionDesc.getParameter().isColumnType()) {
            return functionDesc.getParameter().getColRefs().get(0);
        }
        return null;
    }

    private List<TblColRef> getTopNLiteralColumn(FunctionDesc functionDesc) {
        List<TblColRef> allColumns = functionDesc.getParameter().getColRefs();
        if (!functionDesc.getParameter().isColumnType()) {
            return allColumns;
        }
        return allColumns.subList(1, allColumns.size());
    }

    private boolean isTopN(FunctionDesc functionDesc) {
        return FUNC_TOP_N.equalsIgnoreCase(functionDesc.getExpression());
    }

    public static final Pair<String, String> getEncoding(FunctionDesc functionDesc, TblColRef tblColRef) {
        String encoding = functionDesc.getConfiguration().get(CONFIG_ENCODING_PREFIX + tblColRef.getIdentity());
        String encodingVersion = functionDesc.getConfiguration().get(CONFIG_ENCODING_VERSION_PREFIX + tblColRef.getIdentity());
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = functionDesc.getConfiguration().get(CONFIG_ENCODING_PREFIX + tblColRef.getName());
            encodingVersion = functionDesc.getConfiguration().get(CONFIG_ENCODING_VERSION_PREFIX + tblColRef.getName());
        }
        return new Pair<String, String>(encoding, encodingVersion);
    }

    public static class Factory
    extends MeasureTypeFactory<TopNCounter<ByteArray>> {
        @Override
        public MeasureType<TopNCounter<ByteArray>> createMeasureType(String funcName, DataType dataType) {
            return new TopNMeasureType(dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return TopNMeasureType.FUNC_TOP_N;
        }

        @Override
        public String getAggrDataTypeName() {
            return TopNMeasureType.DATATYPE_TOPN;
        }

        @Override
        public Class<? extends DataTypeSerializer<TopNCounter<ByteArray>>> getAggrDataTypeSerializer() {
            return TopNCounterSerializer.class;
        }
    }
}

