/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class ConstantTupleExpression
extends TupleExpression {
    public static final ConstantTupleExpression ZERO = new ConstantTupleExpression(0);
    private Object value;

    public ConstantTupleExpression(Object value) {
        this(ConstantTupleExpression.referDataType(value), value);
    }

    public ConstantTupleExpression(DataType dataType, Object value) {
        super(dataType, TupleExpression.ExpressionOperatorEnum.CONSTANT, Collections.emptyList());
        this.value = this.referValue(value);
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void verify() {
    }

    @Override
    public Object calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return this.value;
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitConstant(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.serializer.serialize(this.value, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.value = this.serializer.deserialize(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantTupleExpression that = (ConstantTupleExpression)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static DataType referDataType(Object value) {
        if (value instanceof Number) {
            if (value instanceof Short || value instanceof Integer || value instanceof Long) {
                return DataType.getType("bigint");
            }
            if (value instanceof BigDecimal) {
                return DataType.getType("decimal");
            }
            return DataType.getType("double");
        }
        return DataType.getType("varchar");
    }
}

