/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.tuple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.metadata.model.TblColRef;

public class TupleInfo {
    private final Map<String, Integer> fieldMap = new HashMap<String, Integer>();
    private final Map<TblColRef, Integer> columnMap = new HashMap<TblColRef, Integer>();
    private final List<String> fields = new ArrayList<String>();
    private final List<TblColRef> columns = new ArrayList<TblColRef>();
    private final List<String> dataTypeNames = new ArrayList<String>();

    public TblColRef getColumn(String fieldName) {
        int idx = this.getFieldIndex(fieldName);
        return this.columns.get(idx);
    }

    public TblColRef getColumn(int idx) {
        return this.columns.get(idx);
    }

    public int getColumnIndex(TblColRef col) {
        return this.columnMap.get(col);
    }

    public String getDataTypeName(int index) {
        return this.dataTypeNames.get(index);
    }

    public int getFieldIndex(String fieldName) {
        return this.fieldMap.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }

    public String getFieldName(TblColRef col) {
        int idx = this.columnMap.get(col);
        return this.fields.get(idx);
    }

    public boolean hasColumn(TblColRef col) {
        return this.columnMap.containsKey(col);
    }

    public void setField(String fieldName, TblColRef col, int index) {
        this.fieldMap.put(fieldName, index);
        if (col != null) {
            this.columnMap.put(col, index);
        }
        if (this.fields.size() > index) {
            this.fields.set(index, fieldName);
        } else {
            this.fields.add(index, fieldName);
        }
        if (this.columns.size() > index) {
            this.columns.set(index, col);
        } else {
            this.columns.add(index, col);
        }
        if (col != null) {
            if (this.dataTypeNames.size() > index) {
                this.dataTypeNames.set(index, col.getColumnDesc().getUpgradedType().getName());
            } else {
                this.dataTypeNames.add(index, col.getColumnDesc().getUpgradedType().getName());
            }
        }
    }

    public List<String> getAllFields() {
        return this.fields;
    }

    public List<TblColRef> getAllColumns() {
        return this.columns;
    }

    public int size() {
        return this.fields.size();
    }
}

