/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.logging;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class SensitivePatternLayout
extends PatternLayout {
    private static final String PREFIX_GROUP_NAME = "prefix";
    private static final String SENSITIVE_GROUP_NAME = "sensitive";
    private static final String MASK = "******";
    private static final Pattern SENSITIVE_PATTERN = Pattern.compile(String.format(Locale.ROOT, "(?<%s>password\\s*[:=])(?<%s>[^,.!]*)", "prefix", "sensitive"), 2);

    @Override
    public String format(LoggingEvent event) {
        if (event.getMessage() instanceof String) {
            String maskedMessage = this.mask(event.getRenderedMessage());
            Throwable throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
            LoggingEvent maskedEvent = new LoggingEvent(event.fqnOfCategoryClass, Logger.getLogger(event.getLoggerName()), event.timeStamp, event.getLevel(), maskedMessage, throwable);
            return super.format(maskedEvent);
        }
        return super.format(event);
    }

    private String mask(String message) {
        Matcher matcher = SENSITIVE_PATTERN.matcher(message);
        if (matcher.find()) {
            return matcher.replaceAll(String.format(Locale.ROOT, "${%s}%s", PREFIX_GROUP_NAME, MASK));
        }
        return message;
    }
}

