/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.common.logging;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.common.logging.AbstractHdfsLogAppender;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.SparkEnv;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.utils.SparkHadoopUtils;
import scala.Function0;
import scala.runtime.AbstractFunction0;
import scala.runtime.BoxedUnit;

public class SparkExecutorHdfsAppender
extends AbstractHdfsLogAppender {
    private static final long A_DAY_MILLIS = 86400000L;
    private static final long A_HOUR_MILLIS = 3600000L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
    private SimpleDateFormat hourFormat = new SimpleDateFormat("HH", Locale.ROOT);
    @VisibleForTesting
    String outPutPath;
    @VisibleForTesting
    String executorId;
    @VisibleForTesting
    long startTime = 0L;
    @VisibleForTesting
    boolean rollingByHour = false;
    @VisibleForTesting
    int rollingPeriod = 5;
    private String metadataIdentifier;
    private String category;
    private String identifier;
    private String jobName;
    private String project;

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setMetadataIdentifier(String metadataIdentifier) {
        this.metadataIdentifier = metadataIdentifier;
    }

    public String getMetadataIdentifier() {
        return this.metadataIdentifier;
    }

    @Override
    void init() {
        LogLog.warn("metadataIdentifier -> " + this.getMetadataIdentifier());
        LogLog.warn("category -> " + this.getCategory());
        LogLog.warn("identifier -> " + this.getIdentifier());
        if (null != this.getProject()) {
            LogLog.warn("project -> " + this.getProject());
        }
        if (null != this.getJobName()) {
            LogLog.warn("jobName -> " + this.getJobName());
        }
    }

    @Override
    String getAppenderName() {
        return "SparkExecutorHdfsAppender";
    }

    @Override
    boolean isSkipCheckAndFlushLog() {
        if (SparkEnv.get() == null && StringUtils.isBlank(this.executorId)) {
            LogLog.warn("Waiting for spark executor to start");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LogLog.error("Waiting for spark executor starting is interrupted!", e);
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    @Override
    void doWriteLog(int size, List<LoggingEvent> transaction) throws IOException, InterruptedException {
        while (size > 0) {
            final LoggingEvent loggingEvent = this.getLogBufferQue().take();
            if (this.isTimeChanged(loggingEvent)) {
                this.updateOutPutDir(loggingEvent);
                final Path file = new Path(this.outPutPath);
                String sparkuser = System.getenv("SPARK_USER");
                String user = System.getenv("USER");
                LogLog.warn("login user is " + UserGroupInformation.getLoginUser() + " SPARK_USER is " + sparkuser + " USER is " + user);
                SparkHadoopUtil.get().runAsSparkUser((Function0)new AbstractFunction0<BoxedUnit>(){

                    public BoxedUnit apply() {
                        if (!SparkExecutorHdfsAppender.this.initHdfsWriter(file, SparkHadoopUtils.newConfigurationWithSparkConf())) {
                            LogLog.error("Failed to init the hdfs writer!");
                        }
                        try {
                            SparkExecutorHdfsAppender.this.doRollingClean(loggingEvent);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            transaction.add(loggingEvent);
            this.writeLogEvent(loggingEvent);
            --size;
        }
    }

    @VisibleForTesting
    void updateOutPutDir(LoggingEvent event) {
        if (this.rollingByHour) {
            String rollingDir = this.dateFormat.format(new Date(event.getTimeStamp())) + "/" + this.hourFormat.format(new Date(event.getTimeStamp()));
            this.outPutPath = this.getOutPutDir(rollingDir);
        } else {
            String rollingDir = this.dateFormat.format(new Date(event.getTimeStamp()));
            this.outPutPath = this.getOutPutDir(rollingDir);
        }
        LogLog.warn("Update to " + this.outPutPath);
    }

    private String getOutPutDir(String rollingDir) {
        if (StringUtils.isBlank(this.executorId)) {
            this.executorId = SparkEnv.get() != null ? SparkEnv.get().executorId() : UUID.randomUUID().toString();
            LogLog.warn("executorId set to " + this.executorId);
        }
        if ("job".equals(this.getCategory())) {
            return this.getRootPathName() + "/" + rollingDir + "/" + this.getIdentifier() + "/" + this.getJobName() + "/executor-" + this.executorId + ".log";
        }
        return this.getRootPathName() + "/" + rollingDir + "/" + this.getIdentifier() + "/executor-" + this.executorId + ".log";
    }

    @VisibleForTesting
    void doRollingClean(LoggingEvent event) throws IOException {
        String rootPathName;
        Path rootPath;
        FileSystem fileSystem = this.getFileSystem();
        if (!fileSystem.exists(rootPath = new Path(rootPathName = this.getRootPathName()))) {
            return;
        }
        FileStatus[] logFolders = fileSystem.listStatus(rootPath);
        if (logFolders == null) {
            return;
        }
        String thresholdDay = this.dateFormat.format(new Date(event.getTimeStamp() - 86400000L * (long)this.rollingPeriod));
        for (FileStatus fs : logFolders) {
            Path fullPath;
            String fileName = fs.getPath().getName();
            if (fileName.compareTo(thresholdDay) >= 0 || !fileSystem.exists(fullPath = new Path(rootPathName + File.separator + fileName))) continue;
            fileSystem.delete(fullPath, true);
        }
    }

    @VisibleForTesting
    String getRootPathName() {
        if ("job".equals(this.getCategory())) {
            return this.getHdfsWorkingDir() + "/" + this.getProject() + "/spark_logs/executor/";
        }
        if ("sparder".equals(this.getCategory())) {
            return this.parseHdfsWorkingDir() + "/_sparder_logs";
        }
        throw new IllegalArgumentException("illegal category: " + this.getCategory());
    }

    @VisibleForTesting
    boolean isTimeChanged(LoggingEvent event) {
        if (this.rollingByHour) {
            return this.isNeedRolling(event, 3600000L);
        }
        return this.isNeedRolling(event, 86400000L);
    }

    private boolean isNeedRolling(LoggingEvent event, Long timeInterval) {
        if (0L == this.startTime || event.getTimeStamp() / timeInterval - this.startTime / timeInterval > 0L) {
            this.startTime = event.getTimeStamp();
            return true;
        }
        return false;
    }

    private String parseHdfsWorkingDir() {
        String root = this.getHdfsWorkingDir();
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String metaId = this.getMetadataIdentifier().replace(':', '-');
        if (metaId.startsWith("../")) {
            metaId = metaId.replace("../", "");
            metaId = metaId.replace('/', '-');
        }
        if (!(root = new Path(path, metaId).toString()).endsWith("/")) {
            root = root + "/";
        }
        return root;
    }
}

