/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.spark.job.NSparkCleanupHdfsStorageStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateCubeInfoAfterOptimizeStep;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;

public class NSparkBatchOptimizeJobCheckpointBuilder {
    protected SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    protected final CubeInstance cube;
    protected final String submitter;

    public NSparkBatchOptimizeJobCheckpointBuilder(CubeInstance cube, String submitter) {
        this.cube = cube;
        this.submitter = submitter;
        Preconditions.checkNotNull((Object)cube.getFirstSegment(), (Object)("Cube " + cube + " is empty!!!"));
    }

    public CheckpointExecutable build() {
        KylinConfig kylinConfig = this.cube.getConfig();
        List<ProjectInstance> projList = ProjectManager.getInstance(kylinConfig).findProjects(this.cube.getType(), this.cube.getName());
        if (projList == null || projList.size() == 0) {
            throw new RuntimeException("Cannot find the project containing the cube " + this.cube.getName() + "!!!");
        }
        if (projList.size() >= 2) {
            throw new RuntimeException("Find more than one project containing the cube " + this.cube.getName() + ". It does't meet the uniqueness requirement!!! ");
        }
        CheckpointExecutable checkpointJob = new CheckpointExecutable();
        checkpointJob.setSubmitter(this.submitter);
        CubingExecutableUtil.setCubeName(this.cube.getName(), checkpointJob.getParams());
        checkpointJob.setName(this.cube.getName() + " - OPTIMIZE CHECKPOINT - " + this.format.format(new Date(System.currentTimeMillis())));
        checkpointJob.setProjectName(projList.get(0).getName());
        checkpointJob.addTask(this.createUpdateCubeInfoAfterCheckpointStep());
        checkpointJob.addTask(this.createCleanupHdfsStorageStep());
        return checkpointJob;
    }

    private NSparkUpdateCubeInfoAfterOptimizeStep createUpdateCubeInfoAfterCheckpointStep() {
        NSparkUpdateCubeInfoAfterOptimizeStep result = new NSparkUpdateCubeInfoAfterOptimizeStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.cube.getName(), result.getParams());
        return result;
    }

    private NSparkCleanupHdfsStorageStep createCleanupHdfsStorageStep() {
        NSparkCleanupHdfsStorageStep result = new NSparkCleanupHdfsStorageStep();
        result.setName("Garbage Collection on HDFS");
        CubingExecutableUtil.setCubeName(this.cube.getName(), result.getParams());
        return result;
    }
}

