/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.TableAnalysisJob;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.apache.spark.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAnalyzerJob
extends SparkApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(TableAnalyzerJob.class);
    public static final ImmutableList<String> TABLE_STATS_METRICS = ImmutableList.builder().add((Object[])new String[]{"COUNT", "COUNT_DISTINCT", "MAX", "MIN"}).build();
    public static final String P_TABLE_NAME = "table";
    public static final String P_SAMPLING_ROWS = "maxSampleCount";

    @Override
    protected void doExecute() throws Exception {
        String tableName = this.getParam(P_TABLE_NAME);
        long rowCount = Long.parseLong(this.getParam(P_SAMPLING_ROWS));
        TableDesc tableDesc = TableMetadataManager.getInstance(this.config).getTableDesc(tableName, this.project);
        this.analyzeTable(tableDesc, this.project, (int)rowCount, this.config, this.ss);
    }

    private void analyzeTable(TableDesc tableDesc, String project, int rowCount, KylinConfig config, SparkSession ss) {
        long start = System.currentTimeMillis();
        TableAnalysisJob tableAnalysisJob = new TableAnalysisJob(tableDesc, project, rowCount, ss, this.jobId);
        Dataset<Row> sampleTableDataSet = tableAnalysisJob.getSampleTableDataSet();
        Row[] row = tableAnalysisJob.analyzeTable(sampleTableDataSet);
        logger.info("sampling rows from table {} takes {}s", (Object)tableDesc.getIdentity(), (Object)((System.currentTimeMillis() - start) / 1000L));
        TableMetadataManager tableMetadataManager = TableMetadataManager.getInstance(config);
        TableExtDesc tableExt = tableMetadataManager.getTableExt(tableDesc);
        long count_star = Long.parseLong(row[0].get(0).toString());
        tableExt.setTotalRows(count_star);
        ArrayList<TableExtDesc.ColumnStats> columnStatsList = new ArrayList<TableExtDesc.ColumnStats>(tableDesc.getColumnCount());
        for (int colIdx = 0; colIdx < tableDesc.getColumnCount(); ++colIdx) {
            ColumnDesc columnDesc = tableDesc.getColumns()[colIdx];
            if (columnDesc.isComputedColumn()) continue;
            TableExtDesc.ColumnStats colStats = tableExt.getColumnStatsByName(columnDesc.getName());
            if (colStats == null) {
                colStats = new TableExtDesc.ColumnStats();
                colStats.setColumnName(columnDesc.getName());
            }
            int metricLen = TABLE_STATS_METRICS.size();
            long count = 0L;
            block15: for (int i2 = 0; i2 < metricLen; ++i2) {
                String value = row[0].get(i2 + 1 + metricLen * colIdx) == null ? null : row[0].get(i2 + 1 + metricLen * colIdx).toString();
                switch ((String)TABLE_STATS_METRICS.get(i2)) {
                    case "COUNT": {
                        colStats.setNullCount(count_star - Long.parseLong(value));
                        count = Long.parseLong(value);
                        continue block15;
                    }
                    case "MAX": {
                        colStats.setMaxValue(value);
                        continue block15;
                    }
                    case "MIN": {
                        colStats.setMinValue(value);
                        continue block15;
                    }
                    case "COUNT_DISTINCT": {
                        colStats.setCardinality(Long.parseLong(value));
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("not support this metric" + (String)TABLE_STATS_METRICS.get(i2) + "in table Sampling");
                    }
                }
            }
            columnStatsList.add(colStats);
        }
        tableExt.setColumnStats(columnStatsList);
        ArrayList sampleData = Lists.newArrayList();
        IntStream.range(1, row.length).forEach(i -> {
            String[] data = new String[row[i].length()];
            IntStream.range(0, row[i].length()).forEach(j -> {
                Object obj = row[i].get(j);
                data[j] = obj == null ? null : (obj instanceof Timestamp ? DateFormat.formatToDateStr(((Timestamp)obj).getTime()) : obj.toString());
            });
            sampleData.add(data);
        });
        tableExt.setSampleRows(sampleData);
        tableExt.setJodID(this.jobId);
        try {
            tableMetadataManager.saveTableExt(tableExt, project);
        }
        catch (IOException e) {
            logger.error("save {} table ext found error !", (Object)tableExt);
            e.printStackTrace();
        }
        logger.info("Table {} analysis finished, update table ext desc done.", (Object)tableDesc.getName());
    }

    @Override
    protected String calculateRequiredCores() throws Exception {
        String tableName = this.getParam(P_TABLE_NAME);
        Path shareDir = this.config.getJobTmpShareDir(this.project, this.jobId);
        String child = tableName + "_" + ResourceDetectUtils.samplingDetectItemFileSuffix();
        Map<String, String> detectItems = ResourceDetectUtils.readDetectItems(new Path(shareDir, child));
        return ResourceUtils.caculateRequiredCores(detectItems);
    }

    public static void main(String[] args) {
        TableAnalyzerJob job = new TableAnalyzerJob();
        job.execute(args);
    }
}

