/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.measure.hllc.DenseRegister;
import org.apache.kylin.measure.hllc.HyperLogLogPlusTable;
import org.apache.kylin.measure.hllc.Register;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.measure.hllc.SingleValueRegister;
import org.apache.kylin.measure.hllc.SparseRegister;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;

public class HLLCounter
implements Serializable,
Comparable<HLLCounter> {
    static double[] harmonicMean = new double[256];
    static double OVERFLOW_FACTOR;
    private int p;
    private int m;
    private HashFunction hashFunc = Hashing.murmur3_128();
    private Register register;

    public HLLCounter() {
        this(14, RegisterType.SINGLE_VALUE, Hashing.murmur3_128());
    }

    public HLLCounter(int p) {
        this(p, RegisterType.SINGLE_VALUE, Hashing.murmur3_128());
    }

    public HLLCounter(int p, HashFunction hashFunc) {
        this(p, RegisterType.SINGLE_VALUE, hashFunc);
    }

    public HLLCounter(HLLCounter another) {
        this(another.p, another.getRegisterType(), another.hashFunc);
        if (another.getRegisterType() == RegisterType.DENSE) {
            ((DenseRegister)this.register).copyFrom((DenseRegister)another.register);
        } else {
            this.merge(another);
        }
    }

    public HLLCounter(int p, RegisterType type) {
        this(p, type, Hashing.murmur3_128());
    }

    HLLCounter(int p, RegisterType type, HashFunction hashFunc) {
        this.p = p;
        this.m = 1 << p;
        this.hashFunc = hashFunc;
        this.register = type == RegisterType.SINGLE_VALUE ? new SingleValueRegister() : (type == RegisterType.SPARSE ? new SparseRegister() : new DenseRegister(p));
    }

    public boolean isDense(int size) {
        double over = OVERFLOW_FACTOR * (double)this.m;
        return size > (int)over;
    }

    public void add(int value) {
        this.add(this.hashFunc.hashInt(value).asLong());
    }

    public void add(String value) {
        this.add(this.hashFunc.hashString(value, Charset.defaultCharset()).asLong());
    }

    public void add(byte[] value) {
        this.add(this.hashFunc.hashBytes(value).asLong());
    }

    public void add(byte[] value, int offset, int length) {
        this.add(this.hashFunc.hashBytes(value, offset, length).asLong());
    }

    public void addHashDirectly(long hash) {
        this.add(hash);
    }

    protected void add(long hash) {
        int bucketMask = this.m - 1;
        int bucket = (int)(hash & (long)bucketMask);
        int firstOnePos = Long.numberOfLeadingZeros(hash | (long)bucketMask) + 1;
        if (this.register.getRegisterType() == RegisterType.SINGLE_VALUE) {
            SingleValueRegister sr = (SingleValueRegister)this.register;
            int pos = sr.getSingleValuePos();
            if (pos < 0 || pos == bucket) {
                this.setIfBigger(this.register, bucket, (byte)firstOnePos);
            } else {
                this.register = sr.toSparse();
                this.setIfBigger(this.register, bucket, (byte)firstOnePos);
            }
        } else {
            this.setIfBigger(this.register, bucket, (byte)firstOnePos);
            this.toDenseIfNeeded();
        }
    }

    private void setIfBigger(Register register, int pos, byte value) {
        byte b = register.get(pos);
        if (value > b) {
            register.set(pos, value);
        }
    }

    private void toDenseIfNeeded() {
        if (this.register.getRegisterType() == RegisterType.SPARSE && this.isDense(this.register.getSize())) {
            this.register = ((SparseRegister)this.register).toDense(this.p);
        }
    }

    public void merge(HLLCounter another) {
        assert (this.p == another.p);
        assert (this.hashFunc.equals(another.hashFunc));
        block0 : switch (this.register.getRegisterType()) {
            case SINGLE_VALUE: {
                switch (another.getRegisterType()) {
                    case SINGLE_VALUE: {
                        if (this.register.getSize() > 0 && another.register.getSize() > 0) {
                            this.register = ((SingleValueRegister)this.register).toSparse();
                            break block0;
                        }
                        SingleValueRegister sr = (SingleValueRegister)another.register;
                        if (sr.getSize() > 0) {
                            this.register.set(sr.getSingleValuePos(), sr.getValue());
                        }
                        return;
                    }
                    case SPARSE: {
                        this.register = ((SingleValueRegister)this.register).toSparse();
                        break block0;
                    }
                    case DENSE: {
                        this.register = ((SingleValueRegister)this.register).toDense(this.p);
                        break block0;
                    }
                }
                break;
            }
            case SPARSE: {
                if (another.getRegisterType() != RegisterType.DENSE) break;
                this.register = ((SparseRegister)this.register).toDense(this.p);
                break;
            }
        }
        this.register.merge(another.register);
        this.toDenseIfNeeded();
    }

    public long getCountEstimate() {
        return new HLLCSnapshot(this).getCountEstimate();
    }

    public int getPrecision() {
        return this.p;
    }

    public double getErrorRate() {
        return 1.04 / Math.sqrt(this.m);
    }

    public String toString() {
        return "" + this.getCountEstimate();
    }

    public static void main(String[] args) throws IOException {
        HLLCounter.dumpErrorRates();
    }

    static void dumpErrorRates() {
        for (int p = 10; p <= 18; ++p) {
            double rate = new HLLCounter(p, RegisterType.SPARSE).getErrorRate();
            double er = (double)Math.round(rate * 10000.0) / 100.0;
            double er2 = (double)Math.round(rate * 2.0 * 10000.0) / 100.0;
            double er3 = (double)Math.round(rate * 3.0 * 10000.0) / 100.0;
            long size = Math.round(Math.pow(2.0, p));
            System.out.println("HLLC" + p + ",\t" + size + " bytes,\t68% err<" + er + "%,\t95% err<" + er2 + "%,\t99.7% err<" + er3 + "%");
        }
    }

    public Register getRegister() {
        return this.register;
    }

    public void clear() {
        this.register.clear();
    }

    public void writeRegisters(ByteBuffer out) throws IOException {
        int indexLen = this.getRegisterIndexSize();
        int size = this.register.getSize();
        byte scheme = this.register instanceof SingleValueRegister || this.register instanceof SparseRegister || 5 + (indexLen + 1) * size < this.m ? (byte)0 : 1;
        out.put(scheme);
        if (scheme == 0) {
            BytesUtil.writeVInt(size, out);
            if (this.register.getRegisterType() == RegisterType.SINGLE_VALUE) {
                if (size > 0) {
                    SingleValueRegister sr = (SingleValueRegister)this.register;
                    HLLCounter.writeUnsigned(sr.getSingleValuePos(), indexLen, out);
                    out.put(sr.getValue());
                }
            } else if (this.register.getRegisterType() == RegisterType.SPARSE) {
                Collection<Map.Entry<Integer, Byte>> allValue = ((SparseRegister)this.register).getAllValue();
                for (Map.Entry<Integer, Byte> entry : allValue) {
                    HLLCounter.writeUnsigned(entry.getKey(), indexLen, out);
                    out.put(entry.getValue());
                }
            } else {
                byte[] registers = ((DenseRegister)this.register).getRawRegister();
                for (int i = 0; i < this.m; ++i) {
                    if (registers[i] <= 0) continue;
                    HLLCounter.writeUnsigned(i, indexLen, out);
                    out.put(registers[i]);
                }
            }
        } else if (scheme == 1) {
            out.put(((DenseRegister)this.register).getRawRegister());
        } else {
            throw new IllegalStateException();
        }
    }

    public void readRegisters(ByteBuffer in) throws IOException {
        byte scheme = in.get();
        if (scheme == 0) {
            this.clear();
            int size = BytesUtil.readVInt(in);
            if (size > this.m) {
                throw new IllegalArgumentException("register size (" + size + ") cannot be larger than m (" + this.m + ")");
            }
            this.register = this.isDense(size) ? new DenseRegister(this.p) : (size <= 1 ? new SingleValueRegister() : new SparseRegister());
            int indexLen = this.getRegisterIndexSize();
            int key = 0;
            for (int i = 0; i < size; ++i) {
                key = HLLCounter.readUnsigned(in, indexLen);
                this.register.set(key, in.get());
            }
        } else if (scheme == 1) {
            if (this.register.getRegisterType() != RegisterType.DENSE) {
                this.register = new DenseRegister(this.p);
            }
            in.get(((DenseRegister)this.register).getRawRegister());
        } else {
            throw new IllegalStateException();
        }
    }

    public int peekLength(ByteBuffer in) {
        int len;
        int mark = in.position();
        byte scheme = in.get();
        if (scheme == 0) {
            int size = BytesUtil.readVInt(in);
            int indexLen = this.getRegisterIndexSize();
            len = in.position() - mark + (indexLen + 1) * size;
        } else {
            len = in.position() - mark + this.m;
        }
        in.position(mark);
        return len;
    }

    public int maxLength() {
        return 1 + this.m;
    }

    public int getRegisterIndexSize() {
        return (this.p - 1) / 8 + 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunc == null ? 0 : this.hashFunc.hashCode());
        result = 31 * result + this.p;
        result = 31 * result + this.register.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HLLCounter other = (HLLCounter)obj;
        if (!this.hashFunc.equals(other.hashFunc)) {
            return false;
        }
        if (this.p != other.p) {
            return false;
        }
        return this.register.equals(other.register);
    }

    @Override
    public int compareTo(HLLCounter o) {
        long e2;
        if (o == null) {
            return 1;
        }
        long e1 = this.getCountEstimate();
        if (e1 == (e2 = o.getCountEstimate())) {
            return 0;
        }
        if (e1 > e2) {
            return 1;
        }
        return -1;
    }

    public static void writeUnsigned(int num, int size, ByteBuffer out) {
        for (int i = 0; i < size; ++i) {
            out.put((byte)num);
            num >>>= 8;
        }
    }

    public static int readUnsigned(ByteBuffer in, int size) {
        int integer = 0;
        int mask = 255;
        int shift = 0;
        for (int i = 0; i < size; ++i) {
            integer |= in.get() << shift & mask;
            mask <<= 8;
            shift += 8;
        }
        return integer;
    }

    public RegisterType getRegisterType() {
        return this.register.getRegisterType();
    }

    static {
        for (int i = 1; i < 256; ++i) {
            HLLCounter.harmonicMean[i] = 1.0 / (double)(1L << i);
        }
        OVERFLOW_FACTOR = 0.01;
    }

    public static class HLLCSnapshot {
        byte p;
        double registerSum;
        int zeroBuckets;

        public HLLCSnapshot(HLLCounter hllc) {
            int i;
            int[] registerNums = new int[256];
            this.p = (byte)hllc.p;
            this.registerSum = 0.0;
            this.zeroBuckets = 0;
            Register register = hllc.getRegister();
            DenseRegister dr = register.getRegisterType() == RegisterType.SINGLE_VALUE ? ((SingleValueRegister)register).toDense(this.p) : (register.getRegisterType() == RegisterType.SPARSE ? ((SparseRegister)register).toDense(this.p) : (DenseRegister)register);
            byte[] registers = dr.getRawRegister();
            for (i = 0; i < hllc.m; ++i) {
                byte by = registers[i];
                registerNums[by] = registerNums[by] + 1;
            }
            this.zeroBuckets = registerNums[0];
            for (i = 1; i < 256; ++i) {
                this.registerSum += (double)registerNums[i] * harmonicMean[i];
            }
            this.registerSum += (double)this.zeroBuckets;
        }

        public long getCountEstimate() {
            int m = 1 << this.p;
            double alpha = 0.7213 / (1.0 + 1.079 / (double)m);
            double estimate = alpha * (double)m * (double)m / this.registerSum;
            if ((double)this.zeroBuckets >= (double)m * 0.07) {
                estimate = (double)m * Math.log((double)m * 1.0 / (double)this.zeroBuckets);
            } else if (HyperLogLogPlusTable.isBiasCorrection(m, estimate)) {
                estimate = HyperLogLogPlusTable.biasCorrection(this.p, estimate);
            }
            return Math.round(estimate);
        }
    }
}

