/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.metadata.datatype.BigDecimalSerializer;
import org.apache.kylin.metadata.datatype.BooleanSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DateTimeSerializer;
import org.apache.kylin.metadata.datatype.DoubleSerializer;
import org.apache.kylin.metadata.datatype.Int4Serializer;
import org.apache.kylin.metadata.datatype.Long8Serializer;
import org.apache.kylin.metadata.datatype.LongSerializer;
import org.apache.kylin.metadata.datatype.StringSerializer;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public abstract class DataTypeSerializer<T>
implements BytesSerializer<T>,
Serializable {
    static final Map<String, Class<?>> implementations = Maps.newHashMap();
    protected transient ThreadLocal current = new ThreadLocal();

    public static void register(String dataTypeName, Class<? extends DataTypeSerializer<?>> impl) {
        implementations.put(dataTypeName, impl);
    }

    public static DataTypeSerializer<?> create(String dataType) {
        return DataTypeSerializer.create(DataType.getType(dataType));
    }

    public static DataTypeSerializer<?> create(DataType type) {
        Class<?> clz = implementations.get(type.getName());
        if (clz == null) {
            throw new RuntimeException("No DataTypeSerializer for type " + type);
        }
        try {
            return (DataTypeSerializer)clz.getConstructor(DataType.class).newInstance(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract int peekLength(ByteBuffer var1);

    public abstract int maxLength();

    public abstract int getStorageBytesEstimate();

    protected double getStorageBytesEstimate(double count) {
        return 0.0;
    }

    public T valueOf(String str) {
        throw new UnsupportedOperationException();
    }

    public boolean supportDirectReturnResult() {
        return false;
    }

    public ByteBuffer getFinalResult(ByteBuffer in) {
        throw new UnsupportedOperationException();
    }

    public String toString(T value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.current = new ThreadLocal();
    }

    static {
        implementations.put("char", StringSerializer.class);
        implementations.put("varchar", StringSerializer.class);
        implementations.put("decimal", BigDecimalSerializer.class);
        implementations.put("double", DoubleSerializer.class);
        implementations.put("float", DoubleSerializer.class);
        implementations.put("bigint", LongSerializer.class);
        implementations.put("long", LongSerializer.class);
        implementations.put("integer", LongSerializer.class);
        implementations.put("int", LongSerializer.class);
        implementations.put("tinyint", LongSerializer.class);
        implementations.put("smallint", LongSerializer.class);
        implementations.put("int4", Int4Serializer.class);
        implementations.put("long8", Long8Serializer.class);
        implementations.put("boolean", BooleanSerializer.class);
        implementations.put("date", DateTimeSerializer.class);
        implementations.put("datetime", DateTimeSerializer.class);
        implementations.put("timestamp", DateTimeSerializer.class);
    }
}

