/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimedRecordEvent;
import org.apache.kylin.metrics.property.QuerySparkExecutionEnum;
import org.apache.kylin.metrics.property.QuerySparkJobEnum;
import org.apache.kylin.metrics.property.QuerySparkStageEnum;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.cache.RemovalListener;
import org.apache.kylin.shaded.com.google.common.cache.RemovalNotification;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySparkMetrics {
    private static final Logger logger = LoggerFactory.getLogger(QuerySparkMetrics.class);
    private static ScheduledExecutorService scheduledExecutor = null;
    private static QuerySparkMetrics instance = new QuerySparkMetrics(new QuerySparkMetricsRemovalListener());
    private static final int sparkMetricsNum = 10;
    private Cache<String, QueryExecutionMetrics> queryExecutionMetricsMap;

    private QuerySparkMetrics(RemovalListener removalListener) {
        if (this.queryExecutionMetricsMap != null) {
            this.queryExecutionMetricsMap.cleanUp();
            this.queryExecutionMetricsMap = null;
        }
        this.queryExecutionMetricsMap = CacheBuilder.newBuilder().maximumSize(KylinConfig.getInstanceFromEnv().getKylinMetricsCacheMaxEntries()).expireAfterWrite(KylinConfig.getInstanceFromEnv().getKylinMetricsCacheExpireSeconds(), TimeUnit.SECONDS).removalListener(removalListener).build();
        if (scheduledExecutor != null && !scheduledExecutor.isShutdown()) {
            scheduledExecutor.shutdown();
            scheduledExecutor = null;
        }
        scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                QuerySparkMetrics.this.queryExecutionMetricsMap.cleanUp();
            }
        }, KylinConfig.getInstanceFromEnv().getKylinMetricsCacheExpireSeconds(), KylinConfig.getInstanceFromEnv().getKylinMetricsCacheExpireSeconds(), TimeUnit.SECONDS);
    }

    private void shutdown() {
        this.queryExecutionMetricsMap.invalidateAll();
    }

    @VisibleForTesting
    public static void init(RemovalListener removalListener) {
        instance = new QuerySparkMetrics(removalListener);
    }

    public static QuerySparkMetrics getInstance() {
        return instance;
    }

    public void onJobStart(String queryId, String sparderName, long executionId, long executionStartTime, int jobId, long jobStartTime) {
        QueryExecutionMetrics queryExecutionMetrics = this.queryExecutionMetricsMap.getIfPresent(queryId);
        if (queryExecutionMetrics == null) {
            queryExecutionMetrics = new QueryExecutionMetrics();
            ConcurrentMap<Integer, SparkJobMetrics> sparkJobMetricsMap = Maps.newConcurrentMap();
            queryExecutionMetrics.setQueryId(queryId);
            queryExecutionMetrics.setSparderName(sparderName);
            queryExecutionMetrics.setExecutionId(executionId);
            queryExecutionMetrics.setStartTime(executionStartTime);
            queryExecutionMetrics.setSparkJobMetricsMap(sparkJobMetricsMap);
            this.queryExecutionMetricsMap.put(queryId, queryExecutionMetrics);
        }
        SparkJobMetrics sparkJobMetrics = new SparkJobMetrics();
        sparkJobMetrics.setExecutionId(executionId);
        sparkJobMetrics.setJobId(jobId);
        sparkJobMetrics.setStartTime(jobStartTime);
        ConcurrentMap<Integer, SparkStageMetrics> sparkStageMetricsMap = Maps.newConcurrentMap();
        sparkJobMetrics.setSparkStageMetricsMap(sparkStageMetricsMap);
        queryExecutionMetrics.getSparkJobMetricsMap().put(jobId, sparkJobMetrics);
    }

    public void onSparkStageStart(String queryId, int jobId, int stageId, String stageType, long submitTime) {
        QueryExecutionMetrics queryExecutionMetrics = this.queryExecutionMetricsMap.getIfPresent(queryId);
        if (queryExecutionMetrics != null && queryExecutionMetrics.getSparkJobMetricsMap().get(jobId) != null) {
            SparkStageMetrics sparkStageMetrics = new SparkStageMetrics();
            sparkStageMetrics.setStageId(stageId);
            sparkStageMetrics.setStageType(stageType);
            sparkStageMetrics.setSubmitTime(submitTime);
            ((SparkJobMetrics)queryExecutionMetrics.getSparkJobMetricsMap().get(jobId)).getSparkStageMetricsMap().put(stageId, sparkStageMetrics);
        }
    }

    public void updateSparkStageMetrics(String queryId, int jobId, int stageId, boolean isSuccess, SparkStageMetrics sparkStageMetricsEnd) {
        SparkStageMetrics sparkStageMetrics;
        SparkJobMetrics sparkJobMetrics;
        QueryExecutionMetrics queryExecutionMetrics = this.queryExecutionMetricsMap.getIfPresent(queryId);
        if (queryExecutionMetrics != null && (sparkJobMetrics = (SparkJobMetrics)queryExecutionMetrics.getSparkJobMetricsMap().get(jobId)) != null && (sparkStageMetrics = (SparkStageMetrics)sparkJobMetrics.getSparkStageMetricsMap().get(stageId)) != null) {
            sparkStageMetrics.setSuccess(isSuccess);
            sparkStageMetrics.setMetrics(sparkStageMetricsEnd.getResultSize(), sparkStageMetricsEnd.getExecutorDeserializeTime(), sparkStageMetricsEnd.getExecutorDeserializeCpuTime(), sparkStageMetricsEnd.getExecutorRunTime(), sparkStageMetricsEnd.getExecutorCpuTime(), sparkStageMetricsEnd.getJvmGCTime(), sparkStageMetricsEnd.getResultSerializationTime(), sparkStageMetricsEnd.getMemoryBytesSpilled(), sparkStageMetricsEnd.getDiskBytesSpilled(), sparkStageMetricsEnd.getPeakExecutionMemory());
        }
    }

    public void updateSparkJobMetrics(String queryId, int jobId, long jobEndTime, boolean isSuccess) {
        QueryExecutionMetrics queryExecutionMetrics = this.queryExecutionMetricsMap.getIfPresent(queryId);
        if (queryExecutionMetrics != null && queryExecutionMetrics.getSparkJobMetricsMap().get(jobId) != null) {
            SparkJobMetrics sparkJobMetrics = (SparkJobMetrics)queryExecutionMetrics.getSparkJobMetricsMap().get(jobId);
            sparkJobMetrics.setEndTime(jobEndTime);
            sparkJobMetrics.setSuccess(isSuccess);
        }
    }

    public void updateExecutionMetrics(String queryId, long executionEndTime) {
        QueryExecutionMetrics queryExecutionMetrics = this.queryExecutionMetricsMap.getIfPresent(queryId);
        if (queryExecutionMetrics != null) {
            queryExecutionMetrics.setEndTime(executionEndTime);
        }
    }

    public Cache<String, QueryExecutionMetrics> getQueryExecutionMetricsMap() {
        return this.queryExecutionMetricsMap;
    }

    public QueryExecutionMetrics getQueryExecutionMetrics(String queryId) {
        return this.queryExecutionMetricsMap.getIfPresent(queryId);
    }

    public static void updateMetricsToReservoir(String queryId, QueryExecutionMetrics queryExecutionMetrics) {
        if (!KylinConfig.getInstanceFromEnv().isKylinMetricsReporterForQueryEnabled()) {
            return;
        }
        if (queryExecutionMetrics != null) {
            TimedRecordEvent queryExecutionMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQueryExecution());
            QuerySparkMetrics.setQueryWrapper(queryExecutionMetricsEvent, queryExecutionMetrics.getUser(), queryExecutionMetrics.getSqlIdCode(), queryExecutionMetrics.getQueryType(), queryId, queryExecutionMetrics.getProject(), queryExecutionMetrics.getException());
            QuerySparkMetrics.setSparkExecutionWrapper(queryExecutionMetricsEvent, queryExecutionMetrics.getSparderName(), queryExecutionMetrics.getExecutionId(), queryExecutionMetrics.getRealization(), queryExecutionMetrics.getRealizationTypes(), queryExecutionMetrics.getCuboidIds(), queryExecutionMetrics.getStartTime(), queryExecutionMetrics.getEndTime());
            QuerySparkMetrics.setQueryMetrics(queryExecutionMetricsEvent, queryExecutionMetrics.getSqlDuration(), queryExecutionMetrics.getTotalScanCount(), queryExecutionMetrics.getTotalScanBytes(), queryExecutionMetrics.getResultCount());
            long[] queryExecutionMetricsList = new long[10];
            for (Map.Entry sparkJobMetricsEntry : queryExecutionMetrics.getSparkJobMetricsMap().entrySet()) {
                TimedRecordEvent sparkJobMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQuerySparkJob());
                QuerySparkMetrics.setSparkJobWrapper(sparkJobMetricsEvent, queryExecutionMetrics.getProject(), queryId, queryExecutionMetrics.getExecutionId(), ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).getJobId(), ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).getStartTime(), ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).getEndTime(), ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).isSuccess());
                long[] sparkJobMetricsList = new long[10];
                for (Map.Entry sparkStageMetricsEntry : ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).getSparkStageMetricsMap().entrySet()) {
                    TimedRecordEvent sparkStageMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQuerySparkStage());
                    SparkStageMetrics sparkStageMetrics = (SparkStageMetrics)sparkStageMetricsEntry.getValue();
                    QuerySparkMetrics.setStageWrapper(sparkStageMetricsEvent, queryExecutionMetrics.getProject(), null, queryId, queryExecutionMetrics.getExecutionId(), ((SparkJobMetrics)sparkJobMetricsEntry.getValue()).getJobId(), sparkStageMetrics.getStageId(), sparkStageMetrics.getSubmitTime(), sparkStageMetrics.isSuccess());
                    QuerySparkMetrics.setStageMetrics(sparkStageMetricsEvent, sparkStageMetrics.getResultSize(), sparkStageMetrics.getExecutorDeserializeTime(), sparkStageMetrics.getExecutorDeserializeCpuTime(), sparkStageMetrics.getExecutorRunTime(), sparkStageMetrics.getExecutorCpuTime(), sparkStageMetrics.getJvmGCTime(), sparkStageMetrics.getResultSerializationTime(), sparkStageMetrics.getMemoryBytesSpilled(), sparkStageMetrics.getDiskBytesSpilled(), sparkStageMetrics.getPeakExecutionMemory());
                    MetricsManager.getInstance().update(sparkStageMetricsEvent);
                    sparkJobMetricsList[0] = sparkJobMetricsList[0] + sparkStageMetrics.getResultSize();
                    sparkJobMetricsList[1] = sparkJobMetricsList[1] + sparkStageMetrics.getExecutorDeserializeTime();
                    sparkJobMetricsList[2] = sparkJobMetricsList[2] + sparkStageMetrics.getExecutorDeserializeCpuTime();
                    sparkJobMetricsList[3] = sparkJobMetricsList[3] + sparkStageMetrics.getExecutorRunTime();
                    sparkJobMetricsList[4] = sparkJobMetricsList[4] + sparkStageMetrics.getExecutorCpuTime();
                    sparkJobMetricsList[5] = sparkJobMetricsList[5] + sparkStageMetrics.getJvmGCTime();
                    sparkJobMetricsList[6] = sparkJobMetricsList[6] + sparkStageMetrics.getResultSerializationTime();
                    sparkJobMetricsList[7] = sparkJobMetricsList[7] + sparkStageMetrics.getMemoryBytesSpilled();
                    sparkJobMetricsList[8] = sparkJobMetricsList[8] + sparkStageMetrics.getDiskBytesSpilled();
                    sparkJobMetricsList[9] = sparkJobMetricsList[9] + sparkStageMetrics.getPeakExecutionMemory();
                }
                QuerySparkMetrics.setSparkJobMetrics(sparkJobMetricsEvent, sparkJobMetricsList[0], sparkJobMetricsList[1], sparkJobMetricsList[2], sparkJobMetricsList[3], sparkJobMetricsList[4], sparkJobMetricsList[5], sparkJobMetricsList[6], sparkJobMetricsList[7], sparkJobMetricsList[8], sparkJobMetricsList[9]);
                MetricsManager.getInstance().update(sparkJobMetricsEvent);
                for (int i = 0; i < 10; ++i) {
                    int n = i;
                    queryExecutionMetricsList[n] = queryExecutionMetricsList[n] + sparkJobMetricsList[i];
                }
            }
            QuerySparkMetrics.setSparkExecutionMetrics(queryExecutionMetricsEvent, queryExecutionMetrics.getEndTime() - queryExecutionMetrics.getStartTime(), queryExecutionMetricsList[0], queryExecutionMetricsList[1], queryExecutionMetricsList[2], queryExecutionMetricsList[3], queryExecutionMetricsList[4], queryExecutionMetricsList[5], queryExecutionMetricsList[6], queryExecutionMetricsList[7], queryExecutionMetricsList[8], queryExecutionMetricsList[9]);
            MetricsManager.getInstance().update(queryExecutionMetricsEvent);
        }
    }

    private static void setQueryWrapper(RecordEvent metricsEvent, String user, long sqlIdCode, String queryType, String queryId, String project, String exception) {
        metricsEvent.put(QuerySparkExecutionEnum.USER.toString(), (Object)user);
        metricsEvent.put(QuerySparkExecutionEnum.ID_CODE.toString(), (Object)sqlIdCode);
        metricsEvent.put(QuerySparkExecutionEnum.TYPE.toString(), (Object)queryType);
        metricsEvent.put(QuerySparkExecutionEnum.QUERY_ID.toString(), (Object)queryId);
        metricsEvent.put(QuerySparkExecutionEnum.PROJECT.toString(), (Object)project);
        metricsEvent.put(QuerySparkExecutionEnum.EXCEPTION.toString(), (Object)exception);
    }

    private static void setSparkExecutionWrapper(RecordEvent metricsEvent, String sparderName, long executionId, String realizationName, String realizationType, String cuboidIds, long startTime, long endTime) {
        metricsEvent.put(QuerySparkExecutionEnum.SPARDER_NAME.toString(), (Object)sparderName);
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTION_ID.toString(), (Object)executionId);
        metricsEvent.put(QuerySparkExecutionEnum.REALIZATION.toString(), (Object)realizationName);
        metricsEvent.put(QuerySparkExecutionEnum.REALIZATION_TYPE.toString(), (Object)realizationType);
        metricsEvent.put(QuerySparkExecutionEnum.CUBOID_IDS.toString(), (Object)cuboidIds);
        metricsEvent.put(QuerySparkExecutionEnum.START_TIME.toString(), (Object)startTime);
        metricsEvent.put(QuerySparkExecutionEnum.END_TIME.toString(), (Object)endTime);
    }

    private static void setQueryMetrics(RecordEvent metricsEvent, long sqlDuration, long totalScanCount, long totalScanBytes, long resultCount) {
        metricsEvent.put(QuerySparkExecutionEnum.TIME_COST.toString(), (Object)sqlDuration);
        metricsEvent.put(QuerySparkExecutionEnum.TOTAL_SCAN_COUNT.toString(), (Object)totalScanCount);
        metricsEvent.put(QuerySparkExecutionEnum.TOTAL_SCAN_BYTES.toString(), (Object)totalScanBytes);
        metricsEvent.put(QuerySparkExecutionEnum.RESULT_COUNT.toString(), (Object)resultCount);
    }

    private static void setSparkExecutionMetrics(RecordEvent metricsEvent, long executionDuration, long resultSize, long executorDeserializeTime, long executorDeserializeCpuTime, long executorRunTime, long executorCpuTime, long jvmGCTime, long resultSerializationTime, long memoryBytesSpilled, long diskBytesSpilled, long peakExecutionMemory) {
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTION_DURATION.toString(), (Object)executionDuration);
        metricsEvent.put(QuerySparkExecutionEnum.RESULT_SIZE.toString(), (Object)resultSize);
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)executorDeserializeTime);
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)executorDeserializeCpuTime);
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTOR_RUN_TIME.toString(), (Object)executorRunTime);
        metricsEvent.put(QuerySparkExecutionEnum.EXECUTOR_CPU_TIME.toString(), (Object)executorCpuTime);
        metricsEvent.put(QuerySparkExecutionEnum.JVM_GC_TIME.toString(), (Object)jvmGCTime);
        metricsEvent.put(QuerySparkExecutionEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)resultSerializationTime);
        metricsEvent.put(QuerySparkExecutionEnum.MEMORY_BYTE_SPILLED.toString(), (Object)memoryBytesSpilled);
        metricsEvent.put(QuerySparkExecutionEnum.DISK_BYTES_SPILLED.toString(), (Object)diskBytesSpilled);
        metricsEvent.put(QuerySparkExecutionEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)peakExecutionMemory);
    }

    private static void setSparkJobMetrics(RecordEvent metricsEvent, long resultSize, long executorDeserializeTime, long executorDeserializeCpuTime, long executorRunTime, long executorCpuTime, long jvmGCTime, long resultSerializationTime, long memoryBytesSpilled, long diskBytesSpilled, long peakExecutionMemory) {
        metricsEvent.put(QuerySparkJobEnum.RESULT_SIZE.toString(), (Object)resultSize);
        metricsEvent.put(QuerySparkJobEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)executorDeserializeTime);
        metricsEvent.put(QuerySparkJobEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)executorDeserializeCpuTime);
        metricsEvent.put(QuerySparkJobEnum.EXECUTOR_RUN_TIME.toString(), (Object)executorRunTime);
        metricsEvent.put(QuerySparkJobEnum.EXECUTOR_CPU_TIME.toString(), (Object)executorCpuTime);
        metricsEvent.put(QuerySparkJobEnum.JVM_GC_TIME.toString(), (Object)jvmGCTime);
        metricsEvent.put(QuerySparkJobEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)resultSerializationTime);
        metricsEvent.put(QuerySparkJobEnum.MEMORY_BYTE_SPILLED.toString(), (Object)memoryBytesSpilled);
        metricsEvent.put(QuerySparkJobEnum.DISK_BYTES_SPILLED.toString(), (Object)diskBytesSpilled);
        metricsEvent.put(QuerySparkJobEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)peakExecutionMemory);
    }

    private static void setStageMetrics(RecordEvent metricsEvent, long resultSize, long executorDeserializeTime, long executorDeserializeCpuTime, long executorRunTime, long executorCpuTime, long jvmGCTime, long resultSerializationTime, long memoryBytesSpilled, long diskBytesSpilled, long peakExecutionMemory) {
        metricsEvent.put(QuerySparkStageEnum.RESULT_SIZE.toString(), (Object)resultSize);
        metricsEvent.put(QuerySparkStageEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)executorDeserializeTime);
        metricsEvent.put(QuerySparkStageEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)executorDeserializeCpuTime);
        metricsEvent.put(QuerySparkStageEnum.EXECUTOR_RUN_TIME.toString(), (Object)executorRunTime);
        metricsEvent.put(QuerySparkStageEnum.EXECUTOR_CPU_TIME.toString(), (Object)executorCpuTime);
        metricsEvent.put(QuerySparkStageEnum.JVM_GC_TIME.toString(), (Object)jvmGCTime);
        metricsEvent.put(QuerySparkStageEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)resultSerializationTime);
        metricsEvent.put(QuerySparkStageEnum.MEMORY_BYTE_SPILLED.toString(), (Object)memoryBytesSpilled);
        metricsEvent.put(QuerySparkStageEnum.DISK_BYTES_SPILLED.toString(), (Object)diskBytesSpilled);
        metricsEvent.put(QuerySparkStageEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)peakExecutionMemory);
    }

    private static void setStageWrapper(RecordEvent metricsEvent, String projectName, String realizationName, String queryId, long executionId, int jobId, int stageId, long submitTime, boolean isSuccess) {
        metricsEvent.put(QuerySparkStageEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(QuerySparkStageEnum.REALIZATION.toString(), (Object)realizationName);
        metricsEvent.put(QuerySparkStageEnum.QUERY_ID.toString(), (Object)queryId);
        metricsEvent.put(QuerySparkStageEnum.EXECUTION_ID.toString(), (Object)executionId);
        metricsEvent.put(QuerySparkStageEnum.JOB_ID.toString(), (Object)jobId);
        metricsEvent.put(QuerySparkStageEnum.STAGE_ID.toString(), (Object)stageId);
        metricsEvent.put(QuerySparkStageEnum.SUBMIT_TIME.toString(), (Object)submitTime);
        metricsEvent.put(QuerySparkStageEnum.IF_SUCCESS.toString(), (Object)isSuccess);
    }

    private static void setSparkJobWrapper(RecordEvent metricsEvent, String projectName, String queryId, long executionId, int jobId, long startTime, long endTime, boolean isSuccess) {
        metricsEvent.put(QuerySparkJobEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(QuerySparkJobEnum.QUERY_ID.toString(), (Object)queryId);
        metricsEvent.put(QuerySparkJobEnum.EXECUTION_ID.toString(), (Object)executionId);
        metricsEvent.put(QuerySparkJobEnum.JOB_ID.toString(), (Object)jobId);
        metricsEvent.put(QuerySparkJobEnum.START_TIME.toString(), (Object)startTime);
        metricsEvent.put(QuerySparkJobEnum.END_TIME.toString(), (Object)endTime);
        metricsEvent.put(QuerySparkJobEnum.IF_SUCCESS.toString(), (Object)isSuccess);
    }

    public static class SparkStageMetrics
    implements Serializable {
        private int stageId;
        private String stageType;
        private long submitTime;
        private long endTime;
        private boolean isSuccess;
        private long resultSize;
        private long executorDeserializeTime;
        private long executorDeserializeCpuTime;
        private long executorRunTime;
        private long executorCpuTime;
        private long jvmGCTime;
        private long resultSerializationTime;
        private long memoryBytesSpilled;
        private long diskBytesSpilled;
        private long peakExecutionMemory;

        public void setMetrics(long resultSize, long executorDeserializeTime, long executorDeserializeCpuTime, long executorRunTime, long executorCpuTime, long jvmGCTime, long resultSerializationTime, long memoryBytesSpilled, long diskBytesSpilled, long peakExecutionMemory) {
            this.resultSize = resultSize;
            this.executorDeserializeTime = executorDeserializeTime;
            this.executorDeserializeCpuTime = executorDeserializeCpuTime;
            this.executorRunTime = executorRunTime;
            this.executorCpuTime = executorCpuTime;
            this.jvmGCTime = jvmGCTime;
            this.resultSerializationTime = resultSerializationTime;
            this.memoryBytesSpilled = memoryBytesSpilled;
            this.diskBytesSpilled = diskBytesSpilled;
            this.peakExecutionMemory = peakExecutionMemory;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public void setSubmitTime(long submitTime) {
            this.submitTime = submitTime;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean success) {
            this.isSuccess = success;
        }

        public void setStageType(String stageType) {
            this.stageType = stageType;
        }

        public void setStageId(int stageId) {
            this.stageId = stageId;
        }

        public void setResultSize(long resultSize) {
            this.resultSize = resultSize;
        }

        public void setResultSerializationTime(long resultSerializationTime) {
            this.resultSerializationTime = resultSerializationTime;
        }

        public void setPeakExecutionMemory(long peakExecutionMemory) {
            this.peakExecutionMemory = peakExecutionMemory;
        }

        public void setMemoryBytesSpilled(long memoryBytesSpilled) {
            this.memoryBytesSpilled = memoryBytesSpilled;
        }

        public void setJvmGCTime(long jvmGCTime) {
            this.jvmGCTime = jvmGCTime;
        }

        public void setExecutorRunTime(long executorRunTime) {
            this.executorRunTime = executorRunTime;
        }

        public void setExecutorDeserializeTime(long executorDeserializeTime) {
            this.executorDeserializeTime = executorDeserializeTime;
        }

        public void setExecutorDeserializeCpuTime(long executorDeserializeCpuTime) {
            this.executorDeserializeCpuTime = executorDeserializeCpuTime;
        }

        public void setExecutorCpuTime(long executorCpuTime) {
            this.executorCpuTime = executorCpuTime;
        }

        public void setDiskBytesSpilled(long diskBytesSpilled) {
            this.diskBytesSpilled = diskBytesSpilled;
        }

        public String getStageType() {
            return this.stageType;
        }

        public long getResultSize() {
            return this.resultSize;
        }

        public long getResultSerializationTime() {
            return this.resultSerializationTime;
        }

        public long getPeakExecutionMemory() {
            return this.peakExecutionMemory;
        }

        public long getMemoryBytesSpilled() {
            return this.memoryBytesSpilled;
        }

        public long getJvmGCTime() {
            return this.jvmGCTime;
        }

        public long getExecutorRunTime() {
            return this.executorRunTime;
        }

        public long getExecutorDeserializeTime() {
            return this.executorDeserializeTime;
        }

        public long getExecutorDeserializeCpuTime() {
            return this.executorDeserializeCpuTime;
        }

        public long getExecutorCpuTime() {
            return this.executorCpuTime;
        }

        public long getDiskBytesSpilled() {
            return this.diskBytesSpilled;
        }

        public int getStageId() {
            return this.stageId;
        }
    }

    public static class SparkJobMetrics
    implements Serializable {
        private long executionId;
        private int jobId;
        private long startTime;
        private long endTime;
        private boolean isSuccess;
        private ConcurrentMap<Integer, SparkStageMetrics> sparkStageMetricsMap;

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setExecutionId(long executionId) {
            this.executionId = executionId;
        }

        public long getExecutionId() {
            return this.executionId;
        }

        public void setSparkStageMetricsMap(ConcurrentMap<Integer, SparkStageMetrics> sparkStageMetricsMap) {
            this.sparkStageMetricsMap = sparkStageMetricsMap;
        }

        public void setJobId(int jobId) {
            this.jobId = jobId;
        }

        public void setSuccess(boolean success) {
            this.isSuccess = success;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public ConcurrentMap<Integer, SparkStageMetrics> getSparkStageMetricsMap() {
            return this.sparkStageMetricsMap;
        }

        public int getJobId() {
            return this.jobId;
        }
    }

    public static class QueryExecutionMetrics
    implements Serializable {
        private long sqlIdCode;
        private String user;
        private String queryType;
        private String project;
        private String exception;
        private long executionId;
        private String sparderName;
        private long executionDuration;
        private String queryId;
        private String realization;
        private String realizationTypes;
        private String cuboidIds;
        private long startTime;
        private long endTime;
        private ConcurrentMap<Integer, SparkJobMetrics> sparkJobMetricsMap;
        private long sqlDuration;
        private long totalScanCount;
        private long totalScanBytes;
        private int resultCount;

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public long getSqlDuration() {
            return this.sqlDuration;
        }

        public long getTotalScanBytes() {
            return this.totalScanBytes;
        }

        public long getTotalScanCount() {
            return this.totalScanCount;
        }

        public void setResultCount(int resultCount) {
            this.resultCount = resultCount;
        }

        public void setSqlDuration(long sqlDuration) {
            this.sqlDuration = sqlDuration;
        }

        public void setTotalScanBytes(long totalScanBytes) {
            this.totalScanBytes = totalScanBytes;
        }

        public void setTotalScanCount(long totalScanCount) {
            this.totalScanCount = totalScanCount;
        }

        public String getException() {
            return this.exception;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getProject() {
            return this.project;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public long getSqlIdCode() {
            return this.sqlIdCode;
        }

        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        public void setSqlIdCode(long sqlIdCode) {
            this.sqlIdCode = sqlIdCode;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public long getExecutionDuration() {
            return this.executionDuration;
        }

        public void setExecutionDuration(long executionDuration) {
            this.executionDuration = executionDuration;
        }

        public ConcurrentMap<Integer, SparkJobMetrics> getSparkJobMetricsMap() {
            return this.sparkJobMetricsMap;
        }

        public long getExecutionId() {
            return this.executionId;
        }

        public String getSparderName() {
            return this.sparderName;
        }

        public void setExecutionId(long executionId) {
            this.executionId = executionId;
        }

        public void setSparderName(String sparderName) {
            this.sparderName = sparderName;
        }

        public String getCuboidIds() {
            return this.cuboidIds;
        }

        public void setCuboidIds(String cuboidIds) {
            this.cuboidIds = cuboidIds;
        }

        public String getRealization() {
            return this.realization;
        }

        public String getRealizationTypes() {
            return this.realizationTypes;
        }

        public void setRealization(String realization) {
            this.realization = realization;
        }

        public void setRealizationTypes(String realizationTypes) {
            this.realizationTypes = realizationTypes;
        }

        public void setSparkJobMetricsMap(ConcurrentMap<Integer, SparkJobMetrics> sparkJobMetricsMap) {
            this.sparkJobMetricsMap = sparkJobMetricsMap;
        }
    }

    private static class QuerySparkMetricsRemovalListener
    implements RemovalListener<String, QueryExecutionMetrics> {
        private QuerySparkMetricsRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<String, QueryExecutionMetrics> notification) {
            try {
                QuerySparkMetrics.updateMetricsToReservoir((String)notification.getKey(), (QueryExecutionMetrics)notification.getValue());
                logger.info("Query metrics {} is removed due to {}, update to metrics reservoir successful", notification.getKey(), (Object)notification.getCause());
            }
            catch (Exception e) {
                logger.warn("Query metrics {} is removed due to {}, update to metrics reservoir failed", notification.getKey(), (Object)notification.getCause());
            }
        }
    }
}

