/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.metrics.lib.ActiveReservoir;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.ReporterBuilder;
import org.apache.kylin.metrics.lib.impl.hive.HiveProducer;
import org.apache.kylin.metrics.lib.impl.hive.HiveSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveReservoirReporter
extends ActiveReservoirReporter {
    public static final String HIVE_REPORTER_SUFFIX = "HIVE";
    public static final HiveSink sink = new HiveSink();
    protected static final Logger logger = LoggerFactory.getLogger(HiveReservoirReporter.class);
    private final ActiveReservoir activeReservoir;
    private final HiveReservoirListener listener;

    public HiveReservoirReporter(ActiveReservoir activeReservoir, Properties props) throws Exception {
        this.activeReservoir = activeReservoir;
        this.listener = new HiveReservoirListener(props);
    }

    public static Builder forRegistry(ActiveReservoir activeReservoir) {
        return new Builder(activeReservoir);
    }

    public static String getTableFromSubject(String subject) {
        return sink.getTableFromSubject(subject);
    }

    @Override
    public void start() {
        this.activeReservoir.addListener(this.listener);
    }

    @Override
    public void stop() {
        this.activeReservoir.removeListener(this.listener);
    }

    @Override
    public void close() {
        this.stop();
    }

    private class HiveReservoirListener
    implements ActiveReservoirListener {
        private Properties props;
        private Map<String, HiveProducer> producerMap = new HashMap<String, HiveProducer>();

        private HiveReservoirListener(Properties props) throws Exception {
            this.props = props;
        }

        private synchronized HiveProducer getProducer(String metricType) throws Exception {
            HiveProducer producer = this.producerMap.get(metricType);
            if (producer == null) {
                producer = new HiveProducer(metricType, this.props);
                this.producerMap.put(metricType, producer);
            }
            return producer;
        }

        @Override
        public boolean onRecordUpdate(List<Record> records) {
            if (records.isEmpty()) {
                return true;
            }
            logger.info("Try to write {} records", (Object)records.size());
            try {
                HashMap<String, ArrayList<Record>> queues = new HashMap<String, ArrayList<Record>>();
                for (Record record : records) {
                    ArrayList<Record> recordQueues = (ArrayList<Record>)queues.get(record.getSubject());
                    if (recordQueues == null) {
                        recordQueues = new ArrayList<Record>();
                        queues.put(record.getSubject(), recordQueues);
                    }
                    recordQueues.add(record);
                }
                for (Map.Entry entry : queues.entrySet()) {
                    HiveProducer producer = this.getProducer((String)entry.getKey());
                    producer.send((List)entry.getValue());
                }
                queues.clear();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                return false;
            }
            return true;
        }

        public boolean onRecordUpdate(Record record) {
            try {
                HiveProducer producer = this.getProducer(record.getSubject());
                producer.send(record);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            for (HiveProducer producer : this.producerMap.values()) {
                producer.close();
            }
            this.producerMap.clear();
        }
    }

    public static class Builder
    extends ReporterBuilder {
        private Builder(ActiveReservoir activeReservoir) {
            super(activeReservoir);
        }

        private void setFixedProperties() {
        }

        @Override
        public HiveReservoirReporter build() throws Exception {
            this.setFixedProperties();
            return new HiveReservoirReporter(this.registry, this.props);
        }
    }
}

