/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hybrid;

import java.util.ArrayList;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.CompoundTupleIterator;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.StorageFactory;
import org.apache.kylin.storage.hybrid.HybridInstance;

public class HybridStorageQuery
implements IStorageQuery {
    private IRealization[] realizations;
    private IStorageQuery[] storageEngines;

    public HybridStorageQuery(HybridInstance hybridInstance) {
        this.realizations = hybridInstance.getRealizations();
        this.storageEngines = new IStorageQuery[this.realizations.length];
        for (int i = 0; i < this.realizations.length; ++i) {
            this.storageEngines[i] = StorageFactory.createQuery(this.realizations[i]);
        }
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        ArrayList<ITupleIterator> tupleIterators = Lists.newArrayList();
        for (int i = 0; i < this.realizations.length; ++i) {
            if (!this.realizations[i].isReady() || !this.realizations[i].isCapable((SQLDigest)sqlDigest).capable) continue;
            ITupleIterator dataIterator = this.storageEngines[i].search(context, sqlDigest, returnTupleInfo);
            tupleIterators.add(dataIterator);
        }
        return new CompoundTupleIterator(tupleIterators);
    }
}

