/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.apache.kylin.metrics.property.QuerySparkExecutionEnum;
import org.apache.kylin.metrics.property.QuerySparkJobEnum;
import org.apache.kylin.metrics.property.QuerySparkStageEnum;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.ModelCreator;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;

public class CubeDescCreator {
    public static CubeDesc generateKylinCubeDescForMetricsQueryExecution(KylinConfig config, MetricsSinkDesc sinkDesc) {
        String tableName = sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQueryExecution());
        List<String> dimensions = ModelCreator.getDimensionsForMetricsQueryExecution();
        dimensions.remove(TimePropertyEnum.DAY_TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.TIME.toString());
        ArrayList<DimensionDesc> dimensionDescList = Lists.newArrayListWithExpectedSize(dimensions.size());
        for (String dimensionName : dimensions) {
            dimensionDescList.add(CubeDescCreator.getDimensionDesc(tableName, dimensionName));
        }
        List<String> measures = ModelCreator.getMeasuresForMetricsQueryExecution();
        measures.remove(QuerySparkExecutionEnum.ID_CODE.toString());
        ArrayList<MeasureDesc> measureDescList = Lists.newArrayListWithExpectedSize(measures.size() * 2 + 1 + 1);
        List<Pair<String, String>> measureTypeList = HiveTableCreator.getHiveColumnsForMetricsQueryExecution();
        HashMap<String, String> measureTypeMap = Maps.newHashMapWithExpectedSize(measureTypeList.size());
        for (Pair<String, String> entry : measureTypeList) {
            measureTypeMap.put(entry.getFirst(), entry.getSecond());
        }
        measureDescList.add(CubeDescCreator.getMeasureCount());
        measureDescList.add(CubeDescCreator.getMeasureMin(QuerySparkExecutionEnum.TIME_COST.toString(), (String)measureTypeMap.get(QuerySparkExecutionEnum.TIME_COST.toString())));
        for (String measure : measures) {
            measureDescList.add(CubeDescCreator.getMeasureSum(measure, (String)measureTypeMap.get(measure)));
            measureDescList.add(CubeDescCreator.getMeasureMax(measure, (String)measureTypeMap.get(measure)));
        }
        measureDescList.add(CubeDescCreator.getMeasureHLL(QuerySparkExecutionEnum.ID_CODE.toString()));
        measureDescList.add(CubeDescCreator.getMeasurePercentile(QuerySparkExecutionEnum.TIME_COST.toString()));
        RowKeyColDesc[] rowKeyColDescs = new RowKeyColDesc[dimensionDescList.size()];
        int idx = CubeDescCreator.getTimeRowKeyColDesc(tableName, rowKeyColDescs);
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.USER.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.PROJECT.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.REALIZATION.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.REALIZATION_TYPE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.CUBOID_IDS.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.EXCEPTION.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.TYPE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.SPARDER_NAME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.QUERY_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.START_TIME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkExecutionEnum.END_TIME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, RecordEvent.RecordReserveKeyEnum.HOST.toString(), idx + 1);
        ++idx;
        RowKeyDesc rowKeyDesc = new RowKeyDesc();
        rowKeyDesc.setRowkeyColumns(rowKeyColDescs);
        String[][] hierarchyDims = new String[][]{CubeDescCreator.getTimeHierarchy()};
        for (int i = 0; i < hierarchyDims.length; ++i) {
            hierarchyDims[i] = CubeDescCreator.refineColumnWithTable(tableName, hierarchyDims[i]);
        }
        String[] mandatoryDims = new String[]{CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.PROJECT.toString())};
        String[][] jointDims = new String[][]{{CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_HOUR.toString()), CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_MINUTE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.START_TIME.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.END_TIME.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.REALIZATION_TYPE.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.REALIZATION.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.CUBOID_IDS.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.SPARDER_NAME.toString()), CubeDescCreator.refineColumnWithTable(tableName, RecordEvent.RecordReserveKeyEnum.HOST.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.EXCEPTION.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.TYPE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.USER.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkExecutionEnum.QUERY_ID.toString())}};
        SelectRule selectRule = new SelectRule();
        selectRule.mandatoryDims = mandatoryDims;
        selectRule.hierarchyDims = hierarchyDims;
        selectRule.jointDims = jointDims;
        AggregationGroup aggGroup = new AggregationGroup();
        aggGroup.setIncludes(CubeDescCreator.refineColumnWithTable(tableName, dimensions));
        aggGroup.setSelectRule(selectRule);
        HBaseMappingDesc hBaseMapping = new HBaseMappingDesc();
        hBaseMapping.setColumnFamily(CubeDescCreator.getHBaseColumnFamily(measureDescList));
        return CubeDescCreator.generateKylinCubeDesc(tableName, sinkDesc.getStorageType(), dimensionDescList, measureDescList, rowKeyDesc, aggGroup, hBaseMapping, sinkDesc.getCubeDescOverrideProperties());
    }

    public static CubeDesc generateKylinCubeDescForMetricsQuerySparkJob(KylinConfig config, MetricsSinkDesc sinkDesc) {
        String tableName = sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQuerySparkJob());
        List<String> dimensions = ModelCreator.getDimensionsForMetricsQuerySparkJob();
        dimensions.remove(TimePropertyEnum.DAY_TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.HOST.toString());
        ArrayList<DimensionDesc> dimensionDescList = Lists.newArrayListWithExpectedSize(dimensions.size());
        for (String dimensionName : dimensions) {
            dimensionDescList.add(CubeDescCreator.getDimensionDesc(tableName, dimensionName));
        }
        List<String> measures = ModelCreator.getMeasuresForMetricsQuerySparkJob();
        ArrayList<MeasureDesc> measureDescList = Lists.newArrayListWithExpectedSize(measures.size() * 2);
        List<Pair<String, String>> measureTypeList = HiveTableCreator.getHiveColumnsForMetricsQuerySparkJob();
        HashMap<String, String> measureTypeMap = Maps.newHashMapWithExpectedSize(measureTypeList.size());
        for (Pair<String, String> entry : measureTypeList) {
            measureTypeMap.put(entry.getFirst(), entry.getSecond());
        }
        measureDescList.add(CubeDescCreator.getMeasureCount());
        for (String measure : measures) {
            measureDescList.add(CubeDescCreator.getMeasureSum(measure, (String)measureTypeMap.get(measure)));
            measureDescList.add(CubeDescCreator.getMeasureMax(measure, (String)measureTypeMap.get(measure)));
        }
        RowKeyColDesc[] rowKeyColDescs = new RowKeyColDesc[dimensionDescList.size()];
        int idx = CubeDescCreator.getTimeRowKeyColDesc(tableName, rowKeyColDescs);
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.JOB_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.EXECUTION_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.QUERY_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.START_TIME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.END_TIME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.PROJECT.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkJobEnum.IF_SUCCESS.toString(), idx + 1);
        ++idx;
        RowKeyDesc rowKeyDesc = new RowKeyDesc();
        rowKeyDesc.setRowkeyColumns(rowKeyColDescs);
        String[][] hierarchyDims = new String[][]{CubeDescCreator.getTimeHierarchy()};
        for (int i = 0; i < hierarchyDims.length; ++i) {
            hierarchyDims[i] = CubeDescCreator.refineColumnWithTable(tableName, hierarchyDims[i]);
        }
        String[] mandatoryDims = new String[]{CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.PROJECT.toString())};
        String[][] jointDims = new String[][]{{CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_HOUR.toString()), CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_MINUTE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.START_TIME.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.END_TIME.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.IF_SUCCESS.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.QUERY_ID.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.EXECUTION_ID.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkJobEnum.JOB_ID.toString())}};
        SelectRule selectRule = new SelectRule();
        selectRule.mandatoryDims = mandatoryDims;
        selectRule.hierarchyDims = hierarchyDims;
        selectRule.jointDims = jointDims;
        AggregationGroup aggGroup = new AggregationGroup();
        aggGroup.setIncludes(CubeDescCreator.refineColumnWithTable(tableName, dimensions));
        aggGroup.setSelectRule(selectRule);
        HBaseMappingDesc hBaseMapping = new HBaseMappingDesc();
        hBaseMapping.setColumnFamily(CubeDescCreator.getHBaseColumnFamily(measureDescList));
        return CubeDescCreator.generateKylinCubeDesc(tableName, sinkDesc.getStorageType(), dimensionDescList, measureDescList, rowKeyDesc, aggGroup, hBaseMapping, sinkDesc.getCubeDescOverrideProperties());
    }

    public static CubeDesc generateKylinCubeDescForMetricsQuerySparkStage(KylinConfig config, MetricsSinkDesc sinkDesc) {
        String tableName = sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQuerySparkStage());
        List<String> dimensions = ModelCreator.getDimensionsForMetricsQuerySparkStage();
        dimensions.remove(TimePropertyEnum.DAY_TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.TIME.toString());
        ArrayList<DimensionDesc> dimensionDescList = Lists.newArrayListWithExpectedSize(dimensions.size());
        for (String dimensionName : dimensions) {
            dimensionDescList.add(CubeDescCreator.getDimensionDesc(tableName, dimensionName));
        }
        List<String> measures = ModelCreator.getMeasuresForMetricsQuerySparkStage();
        ArrayList<MeasureDesc> measureDescList = Lists.newArrayListWithExpectedSize(measures.size() * 2 + 1 + 1);
        List<Pair<String, String>> measureTypeList = HiveTableCreator.getHiveColumnsForMetricsQuerySparkStage();
        HashMap<String, String> measureTypeMap = Maps.newHashMapWithExpectedSize(measureTypeList.size());
        for (Pair<String, String> entry : measureTypeList) {
            measureTypeMap.put(entry.getFirst(), entry.getSecond());
        }
        measureDescList.add(CubeDescCreator.getMeasureCount());
        for (String measure : measures) {
            measureDescList.add(CubeDescCreator.getMeasureSum(measure, (String)measureTypeMap.get(measure)));
            measureDescList.add(CubeDescCreator.getMeasureMax(measure, (String)measureTypeMap.get(measure)));
        }
        RowKeyColDesc[] rowKeyColDescs = new RowKeyColDesc[dimensionDescList.size()];
        int idx = CubeDescCreator.getTimeRowKeyColDesc(tableName, rowKeyColDescs);
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.PROJECT.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.REALIZATION.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.CUBOID_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.QUERY_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.EXECUTION_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.JOB_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.STAGE_ID.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.IF_SUCCESS.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, QuerySparkStageEnum.SUBMIT_TIME.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, RecordEvent.RecordReserveKeyEnum.HOST.toString(), idx + 1);
        ++idx;
        RowKeyDesc rowKeyDesc = new RowKeyDesc();
        rowKeyDesc.setRowkeyColumns(rowKeyColDescs);
        String[][] hierarchyDims = new String[][]{CubeDescCreator.getTimeHierarchy()};
        for (int i = 0; i < hierarchyDims.length; ++i) {
            hierarchyDims[i] = CubeDescCreator.refineColumnWithTable(tableName, hierarchyDims[i]);
        }
        String[] mandatoryDims = new String[]{CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.PROJECT.toString())};
        String[][] jointDims = new String[][]{{CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_HOUR.toString()), CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_MINUTE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.REALIZATION.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.CUBOID_ID.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, RecordEvent.RecordReserveKeyEnum.HOST.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.IF_SUCCESS.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.QUERY_ID.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.EXECUTION_ID.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.JOB_ID.toString()), CubeDescCreator.refineColumnWithTable(tableName, QuerySparkStageEnum.STAGE_ID.toString())}};
        SelectRule selectRule = new SelectRule();
        selectRule.mandatoryDims = mandatoryDims;
        selectRule.hierarchyDims = hierarchyDims;
        selectRule.jointDims = jointDims;
        AggregationGroup aggGroup = new AggregationGroup();
        aggGroup.setIncludes(CubeDescCreator.refineColumnWithTable(tableName, dimensions));
        aggGroup.setSelectRule(selectRule);
        HBaseMappingDesc hBaseMapping = new HBaseMappingDesc();
        hBaseMapping.setColumnFamily(CubeDescCreator.getHBaseColumnFamily(measureDescList));
        return CubeDescCreator.generateKylinCubeDesc(tableName, sinkDesc.getStorageType(), dimensionDescList, measureDescList, rowKeyDesc, aggGroup, hBaseMapping, sinkDesc.getCubeDescOverrideProperties());
    }

    public static CubeDesc generateKylinCubeDescForMetricsJob(KylinConfig config, MetricsSinkDesc sinkDesc) {
        String tableName = sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectJob());
        List<String> dimensions = ModelCreator.getDimensionsForMetricsJob();
        dimensions.remove(TimePropertyEnum.DAY_TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.HOST.toString());
        ArrayList<DimensionDesc> dimensionDescList = Lists.newArrayListWithExpectedSize(dimensions.size());
        for (String dimensionName : dimensions) {
            dimensionDescList.add(CubeDescCreator.getDimensionDesc(tableName, dimensionName));
        }
        List<String> measures = ModelCreator.getMeasuresForMetricsJob();
        ArrayList<MeasureDesc> measureDescList = Lists.newArrayListWithExpectedSize((measures.size() - 4) * 3 + 1 + 1 + 4);
        HashSet<String> stepDuration = Sets.newHashSet();
        stepDuration.add(JobPropertyEnum.STEP_DURATION_DISTINCT_COLUMNS.toString());
        stepDuration.add(JobPropertyEnum.STEP_DURATION_DICTIONARY.toString());
        stepDuration.add(JobPropertyEnum.STEP_DURATION_INMEM_CUBING.toString());
        stepDuration.add(JobPropertyEnum.STEP_DURATION_HFILE_CONVERT.toString());
        List<Pair<String, String>> measureTypeList = HiveTableCreator.getHiveColumnsForMetricsJob();
        HashMap<String, String> measureTypeMap = Maps.newHashMapWithExpectedSize(measureTypeList.size());
        for (Pair<String, String> entry : measureTypeList) {
            measureTypeMap.put(entry.getFirst(), entry.getSecond());
        }
        measureDescList.add(CubeDescCreator.getMeasureCount());
        for (String measure : measures) {
            measureDescList.add(CubeDescCreator.getMeasureSum(measure, (String)measureTypeMap.get(measure)));
            measureDescList.add(CubeDescCreator.getMeasureMax(measure, (String)measureTypeMap.get(measure)));
            if (stepDuration.contains(measure)) continue;
            measureDescList.add(CubeDescCreator.getMeasureMin(measure, (String)measureTypeMap.get(measure)));
        }
        measureDescList.add(CubeDescCreator.getMeasurePercentile(JobPropertyEnum.BUILD_DURATION.toString()));
        RowKeyColDesc[] rowKeyColDescs = new RowKeyColDesc[dimensionDescList.size()];
        int idx = CubeDescCreator.getTimeRowKeyColDesc(tableName, rowKeyColDescs);
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.USER.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.PROJECT.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.CUBE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.ALGORITHM.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.TYPE.toString(), idx + 1);
        ++idx;
        RowKeyDesc rowKeyDesc = new RowKeyDesc();
        rowKeyDesc.setRowkeyColumns(rowKeyColDescs);
        String[][] hierarchyDims = new String[][]{CubeDescCreator.getTimeHierarchy()};
        for (int i = 0; i < hierarchyDims.length; ++i) {
            hierarchyDims[i] = CubeDescCreator.refineColumnWithTable(tableName, hierarchyDims[i]);
        }
        String[] mandatoryDims = new String[]{CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.PROJECT.toString())};
        String[][] jointDims = new String[][]{{CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.CUBE.toString()), CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.ALGORITHM.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_HOUR.toString()), CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_MINUTE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.USER.toString()), CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.TYPE.toString())}};
        SelectRule selectRule = new SelectRule();
        selectRule.mandatoryDims = mandatoryDims;
        selectRule.hierarchyDims = hierarchyDims;
        selectRule.jointDims = jointDims;
        AggregationGroup aggGroup = new AggregationGroup();
        aggGroup.setIncludes(CubeDescCreator.refineColumnWithTable(tableName, dimensions));
        aggGroup.setSelectRule(selectRule);
        HBaseMappingDesc hBaseMapping = new HBaseMappingDesc();
        hBaseMapping.setColumnFamily(CubeDescCreator.getHBaseColumnFamily(measureDescList));
        return CubeDescCreator.generateKylinCubeDesc(tableName, sinkDesc.getStorageType(), dimensionDescList, measureDescList, rowKeyDesc, aggGroup, hBaseMapping, sinkDesc.getCubeDescOverrideProperties());
    }

    public static CubeDesc generateKylinCubeDescForMetricsJobException(KylinConfig config, MetricsSinkDesc sinkDesc) {
        String tableName = sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectJobException());
        List<String> dimensions = ModelCreator.getDimensionsForMetricsJobException();
        dimensions.remove(TimePropertyEnum.DAY_TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.TIME.toString());
        dimensions.remove(RecordEvent.RecordReserveKeyEnum.HOST.toString());
        ArrayList<DimensionDesc> dimensionDescList = Lists.newArrayListWithExpectedSize(dimensions.size());
        for (String dimensionName : dimensions) {
            dimensionDescList.add(CubeDescCreator.getDimensionDesc(tableName, dimensionName));
        }
        List<String> measures = ModelCreator.getMeasuresForMetricsJobException();
        measures.remove(JobPropertyEnum.ID_CODE.toString());
        ArrayList<MeasureDesc> measureDescList = Lists.newArrayListWithExpectedSize(1);
        measureDescList.add(CubeDescCreator.getMeasureCount());
        RowKeyColDesc[] rowKeyColDescs = new RowKeyColDesc[dimensionDescList.size()];
        int idx = CubeDescCreator.getTimeRowKeyColDesc(tableName, rowKeyColDescs);
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.USER.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.PROJECT.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.CUBE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.ALGORITHM.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.TYPE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, JobPropertyEnum.EXCEPTION.toString(), idx + 1);
        ++idx;
        RowKeyDesc rowKeyDesc = new RowKeyDesc();
        rowKeyDesc.setRowkeyColumns(rowKeyColDescs);
        String[][] hierarchyDims = new String[][]{CubeDescCreator.getTimeHierarchy()};
        for (int i = 0; i < hierarchyDims.length; ++i) {
            hierarchyDims[i] = CubeDescCreator.refineColumnWithTable(tableName, hierarchyDims[i]);
        }
        String[] mandatoryDims = new String[]{CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.PROJECT.toString())};
        String[][] jointDims = new String[][]{{CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.CUBE.toString()), CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.ALGORITHM.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_HOUR.toString()), CubeDescCreator.refineColumnWithTable(tableName, TimePropertyEnum.TIME_MINUTE.toString())}, {CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.USER.toString()), CubeDescCreator.refineColumnWithTable(tableName, JobPropertyEnum.TYPE.toString())}};
        SelectRule selectRule = new SelectRule();
        selectRule.mandatoryDims = mandatoryDims;
        selectRule.hierarchyDims = hierarchyDims;
        selectRule.jointDims = jointDims;
        AggregationGroup aggGroup = new AggregationGroup();
        aggGroup.setIncludes(CubeDescCreator.refineColumnWithTable(tableName, dimensions));
        aggGroup.setSelectRule(selectRule);
        HBaseMappingDesc hBaseMapping = new HBaseMappingDesc();
        hBaseMapping.setColumnFamily(CubeDescCreator.getHBaseColumnFamily(measureDescList));
        return CubeDescCreator.generateKylinCubeDesc(tableName, sinkDesc.getStorageType(), dimensionDescList, measureDescList, rowKeyDesc, aggGroup, hBaseMapping, sinkDesc.getCubeDescOverrideProperties());
    }

    public static CubeDesc generateKylinCubeDesc(String tableName, int storageType, List<DimensionDesc> dimensionDescList, List<MeasureDesc> measureDescList, RowKeyDesc rowKeyDesc, AggregationGroup aggGroup, HBaseMappingDesc hBaseMapping, Map<String, String> overrideProperties) {
        CubeDesc desc = new CubeDesc();
        desc.setName(tableName.replace('.', '_'));
        desc.setModelName(tableName.replace('.', '_'));
        desc.setDescription("");
        desc.setLastModified(0L);
        desc.setDimensions(dimensionDescList);
        desc.setMeasures(measureDescList);
        desc.setRowkey(rowKeyDesc);
        desc.setHbaseMapping(hBaseMapping);
        desc.setNotifyList(Lists.newArrayList());
        desc.setStatusNeedNotify(Lists.newArrayList(JobStatusEnum.ERROR.toString()));
        desc.setAutoMergeTimeRanges(new long[]{86400000L, 604800000L, 2419200000L, 7776000000L, 31104000000L});
        desc.setEngineType(6);
        desc.setStorageType(storageType);
        desc.setAggregationGroups(Lists.newArrayList(aggGroup));
        desc.getOverrideKylinProps().putAll(overrideProperties);
        desc.updateRandomUuid();
        return desc;
    }

    public static HBaseColumnFamilyDesc[] getHBaseColumnFamily(List<MeasureDesc> measureDescList) {
        LinkedList<String> normalMeasureList = Lists.newLinkedList();
        LinkedList<String> largeMeasureList = Lists.newLinkedList();
        for (MeasureDesc measureDesc : measureDescList) {
            if (measureDesc.getFunction().isCountDistinct() || measureDesc.getFunction().getExpression().equals("PERCENTILE")) {
                largeMeasureList.add(measureDesc.getName());
                continue;
            }
            normalMeasureList.add(measureDesc.getName());
        }
        LinkedList<HBaseColumnFamilyDesc> columnFamilyDescList = Lists.newLinkedList();
        int idx = 1;
        if (normalMeasureList.size() > 0) {
            HBaseColumnDesc columnDesc = new HBaseColumnDesc();
            columnDesc.setQualifier("M");
            columnDesc.setMeasureRefs(normalMeasureList.toArray(new String[normalMeasureList.size()]));
            HBaseColumnFamilyDesc columnFamilyDesc = new HBaseColumnFamilyDesc();
            columnFamilyDesc.setName("F" + idx++);
            columnFamilyDesc.setColumns(new HBaseColumnDesc[]{columnDesc});
            columnFamilyDescList.add(columnFamilyDesc);
        }
        for (String largeMeasure : largeMeasureList) {
            HBaseColumnDesc columnDesc = new HBaseColumnDesc();
            columnDesc.setQualifier("M");
            columnDesc.setMeasureRefs(new String[]{largeMeasure});
            HBaseColumnFamilyDesc columnFamilyDesc = new HBaseColumnFamilyDesc();
            columnFamilyDesc.setName("F" + idx++);
            columnFamilyDesc.setColumns(new HBaseColumnDesc[]{columnDesc});
            columnFamilyDescList.add(columnFamilyDesc);
        }
        return columnFamilyDescList.toArray(new HBaseColumnFamilyDesc[columnFamilyDescList.size()]);
    }

    public static String[] getTimeHierarchy() {
        String[] result = new String[]{TimePropertyEnum.YEAR.toString(), TimePropertyEnum.MONTH.toString(), TimePropertyEnum.WEEK_BEGIN_DATE.toString(), TimePropertyEnum.DAY_DATE.toString()};
        return result;
    }

    public static String refineColumnWithTable(String tableName, String column) {
        return tableName.substring(tableName.lastIndexOf(".") + 1) + "." + column;
    }

    public static String[] refineColumnWithTable(String tableName, List<String> columns) {
        String[] dimensions = new String[columns.size()];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = tableName.substring(tableName.lastIndexOf(".") + 1) + "." + columns.get(i);
        }
        return dimensions;
    }

    public static String[] refineColumnWithTable(String tableName, String[] columns) {
        String[] dimensions = new String[columns.length];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = tableName.substring(tableName.lastIndexOf(".") + 1) + "." + columns[i];
        }
        return dimensions;
    }

    public static int getTimeRowKeyColDesc(String tableName, RowKeyColDesc[] rowKeyColDescs) {
        int idx = 0;
        rowKeyColDescs[idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.DAY_DATE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.WEEK_BEGIN_DATE.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.MONTH.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.YEAR.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.TIME_HOUR.toString(), idx + 1);
        rowKeyColDescs[++idx] = CubeDescCreator.getRowKeyColDesc(tableName, TimePropertyEnum.TIME_MINUTE.toString(), idx + 1);
        return ++idx;
    }

    public static RowKeyColDesc getRowKeyColDesc(String tableName, String column, int id) {
        RowKeyColDesc rowKeyColDesc = new RowKeyColDesc();
        rowKeyColDesc.setIndex(Integer.toString(id));
        rowKeyColDesc.setColumn(tableName.substring(tableName.lastIndexOf(".") + 1) + "." + column);
        rowKeyColDesc.setEncoding("dict");
        rowKeyColDesc.setShardBy(false);
        return rowKeyColDesc;
    }

    public static DimensionDesc getDimensionDesc(String tableName, String dimension) {
        DimensionDesc dimensionDesc = new DimensionDesc();
        dimensionDesc.setName(dimension);
        dimensionDesc.setTable(tableName.substring(tableName.lastIndexOf(".") + 1));
        dimensionDesc.setColumn(dimension);
        return dimensionDesc;
    }

    public static MeasureDesc getMeasureCount() {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue("1");
        parameterDesc.setType("constant");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("COUNT");
        function.setParameter(parameterDesc);
        function.setReturnType(HiveTableCreator.HiveTypeEnum.HBIGINT.toString());
        MeasureDesc result = new MeasureDesc();
        result.setName("_COUNT_");
        result.setFunction(function);
        return result;
    }

    public static MeasureDesc getMeasureSum(String column, String dataType) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue(column);
        parameterDesc.setType("column");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("SUM");
        function.setParameter(parameterDesc);
        function.setReturnType(dataType);
        MeasureDesc result = new MeasureDesc();
        result.setName(column + "_SUM");
        result.setFunction(function);
        return result;
    }

    public static MeasureDesc getMeasureMax(String column, String dataType) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue(column);
        parameterDesc.setType("column");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("MAX");
        function.setParameter(parameterDesc);
        function.setReturnType(dataType);
        MeasureDesc result = new MeasureDesc();
        result.setName(column + "_MAX");
        result.setFunction(function);
        return result;
    }

    public static MeasureDesc getMeasureMin(String column, String dataType) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue(column);
        parameterDesc.setType("column");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("MIN");
        function.setParameter(parameterDesc);
        function.setReturnType(dataType);
        MeasureDesc result = new MeasureDesc();
        result.setName(column + "_MIN");
        result.setFunction(function);
        return result;
    }

    public static MeasureDesc getMeasureHLL(String column) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue(column);
        parameterDesc.setType("column");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("COUNT_DISTINCT");
        function.setParameter(parameterDesc);
        function.setReturnType("hllc12");
        MeasureDesc result = new MeasureDesc();
        result.setName(column + "_HLL");
        result.setFunction(function);
        return result;
    }

    public static MeasureDesc getMeasurePercentile(String column) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setValue(column);
        parameterDesc.setType("column");
        FunctionDesc function = new FunctionDesc();
        function.setExpression("PERCENTILE");
        function.setParameter(parameterDesc);
        function.setReturnType("percentile(100)");
        MeasureDesc result = new MeasureDesc();
        result.setName(column + "_PERCENTILE");
        result.setFunction(function);
        return result;
    }
}

