/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContext
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryContext.class);
    public static final String PUSHDOWN_RDBMS = "RDBMS";
    public static final String PUSHDOWN_HIVE = "HIVE";
    public static final String PUSHDOWN_MOCKUP = "MOCKUP";
    public static final String PUSHDOWN_OBJECT_STORAGE = "OBJECT STORAGE";
    public static final String PUSHDOWN_GLUTEN = "GLUTEN";
    public static final long DEFAULT_NULL_SCANNED_DATA = -1L;
    private static final TransmittableThreadLocal<QueryContext> contexts = new TransmittableThreadLocal<QueryContext>(){

        protected QueryContext initialValue() {
            return new QueryContext();
        }
    };
    private String queryId;
    private String project;
    private long recordMillis;
    private String pushdownEngine;
    private String engineType;
    private int shufflePartitions;
    private int shufflePartitionsReset;
    private String executionID = "";
    private String userSQL;
    private Integer limit = 0;
    private Integer offset = 0;
    private String[] modelPriorities = new String[0];
    private final QueryTrace queryTrace = new QueryTrace();
    private boolean partialMatchIndex = false;
    private boolean isForModeling;
    private boolean forceTableIndex = false;
    private Map<String, Boolean> unmatchedJoinDigest = new ConcurrentHashMap<String, Boolean>();
    private boolean enhancedAggPushDown;
    private String lastUsedRelNode;
    private boolean dryRun = false;
    private boolean ifBigQuery = false;
    private boolean isBigQuery = false;
    private boolean outOfSegmentRange = false;
    private long responseStartTime = 0L;
    private String firstHintStr;
    private boolean isExplainSql;
    private QueryPlan queryPlan;
    LinkedHashMap<String, String> queryRecord = new LinkedHashMap();
    private AclInfo aclInfo;
    private List<String> columnNames;
    private Metrics metrics = new Metrics();
    private QueryTagInfo queryTagInfo = new QueryTagInfo();
    private List<NativeQueryRealization> queryRealizations = Lists.newArrayList();

    private QueryContext() {
        this.queryId = RandomUtil.randomUUIDStr();
        this.recordMillis = System.currentTimeMillis();
        this.metrics.queryStartTime = this.recordMillis;
        this.queryPlan = new QueryPlan();
    }

    public static QueryContext current() {
        return (QueryContext)contexts.get();
    }

    public static QueryTrace currentTrace() {
        return ((QueryContext)contexts.get()).getQueryTrace();
    }

    public static void set(QueryContext queryContext) {
        contexts.set((Object)queryContext);
    }

    public static void reset() {
        contexts.remove();
    }

    public String getQueryId() {
        return this.queryId == null ? "" : this.queryId;
    }

    public String getSchema() {
        return String.join((CharSequence)",", this.queryRecord.keySet());
    }

    public String getTimeLine() {
        return String.join((CharSequence)",", this.queryRecord.values());
    }

    public void record(String message) {
        long current = System.currentTimeMillis();
        long takeTime = current - this.recordMillis;
        this.queryRecord.put(message, Long.toString(takeTime));
        this.recordMillis = current;
    }

    public void setDryRun(boolean flag) {
        this.dryRun = flag;
    }

    @Override
    public void close() {
        QueryContext.reset();
    }

    public static Metrics currentMetrics() {
        return QueryContext.current().metrics;
    }

    public static long calValueWithDefault(List<Long> scanList) {
        if (Objects.isNull(scanList)) {
            return -1L;
        }
        return scanList.stream().mapToLong(Long::longValue).sum();
    }

    public static void fillEmptyResultSetMetrics() {
        QueryContext.current().getMetrics().setScanRows(Lists.newArrayList());
        QueryContext.current().getMetrics().setScanBytes(Lists.newArrayList());
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public String getPushdownEngine() {
        return this.pushdownEngine;
    }

    @Generated
    public void setPushdownEngine(String pushdownEngine) {
        this.pushdownEngine = pushdownEngine;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public int getShufflePartitions() {
        return this.shufflePartitions;
    }

    @Generated
    public void setShufflePartitions(int shufflePartitions) {
        this.shufflePartitions = shufflePartitions;
    }

    @Generated
    public int getShufflePartitionsReset() {
        return this.shufflePartitionsReset;
    }

    @Generated
    public void setShufflePartitionsReset(int shufflePartitionsReset) {
        this.shufflePartitionsReset = shufflePartitionsReset;
    }

    @Generated
    public String getExecutionID() {
        return this.executionID;
    }

    @Generated
    public void setExecutionID(String executionID) {
        this.executionID = executionID;
    }

    @Generated
    public String getUserSQL() {
        return this.userSQL;
    }

    @Generated
    public void setUserSQL(String userSQL) {
        this.userSQL = userSQL;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Generated
    public String[] getModelPriorities() {
        return this.modelPriorities;
    }

    @Generated
    public void setModelPriorities(String[] modelPriorities) {
        this.modelPriorities = modelPriorities;
    }

    @Generated
    public QueryTrace getQueryTrace() {
        return this.queryTrace;
    }

    @Generated
    public boolean isPartialMatchIndex() {
        return this.partialMatchIndex;
    }

    @Generated
    public void setPartialMatchIndex(boolean partialMatchIndex) {
        this.partialMatchIndex = partialMatchIndex;
    }

    @Generated
    public boolean isForModeling() {
        return this.isForModeling;
    }

    @Generated
    public void setForModeling(boolean isForModeling) {
        this.isForModeling = isForModeling;
    }

    @Generated
    public boolean isForceTableIndex() {
        return this.forceTableIndex;
    }

    @Generated
    public void setForceTableIndex(boolean forceTableIndex) {
        this.forceTableIndex = forceTableIndex;
    }

    @Generated
    public Map<String, Boolean> getUnmatchedJoinDigest() {
        return this.unmatchedJoinDigest;
    }

    @Generated
    public void setUnmatchedJoinDigest(Map<String, Boolean> unmatchedJoinDigest) {
        this.unmatchedJoinDigest = unmatchedJoinDigest;
    }

    @Generated
    public boolean isEnhancedAggPushDown() {
        return this.enhancedAggPushDown;
    }

    @Generated
    public void setEnhancedAggPushDown(boolean enhancedAggPushDown) {
        this.enhancedAggPushDown = enhancedAggPushDown;
    }

    @Generated
    public String getLastUsedRelNode() {
        return this.lastUsedRelNode;
    }

    @Generated
    public void setLastUsedRelNode(String lastUsedRelNode) {
        this.lastUsedRelNode = lastUsedRelNode;
    }

    @Generated
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Generated
    public boolean isIfBigQuery() {
        return this.ifBigQuery;
    }

    @Generated
    public void setIfBigQuery(boolean ifBigQuery) {
        this.ifBigQuery = ifBigQuery;
    }

    @Generated
    public boolean isBigQuery() {
        return this.isBigQuery;
    }

    @Generated
    public void setBigQuery(boolean isBigQuery) {
        this.isBigQuery = isBigQuery;
    }

    @Generated
    public boolean isOutOfSegmentRange() {
        return this.outOfSegmentRange;
    }

    @Generated
    public void setOutOfSegmentRange(boolean outOfSegmentRange) {
        this.outOfSegmentRange = outOfSegmentRange;
    }

    @Generated
    public long getResponseStartTime() {
        return this.responseStartTime;
    }

    @Generated
    public void setResponseStartTime(long responseStartTime) {
        this.responseStartTime = responseStartTime;
    }

    @Generated
    public String getFirstHintStr() {
        return this.firstHintStr;
    }

    @Generated
    public void setFirstHintStr(String firstHintStr) {
        this.firstHintStr = firstHintStr;
    }

    @Generated
    public boolean isExplainSql() {
        return this.isExplainSql;
    }

    @Generated
    public void setExplainSql(boolean isExplainSql) {
        this.isExplainSql = isExplainSql;
    }

    @Generated
    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    @Generated
    public void setQueryPlan(QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    @Generated
    public AclInfo getAclInfo() {
        return this.aclInfo;
    }

    @Generated
    public void setAclInfo(AclInfo aclInfo) {
        this.aclInfo = aclInfo;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    @Generated
    public QueryTagInfo getQueryTagInfo() {
        return this.queryTagInfo;
    }

    @Generated
    public void setQueryTagInfo(QueryTagInfo queryTagInfo) {
        this.queryTagInfo = queryTagInfo;
    }

    @Generated
    public List<NativeQueryRealization> getQueryRealizations() {
        return this.queryRealizations;
    }

    @Generated
    public void setQueryRealizations(List<NativeQueryRealization> queryRealizations) {
        this.queryRealizations = queryRealizations;
    }

    public static class QueryPlan {
        @JsonProperty(value="calcite_plan")
        private String calcitePlan;
        @JsonProperty(value="spark_plan")
        private String sparkPlan;

        @Generated
        public String getCalcitePlan() {
            return this.calcitePlan;
        }

        @Generated
        public String getSparkPlan() {
            return this.sparkPlan;
        }

        @Generated
        public void setCalcitePlan(String calcitePlan) {
            this.calcitePlan = calcitePlan;
        }

        @Generated
        public void setSparkPlan(String sparkPlan) {
            this.sparkPlan = sparkPlan;
        }

        @Generated
        public QueryPlan() {
        }
    }

    public static class QueryTagInfo {
        private boolean isTimeout;
        private boolean hasRuntimeAgg;
        private boolean hasLike;
        private boolean isSparderUsed;
        private boolean isTableIndex;
        private boolean isHighPriorityQuery = false;
        private boolean withoutSyntaxError;
        private boolean isAsyncQuery;
        private boolean isPushdown;
        private boolean isPartial = false;
        private boolean isStorageCacheUsed = false;
        private String storageCacheType;
        private boolean hitExceptionCache = false;
        private boolean isConstantQuery = false;
        private String fileFormat;
        private String fileEncode;
        private String fileName;
        private String separator;
        private boolean isRefused;
        private boolean includeHeader;
        private boolean isVacant;
        private boolean isQueryDetect;
        private boolean isErrInterrupted;
        private String interruptReason;

        @Generated
        public boolean isTimeout() {
            return this.isTimeout;
        }

        @Generated
        public boolean isHasRuntimeAgg() {
            return this.hasRuntimeAgg;
        }

        @Generated
        public boolean isHasLike() {
            return this.hasLike;
        }

        @Generated
        public boolean isSparderUsed() {
            return this.isSparderUsed;
        }

        @Generated
        public boolean isTableIndex() {
            return this.isTableIndex;
        }

        @Generated
        public boolean isHighPriorityQuery() {
            return this.isHighPriorityQuery;
        }

        @Generated
        public boolean isWithoutSyntaxError() {
            return this.withoutSyntaxError;
        }

        @Generated
        public boolean isAsyncQuery() {
            return this.isAsyncQuery;
        }

        @Generated
        public boolean isPushdown() {
            return this.isPushdown;
        }

        @Generated
        public boolean isPartial() {
            return this.isPartial;
        }

        @Generated
        public boolean isStorageCacheUsed() {
            return this.isStorageCacheUsed;
        }

        @Generated
        public String getStorageCacheType() {
            return this.storageCacheType;
        }

        @Generated
        public boolean isHitExceptionCache() {
            return this.hitExceptionCache;
        }

        @Generated
        public boolean isConstantQuery() {
            return this.isConstantQuery;
        }

        @Generated
        public String getFileFormat() {
            return this.fileFormat;
        }

        @Generated
        public String getFileEncode() {
            return this.fileEncode;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public String getSeparator() {
            return this.separator;
        }

        @Generated
        public boolean isRefused() {
            return this.isRefused;
        }

        @Generated
        public boolean isIncludeHeader() {
            return this.includeHeader;
        }

        @Generated
        public boolean isVacant() {
            return this.isVacant;
        }

        @Generated
        public boolean isQueryDetect() {
            return this.isQueryDetect;
        }

        @Generated
        public boolean isErrInterrupted() {
            return this.isErrInterrupted;
        }

        @Generated
        public String getInterruptReason() {
            return this.interruptReason;
        }

        @Generated
        public void setTimeout(boolean isTimeout) {
            this.isTimeout = isTimeout;
        }

        @Generated
        public void setHasRuntimeAgg(boolean hasRuntimeAgg) {
            this.hasRuntimeAgg = hasRuntimeAgg;
        }

        @Generated
        public void setHasLike(boolean hasLike) {
            this.hasLike = hasLike;
        }

        @Generated
        public void setSparderUsed(boolean isSparderUsed) {
            this.isSparderUsed = isSparderUsed;
        }

        @Generated
        public void setTableIndex(boolean isTableIndex) {
            this.isTableIndex = isTableIndex;
        }

        @Generated
        public void setHighPriorityQuery(boolean isHighPriorityQuery) {
            this.isHighPriorityQuery = isHighPriorityQuery;
        }

        @Generated
        public void setWithoutSyntaxError(boolean withoutSyntaxError) {
            this.withoutSyntaxError = withoutSyntaxError;
        }

        @Generated
        public void setAsyncQuery(boolean isAsyncQuery) {
            this.isAsyncQuery = isAsyncQuery;
        }

        @Generated
        public void setPushdown(boolean isPushdown) {
            this.isPushdown = isPushdown;
        }

        @Generated
        public void setPartial(boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Generated
        public void setStorageCacheUsed(boolean isStorageCacheUsed) {
            this.isStorageCacheUsed = isStorageCacheUsed;
        }

        @Generated
        public void setStorageCacheType(String storageCacheType) {
            this.storageCacheType = storageCacheType;
        }

        @Generated
        public void setHitExceptionCache(boolean hitExceptionCache) {
            this.hitExceptionCache = hitExceptionCache;
        }

        @Generated
        public void setConstantQuery(boolean isConstantQuery) {
            this.isConstantQuery = isConstantQuery;
        }

        @Generated
        public void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Generated
        public void setFileEncode(String fileEncode) {
            this.fileEncode = fileEncode;
        }

        @Generated
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public void setSeparator(String separator) {
            this.separator = separator;
        }

        @Generated
        public void setRefused(boolean isRefused) {
            this.isRefused = isRefused;
        }

        @Generated
        public void setIncludeHeader(boolean includeHeader) {
            this.includeHeader = includeHeader;
        }

        @Generated
        public void setVacant(boolean isVacant) {
            this.isVacant = isVacant;
        }

        @Generated
        public void setQueryDetect(boolean isQueryDetect) {
            this.isQueryDetect = isQueryDetect;
        }

        @Generated
        public void setErrInterrupted(boolean isErrInterrupted) {
            this.isErrInterrupted = isErrInterrupted;
        }

        @Generated
        public void setInterruptReason(String interruptReason) {
            this.interruptReason = interruptReason;
        }
    }

    public static class Metrics {
        private String correctedSql;
        private String sqlPattern;
        private Throwable finalCause;
        private Throwable olapCause;
        private boolean exactlyMatch;
        private boolean isException;
        private int segCount;
        public int fileCount;
        private long queryStartTime;
        private long queryEndTime;
        private String server;
        private long resultRowCount;
        private String queryMsg;
        private long queryJobCount;
        private long queryStageCount;
        private long queryTaskCount;
        private long cpuTime;
        private int retryTimes;
        private long dataFetchTime;
        private String queryExecutedPlan;
        private AtomicLong sourceScanBytes = new AtomicLong();
        private AtomicLong sourceScanRows = new AtomicLong();
        private AtomicLong accumSourceScanRows = new AtomicLong();
        private List<Long> scanRows;
        private List<Long> scanBytes;
        private Boolean glutenFallback;

        public long getSourceScanBytes() {
            return this.sourceScanBytes.get();
        }

        public long getSourceScanRows() {
            return this.sourceScanRows.get();
        }

        public void setSourceScanBytes(long bytes) {
            this.sourceScanBytes.set(bytes);
        }

        public void setSourceScanRows(long bytes) {
            this.sourceScanRows.set(bytes);
        }

        public void addAccumSourceScanRows(long rows) {
            this.accumSourceScanRows.addAndGet(rows);
        }

        public long getAccumSourceScanRows() {
            return this.accumSourceScanRows.get();
        }

        public void addRetryTimes() {
            ++this.retryTimes;
        }

        public void addDataFetchTime(long dataFetchTime) {
            this.dataFetchTime = Long.max(this.dataFetchTime, dataFetchTime);
        }

        public long getTotalScanBytes() {
            return QueryContext.calValueWithDefault(this.scanBytes);
        }

        public long getTotalScanRows() {
            return QueryContext.calValueWithDefault(this.scanRows);
        }

        public long duration() {
            if (this.queryStartTime == 0L) {
                return 0L;
            }
            return this.queryEndTime == 0L ? System.currentTimeMillis() - this.queryStartTime : this.queryEndTime - this.queryStartTime;
        }

        @Generated
        public String getCorrectedSql() {
            return this.correctedSql;
        }

        @Generated
        public String getSqlPattern() {
            return this.sqlPattern;
        }

        @Generated
        public Throwable getFinalCause() {
            return this.finalCause;
        }

        @Generated
        public Throwable getOlapCause() {
            return this.olapCause;
        }

        @Generated
        public boolean isExactlyMatch() {
            return this.exactlyMatch;
        }

        @Generated
        public boolean isException() {
            return this.isException;
        }

        @Generated
        public int getSegCount() {
            return this.segCount;
        }

        @Generated
        public int getFileCount() {
            return this.fileCount;
        }

        @Generated
        public long getQueryStartTime() {
            return this.queryStartTime;
        }

        @Generated
        public long getQueryEndTime() {
            return this.queryEndTime;
        }

        @Generated
        public String getServer() {
            return this.server;
        }

        @Generated
        public long getResultRowCount() {
            return this.resultRowCount;
        }

        @Generated
        public String getQueryMsg() {
            return this.queryMsg;
        }

        @Generated
        public long getQueryJobCount() {
            return this.queryJobCount;
        }

        @Generated
        public long getQueryStageCount() {
            return this.queryStageCount;
        }

        @Generated
        public long getQueryTaskCount() {
            return this.queryTaskCount;
        }

        @Generated
        public long getCpuTime() {
            return this.cpuTime;
        }

        @Generated
        public int getRetryTimes() {
            return this.retryTimes;
        }

        @Generated
        public long getDataFetchTime() {
            return this.dataFetchTime;
        }

        @Generated
        public String getQueryExecutedPlan() {
            return this.queryExecutedPlan;
        }

        @Generated
        public void setCorrectedSql(String correctedSql) {
            this.correctedSql = correctedSql;
        }

        @Generated
        public void setSqlPattern(String sqlPattern) {
            this.sqlPattern = sqlPattern;
        }

        @Generated
        public void setFinalCause(Throwable finalCause) {
            this.finalCause = finalCause;
        }

        @Generated
        public void setOlapCause(Throwable olapCause) {
            this.olapCause = olapCause;
        }

        @Generated
        public void setExactlyMatch(boolean exactlyMatch) {
            this.exactlyMatch = exactlyMatch;
        }

        @Generated
        public void setException(boolean isException) {
            this.isException = isException;
        }

        @Generated
        public void setSegCount(int segCount) {
            this.segCount = segCount;
        }

        @Generated
        public void setFileCount(int fileCount) {
            this.fileCount = fileCount;
        }

        @Generated
        public void setQueryStartTime(long queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Generated
        public void setQueryEndTime(long queryEndTime) {
            this.queryEndTime = queryEndTime;
        }

        @Generated
        public void setServer(String server) {
            this.server = server;
        }

        @Generated
        public void setResultRowCount(long resultRowCount) {
            this.resultRowCount = resultRowCount;
        }

        @Generated
        public void setQueryMsg(String queryMsg) {
            this.queryMsg = queryMsg;
        }

        @Generated
        public void setQueryJobCount(long queryJobCount) {
            this.queryJobCount = queryJobCount;
        }

        @Generated
        public void setQueryStageCount(long queryStageCount) {
            this.queryStageCount = queryStageCount;
        }

        @Generated
        public void setQueryTaskCount(long queryTaskCount) {
            this.queryTaskCount = queryTaskCount;
        }

        @Generated
        public void setCpuTime(long cpuTime) {
            this.cpuTime = cpuTime;
        }

        @Generated
        public void setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
        }

        @Generated
        public void setDataFetchTime(long dataFetchTime) {
            this.dataFetchTime = dataFetchTime;
        }

        @Generated
        public void setQueryExecutedPlan(String queryExecutedPlan) {
            this.queryExecutedPlan = queryExecutedPlan;
        }

        @Generated
        public void setAccumSourceScanRows(AtomicLong accumSourceScanRows) {
            this.accumSourceScanRows = accumSourceScanRows;
        }

        @Generated
        public List<Long> getScanRows() {
            return this.scanRows;
        }

        @Generated
        public void setScanRows(List<Long> scanRows) {
            this.scanRows = scanRows;
        }

        @Generated
        public List<Long> getScanBytes() {
            return this.scanBytes;
        }

        @Generated
        public void setScanBytes(List<Long> scanBytes) {
            this.scanBytes = scanBytes;
        }

        @Generated
        public Boolean getGlutenFallback() {
            return this.glutenFallback;
        }

        @Generated
        public void setGlutenFallback(Boolean glutenFallback) {
            this.glutenFallback = glutenFallback;
        }
    }

    public static class AclInfo {
        private String username;
        private Set<String> groups;
        private boolean hasAdminPermission;

        public AclInfo(String username, Set<String> groups, boolean hasAdminPermission) {
            this.username = username;
            this.groups = groups;
            this.hasAdminPermission = hasAdminPermission;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public Set<String> getGroups() {
            return this.groups;
        }

        @Generated
        public boolean isHasAdminPermission() {
            return this.hasAdminPermission;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setGroups(Set<String> groups) {
            this.groups = groups;
        }

        @Generated
        public void setHasAdminPermission(boolean hasAdminPermission) {
            this.hasAdminPermission = hasAdminPermission;
        }

        @Generated
        public AclInfo() {
        }
    }
}

