/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.util.Unsafe;

public class Singletons
implements Serializable {
    transient ConcurrentHashMap<Class<?>, Object> instances = new ConcurrentHashMap();
    transient ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> instancesByPrj = new ConcurrentHashMap();
    private static final Singletons instance = new Singletons();

    public static <T> T getInstance(String project, Class<T> clz) {
        return instance.getInstance0(project, clz, Singletons.defaultCreator(project));
    }

    public static <T> T getInstance(Class<T> clz) {
        return instance.getInstance0(clz, Singletons.defaultCreator());
    }

    public static <T> T getInstance(String project, Class<T> clz, Creator<T> creator) {
        return instance.getInstance0(project, clz, creator);
    }

    public static <T> T getInstance(Class<T> clz, Creator<T> creator) {
        return instance.getInstance0(clz, creator);
    }

    public static void clearInstance(Class<?> tClass) {
        instance.clearByType(tClass);
    }

    static <T> Creator<T> defaultCreator(String project) {
        return clz -> {
            Constructor method = clz.getDeclaredConstructor(String.class);
            Unsafe.changeAccessibleObject(method, true);
            return method.newInstance(project);
        };
    }

    static <T> Creator<T> defaultCreator() {
        return clz -> {
            Constructor method = clz.getDeclaredConstructor(new Class[0]);
            Unsafe.changeAccessibleObject(method, true);
            return method.newInstance(new Object[0]);
        };
    }

    Singletons() {
    }

    <T> T getInstance0(Class<T> clz, Creator<T> creator) {
        return this.getInstance0(clz, clz, creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getInstance0(Class<T> clz, Class<?> keyClass, Creator<T> creator) {
        Object singleton;
        if (keyClass == null) {
            keyClass = clz;
        }
        Object object = singleton = this.instances == null ? null : this.instances.get(keyClass);
        if (singleton != null) {
            return (T)singleton;
        }
        Class<Object> clazz = keyClass;
        synchronized (clazz) {
            singleton = this.instances.get(keyClass);
            if (singleton != null) {
                return (T)singleton;
            }
            try {
                singleton = creator.create(clz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (singleton != null) {
                this.instances.put(keyClass, singleton);
            }
        }
        return (T)singleton;
    }

    <T> T getInstance0(String project, Class<T> clz, Creator<T> creator) {
        return this.getInstance0(project, clz, clz, creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getInstance0(String project, Class<T> clz, Class<?> keyClass, Creator<T> creator) {
        Object singleton;
        if (keyClass == null) {
            keyClass = clz;
        }
        ConcurrentHashMap<String, Object> instanceMap = null == this.instancesByPrj ? null : this.instancesByPrj.get(keyClass);
        Object object = singleton = null == instanceMap ? null : instanceMap.get(project);
        if (singleton != null) {
            return (T)singleton;
        }
        Class<Object> clazz = keyClass;
        synchronized (clazz) {
            instanceMap = this.instancesByPrj.get(keyClass);
            if (instanceMap == null) {
                instanceMap = new ConcurrentHashMap();
            }
            if ((singleton = instanceMap.get(project)) != null) {
                return (T)singleton;
            }
            try {
                singleton = creator.create(clz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (singleton != null) {
                instanceMap.put(project, singleton);
            }
            this.instancesByPrj.put(keyClass, instanceMap);
        }
        return (T)singleton;
    }

    void clear() {
        if (this.instances != null) {
            this.instances.clear();
        }
    }

    void clearByProject(String project) {
        if (this.instancesByPrj != null) {
            for (ConcurrentHashMap<String, Object> value : this.instancesByPrj.values()) {
                value.remove(project);
            }
        }
    }

    void clearByType(Class<?> clz) {
        if (this.instances != null) {
            this.instances.remove(clz);
        }
    }

    public static interface Creator<T> {
        public T create(Class<T> var1) throws Exception;
    }
}

