/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesCache {
    private static final ConcurrentHashMap<Object, Object> CACHED_SYSTEM_PROPERTY = new ConcurrentHashMap<Object, Object>(System.getProperties());

    protected static Map<Object, Object> getProperties() {
        return CACHED_SYSTEM_PROPERTY;
    }

    protected static String getProperty(String key) {
        SystemPropertiesCache.checkKey(key);
        Object oval = CACHED_SYSTEM_PROPERTY.get(key);
        return oval instanceof String ? (String)oval : null;
    }

    protected static String getProperty(String key, String defaultValue) {
        String val = SystemPropertiesCache.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public static String setProperty(String key, String value) {
        System.setProperty(key, value);
        return (String)CACHED_SYSTEM_PROPERTY.put(key, value);
    }

    public static void clearProperty(String key) {
        System.clearProperty(key);
        CACHED_SYSTEM_PROPERTY.remove(key);
    }

    private static void checkKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Property key can't be null");
        }
    }
}

