/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.AuditLogRowMapper;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.AuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.security.core.context.SecurityContextHolder;

public class JdbcAuditLogStore
implements AuditLogStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcAuditLogStore.class);
    public static final String AUDIT_LOG_SUFFIX = "_audit_log_v2";
    public static final String SELECT_TERM = "select ";
    static final String AUDIT_LOG_TABLE_ID = "id";
    static final String AUDIT_LOG_TABLE_KEY = "meta_key";
    static final String AUDIT_LOG_TABLE_CONTENT = "meta_content";
    static final String AUDIT_LOG_TABLE_TS = "meta_ts";
    static final String AUDIT_LOG_TABLE_MVCC = "meta_mvcc";
    static final String AUDIT_LOG_MODEL_UUID = "model_uuid";
    static final String AUDIT_LOG_TABLE_UNIT = "unit_id";
    static final String AUDIT_LOG_TABLE_OPERATOR = "operator";
    static final String AUDIT_LOG_TABLE_INSTANCE = "instance";
    static final String AUDIT_LOG_DIFF_FLAG = "diff_flag";
    static final String CREATE_TABLE = "create.auditlog.store.table";
    static final String META_KEY_META_MVCC_INDEX = "meta_key_meta_mvcc_index";
    static final String META_TS_INDEX = "meta_ts_index";
    static final String[] AUDIT_LOG_INDEX_NAMES = new String[]{"meta_key_meta_mvcc_index", "meta_ts_index"};
    static final String META_INDEX_KEY_PREFIX = "create.auditlog.store.tableindex.";
    static final String INSERT_SQL = "insert into %s (" + Joiner.on((String)",").join((Object)"meta_key", (Object)"meta_content", new Object[]{"meta_ts", "meta_mvcc", "unit_id", "model_uuid", "operator", "instance", "project", "diff_flag"}) + ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String SELECT_BY_RANGE_SQL = "select " + Joiner.on((String)",").join((Object)"id", (Object)"meta_key", new Object[]{"meta_content", "meta_ts", "meta_mvcc", "unit_id", "model_uuid", "operator", "instance", "project", "diff_flag"}) + " from %s where id > %d and id <= %d order by id";
    static final String SELECT_BY_ID_SQL = "select " + Joiner.on((String)",").join((Object)"id", (Object)"meta_key", new Object[]{"meta_content", "meta_ts", "meta_mvcc", "unit_id", "model_uuid", "operator", "instance", "project", "diff_flag"}) + " from %s where id in(%s) order by id";
    static final String SELECT_BY_PROJECT_RANGE_SQL = "select " + Joiner.on((String)",").join((Object)"id", (Object)"meta_key", new Object[]{"meta_content", "meta_ts", "meta_mvcc", "unit_id", "model_uuid", "operator", "instance", "project", "diff_flag"}) + " from %s where meta_key like '/%s/%%' and id > %d and id <= %d order by id";
    static final String SELECT_MAX_ID_SQL = "select max(id) from %s";
    static final String SELECT_MIN_ID_SQL = "select min(id) from %s";
    static final String SELECT_COUNT_ID_RANGE = "select count(id) from %s where id > %d and id <= %d";
    static final String DELETE_ID_LESSTHAN_SQL = "delete from %s where id < ?";
    static final String SELECT_LIST_TERM = "select " + Joiner.on((String)",").join((Object)"id", (Object)"meta_key", new Object[]{"meta_content", "meta_ts", "meta_mvcc", "unit_id", "model_uuid", "operator", "instance", "project", "diff_flag"});
    static final String SELECT_TS_RANGE = SELECT_LIST_TERM + " from %s where id < %d and meta_ts between %d and %d order by id desc limit %d";
    static final String SELECT_BY_META_KET_AND_MVCC = SELECT_LIST_TERM + " from %s where meta_key = '%s' and meta_mvcc = %s";
    static final String SELECT_COUNT_ID_ALL = "select count(id) from %s";
    static final String SELECT_MAX_ID_WITH_OFFSET = "select id from %s order by id limit 1 offset %s ";
    private final KylinConfig config;
    private final JdbcTemplate jdbcTemplate;
    private final String table;
    protected final AbstractAuditLogReplayWorker replayWorker;
    private String instance;
    private final DataSourceTransactionManager transactionManager;

    public JdbcAuditLogStore(KylinConfig config) throws Exception {
        this(config, -1);
    }

    public JdbcAuditLogStore(KylinConfig config, int timeout) throws Exception {
        this.config = config;
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters(url);
        DataSource dataSource = JdbcDataSource.getDataSource(props);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.setQueryTimeout(timeout);
        this.table = url.getIdentifier() + AUDIT_LOG_SUFFIX;
        this.instance = AddressUtil.getLocalInstance();
        this.createIfNotExist();
        this.replayWorker = new AuditLogReplayWorker(config, this);
    }

    public JdbcAuditLogStore(KylinConfig config, JdbcTemplate jdbcTemplate, DataSourceTransactionManager transactionManager, String table) throws SQLException, IOException {
        this.config = config;
        this.jdbcTemplate = jdbcTemplate;
        this.transactionManager = transactionManager;
        this.table = table;
        this.instance = AddressUtil.getLocalInstance();
        this.createIfNotExist();
        this.replayWorker = new AuditLogReplayWorker(config, this);
    }

    @Override
    public void save(UnitMessages unitMessages) {
        String unitId = unitMessages.getUnitId();
        String operator = Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse(null);
        JdbcUtil.Callback<Object> beforeCommit = null;
        if (this.config.isUnitOfWorkSimulationEnabled() && UnitOfWork.isAlreadyInTransaction() && UnitOfWork.get().getSleepMills() > 0L) {
            beforeCommit = () -> {
                long sleepMills = UnitOfWork.get().getSleepMills();
                log.debug("audit log sleep {} ", (Object)sleepMills);
                try {
                    TimeUnit.MILLISECONDS.sleep(sleepMills);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return null;
            };
        }
        JdbcUtil.withTransaction(this.transactionManager, () -> this.jdbcTemplate.batchUpdate(String.format(Locale.ROOT, INSERT_SQL, this.table), unitMessages.getMessages().stream().map(e -> {
            if (e instanceof ResourceCreateOrUpdateEvent) {
                ResourceCreateOrUpdateEvent createEvent = (ResourceCreateOrUpdateEvent)e;
                try {
                    return new Object[]{createEvent.getResPath(), CompressionUtils.compress(ByteSource.wrap((byte[])createEvent.getMetaContent()).read()), createEvent.getCreatedOrUpdated().getTs(), createEvent.getCreatedOrUpdated().getMvcc(), unitId, createEvent.getCreatedOrUpdated().getModelUuid(), operator, this.instance, createEvent.getCreatedOrUpdated().getProject(), createEvent.getCreatedOrUpdated().getContentDiff() != null};
                }
                catch (IOException ignore) {
                    return null;
                }
            }
            if (e instanceof ResourceDeleteEvent) {
                ResourceDeleteEvent deleteEvent = (ResourceDeleteEvent)e;
                return new Object[]{deleteEvent.getResPath(), null, System.currentTimeMillis(), null, unitId, null, operator, this.instance, deleteEvent.getKey(), false};
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList())), 4, beforeCommit, -1);
    }

    public void batchInsert(List<AuditLog> auditLogs) {
        JdbcUtil.withTransaction(this.transactionManager, () -> this.jdbcTemplate.batchUpdate(String.format(Locale.ROOT, INSERT_SQL, this.table), auditLogs.stream().map(x -> {
            try {
                byte[] bs = Objects.isNull(x.getByteSource()) ? null : x.getByteSource().read();
                return new Object[]{x.getResPath(), CompressionUtils.compress(bs), x.getTimestamp(), x.getMvcc(), x.getUnitId(), x.getModelUuid(), x.getOperator(), x.getInstance(), x.getProject(), x.isDiffFlag()};
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList())));
    }

    @Override
    public List<AuditLog> fetch(long currentId, long size) {
        log.trace("fetch log from {} < id <= {}", (Object)currentId, (Object)(currentId + size));
        return this.jdbcTemplate.query(String.format(Locale.ROOT, SELECT_BY_RANGE_SQL, this.table, currentId, currentId + size), (RowMapper)new AuditLogRowMapper());
    }

    @Override
    public List<AuditLog> fetch(List<Long> auditIdList) {
        if (CollectionUtils.isEmpty(auditIdList)) {
            return Lists.newArrayList();
        }
        log.trace("fetch log from {} =< id <= {},{}", new Object[]{auditIdList.get(0), auditIdList.get(auditIdList.size() - 1), auditIdList.size()});
        String sqlIn = auditIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        return this.jdbcTemplate.query(String.format(Locale.ROOT, SELECT_BY_ID_SQL, this.table, sqlIn), (RowMapper)new AuditLogRowMapper());
    }

    public List<AuditLog> fetch(String project, long currentId, long size) {
        log.trace("fetch log from {} < id <= {}", (Object)currentId, (Object)(currentId + size));
        return this.jdbcTemplate.query(String.format(Locale.ROOT, SELECT_BY_PROJECT_RANGE_SQL, this.table, project, currentId, currentId + size), (RowMapper)new AuditLogRowMapper());
    }

    public List<AuditLog> fetchRange(long fromId, long start, long end, int limit) {
        log.trace("Fetch log from {} meta_ts between {} and {}, fromId: {}.", new Object[]{this.table, start, end, fromId});
        return this.jdbcTemplate.query(String.format(Locale.ROOT, SELECT_TS_RANGE, this.table, fromId, start, end, limit), (RowMapper)new AuditLogRowMapper());
    }

    @Override
    public long getMaxId() {
        return (Long)Optional.ofNullable(this.jdbcTemplate.queryForObject(String.format(Locale.ROOT, SELECT_MAX_ID_SQL, this.table), Long.class)).orElse(0L);
    }

    @Override
    public long getMinId() {
        return (Long)Optional.ofNullable(this.jdbcTemplate.queryForObject(String.format(Locale.ROOT, SELECT_MIN_ID_SQL, this.table), Long.class)).orElse(0L);
    }

    @Override
    public long count(long startId, long endId) {
        return (Long)Optional.ofNullable(this.getJdbcTemplate().queryForObject(String.format(Locale.ROOT, SELECT_COUNT_ID_RANGE, this.table, startId, endId), Long.class)).orElse(0L);
    }

    public long countAll() {
        return (Long)Optional.ofNullable(this.getJdbcTemplate().queryForObject(String.format(Locale.ROOT, SELECT_COUNT_ID_ALL, this.table), Long.class)).orElse(0L);
    }

    public long getMaxIdWithOffset(long offset) {
        return (Long)Optional.ofNullable(this.jdbcTemplate.queryForObject(String.format(Locale.ROOT, SELECT_MAX_ID_WITH_OFFSET, this.table, offset), Long.class)).orElse(0L);
    }

    @Override
    public void restore(long currentId) {
        if ((this.config.isJobNode() || this.config.isMetadataNode()) && !this.config.isUTEnv()) {
            log.info("current maxId is {}", (Object)currentId);
            this.replayWorker.startSchedule(currentId, false);
            return;
        }
        this.replayWorker.startSchedule(currentId, true);
    }

    @Override
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Override
    public AuditLog get(String resPath, long mvcc) {
        return JdbcUtil.withTransaction(this.transactionManager, () -> {
            List result = this.jdbcTemplate.query(String.format(Locale.ROOT, SELECT_BY_META_KET_AND_MVCC, this.table, resPath, mvcc), (RowMapper)new AuditLogRowMapper());
            if (!result.isEmpty()) {
                return (AuditLog)result.get(0);
            }
            return null;
        });
    }

    @Override
    public void rotate() {
        long offset;
        long toBeDeletedRows;
        long retainMaxSize = this.config.getMetadataAuditLogMaxSize();
        int batchSize = KylinConfig.getInstanceFromEnv().getAuditLogDeleteBatchSize();
        long totalCount = this.countAll();
        if (totalCount <= retainMaxSize) {
            log.info("Audit log size:[{}] is less than or equal to maximum limit:[{}], so skip it.", (Object)totalCount, (Object)retainMaxSize);
            return;
        }
        log.info("Total audit_logs rows [{}], need to delete [{}] rows", (Object)totalCount, (Object)toBeDeletedRows);
        for (toBeDeletedRows = totalCount - retainMaxSize; toBeDeletedRows > 0L; toBeDeletedRows -= offset) {
            long startTime = System.currentTimeMillis();
            offset = Math.min(toBeDeletedRows, (long)batchSize);
            long toBeDeleteMaxId = this.getMaxIdWithOffset(offset);
            int actualCount = this.miniBatchRotate(toBeDeleteMaxId);
            log.info("delete audit_logs count: {}, cost: {}ms", (Object)actualCount, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public int miniBatchRotate(long maxId) {
        return JdbcUtil.withTransaction(this.transactionManager, () -> this.jdbcTemplate.update(String.format(Locale.ROOT, DELETE_ID_LESSTHAN_SQL, this.table), new Object[]{maxId}));
    }

    private Properties loadMedataProperties() throws IOException {
        String fileName = "metadata-jdbc-default.properties";
        if (((BasicDataSource)Objects.requireNonNull(this.getJdbcTemplate().getDataSource())).getDriverClassName().equals("org.postgresql.Driver")) {
            fileName = "metadata-jdbc-postgresql.properties";
        } else if (((BasicDataSource)this.getJdbcTemplate().getDataSource()).getDriverClassName().equals("com.mysql.jdbc.Driver")) {
            fileName = "metadata-jdbc-mysql.properties";
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    void createTableIfNotExist() throws SQLException, IOException {
        if (JdbcUtil.isTableExists(Objects.requireNonNull(this.jdbcTemplate.getDataSource()).getConnection(), this.table)) {
            return;
        }
        Properties properties = this.loadMedataProperties();
        String sql = properties.getProperty(CREATE_TABLE);
        this.jdbcTemplate.execute(String.format(Locale.ROOT, sql, this.table, AUDIT_LOG_TABLE_KEY, AUDIT_LOG_TABLE_CONTENT, AUDIT_LOG_TABLE_TS, AUDIT_LOG_TABLE_MVCC, "project", AUDIT_LOG_DIFF_FLAG));
        log.info("Succeed to create table: {}", (Object)this.table);
    }

    void createIndexIfNotExist() {
        Arrays.stream(AUDIT_LOG_INDEX_NAMES).forEach(index -> {
            try {
                String indexName = this.table + "_" + index;
                if (JdbcUtil.isIndexExists(Objects.requireNonNull(this.jdbcTemplate.getDataSource()).getConnection(), this.table, indexName)) {
                    return;
                }
                Properties properties = this.loadMedataProperties();
                String sql = properties.getProperty(META_INDEX_KEY_PREFIX + index);
                if (Strings.isNullOrEmpty((String)sql)) {
                    return;
                }
                this.jdbcTemplate.execute(String.format(Locale.ROOT, sql, indexName, this.table));
                log.info("Succeed to create table {} index: {}", (Object)this.table, (Object)indexName);
            }
            catch (Exception e) {
                log.warn("Failed create index on table {}", (Object)this.table, (Object)e);
            }
        });
    }

    void createIfNotExist() throws SQLException, IOException {
        this.createTableIfNotExist();
        this.createIndexIfNotExist();
    }

    @VisibleForTesting
    public void forceClose() {
        this.replayWorker.close(true);
    }

    @Override
    public long getLogOffset() {
        return this.replayWorker.getLogOffset();
    }

    @Override
    @Generated
    public KylinConfig getConfig() {
        return this.config;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Override
    @Generated
    public AbstractAuditLogReplayWorker getReplayWorker() {
        return this.replayWorker;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

