/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public class EventListenerRegistry {
    private final KylinConfig config;
    private Map<String, ResourceEventListener> eventListeners = Maps.newConcurrentMap();

    public static EventListenerRegistry getInstance(KylinConfig config) {
        return config.getManager(EventListenerRegistry.class);
    }

    static EventListenerRegistry newInstance(KylinConfig config) {
        return new EventListenerRegistry(config);
    }

    public EventListenerRegistry(KylinConfig config) {
        this.config = config;
    }

    public void onUpdate(ResourceCreateOrUpdateEvent event) {
        this.eventListeners.forEach((k, listener) -> listener.onUpdate(this.config, event.getCreatedOrUpdated()));
    }

    public void onDelete(ResourceDeleteEvent event) {
        this.eventListeners.forEach((k, listener) -> listener.onDelete(this.config, event.getResPath()));
    }

    public void register(ResourceEventListener eventListener, String name) {
        this.eventListeners.put(name, eventListener);
    }

    public static interface ResourceEventListener {
        public void onUpdate(KylinConfig var1, RawResource var2);

        public void onDelete(KylinConfig var1, String var2);
    }
}

