/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.scheduler;

import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSerialEventBus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectSerialEventBus.class);
    private static final long TIMEOUT_MILLISECONDS = 1800000L;
    private final EventBusFactory eventBus = EventBusFactory.getInstance();
    private final Queue<SchedulerEventNotifier> eventsQueue = new LinkedList<SchedulerEventNotifier>();
    private final Set<RunningProject> runningProjects = new HashSet<RunningProject>();
    private final Consumer<SchedulerEventNotifier> finishProjectCallback = event -> this.finishProjectAndDispatch(event.getProject());

    public static ProjectSerialEventBus getInstance() {
        return Singletons.getInstance(ProjectSerialEventBus.class);
    }

    private ProjectSerialEventBus() {
    }

    public synchronized void postAsync(SchedulerEventNotifier event) {
        log.info("Post event {} on ProjectSerialEventBus", (Object)event);
        event.setCallback(this.finishProjectCallback);
        this.eventsQueue.add(event);
        if (!this.runningProjects.contains(RunningProject.wrapForComparison(event.getProject()))) {
            this.dispatch();
        }
    }

    public synchronized void dispatch() {
        this.runningProjects.removeIf(RunningProject::isExpired);
        Iterator it = this.eventsQueue.iterator();
        while (it.hasNext()) {
            SchedulerEventNotifier e = (SchedulerEventNotifier)it.next();
            String project = e.getProject();
            if (this.runningProjects.contains(RunningProject.wrapForComparison(project))) continue;
            log.info("ProjectSerialEventBus dispatch event: {}", (Object)e);
            this.eventBus.postAsync(e);
            this.runningProjects.add(RunningProject.newInstance(project));
            it.remove();
        }
    }

    public synchronized void finishProjectAndDispatch(String project) {
        log.info("ProjectSerialEventBus project({}) event finished", (Object)project);
        this.runningProjects.remove(RunningProject.wrapForComparison(project));
        this.dispatch();
    }

    static class RunningProject {
        private final String project;
        private final long beginTime;

        static RunningProject newInstance(String project) {
            return new RunningProject(project, System.currentTimeMillis());
        }

        static RunningProject wrapForComparison(String project) {
            return new RunningProject(project, -1L);
        }

        private RunningProject(String project, long beginTime) {
            this.project = project;
            this.beginTime = beginTime;
        }

        boolean isExpired() {
            if (System.currentTimeMillis() - this.beginTime > 1800000L) {
                log.warn("ProjectSerialEventBus RunningProject expired: {}", (Object)this);
                return true;
            }
            return false;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RunningProject)) {
                return false;
            }
            RunningProject other = (RunningProject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$project = this.project;
            String other$project = other.project;
            return !(this$project == null ? other$project != null : !this$project.equals(other$project));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RunningProject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $project = this.project;
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectSerialEventBus.RunningProject(project=" + this.project + ", beginTime=" + this.beginTime + ")";
        }
    }

    public static class TimingDispatcher
    implements Runnable {
        public static final Duration INTERVAL = Duration.ofMinutes(10L);

        @Override
        public void run() {
            log.info("ProjectSerialEventBus.TimingDispatcher invokes dispatch");
            ProjectSerialEventBus.getInstance().dispatch();
        }
    }
}

