/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);

    public static void addClasspath(String path) {
        ClassUtil.addToClasspath(path, ClassLoader.getSystemClassLoader());
    }

    public static void addToClasspath(String path, ClassLoader classLoader) {
        String[] paths;
        logger.info("Adding path " + path + " to class path");
        for (String p : paths = path.split("[,:]")) {
            File file = new File(p);
            if (file.exists()) {
                ClassUtil._addToClasspath(file, classLoader);
                continue;
            }
            File dir = file.getParentFile();
            Validate.isTrue((boolean)dir.exists());
            String match = file.getName();
            Validate.isTrue((match.startsWith("*") && match.endsWith("*") ? 1 : 0) != 0);
            match = match.substring(1, match.length() - 1);
            for (File f : Objects.requireNonNull(dir.listFiles())) {
                if (!f.getName().contains(match) || !f.getName().endsWith(".jar")) continue;
                ClassUtil._addToClasspath(f, classLoader);
            }
        }
    }

    private static void _addToClasspath(File file, ClassLoader classLoader) {
        try {
            if (file.exists()) {
                logger.info("Adding path {} to class path", (Object)file);
                Class<URLClassLoader> urlClass = URLClassLoader.class;
                Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                Unsafe.changeAccessibleObject(method, true);
                method.invoke((Object)classLoader, file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<? extends T> forName(String name, Class<T> clz) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public static Object newInstance(String clz) {
        try {
            return ClassUtil.forName(clz, Object.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String findContainingJar(Class<?> clazz) {
        return ClassUtil.findContainingJar(clazz, null);
    }

    public static String findContainingJar(Class<?> clazz, String preferJarKeyWord) {
        ClassLoader loader = clazz.getClassLoader();
        String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            String toReturn;
            Enumeration<URL> e = loader.getResources(classFile);
            URL url = null;
            do {
                if (e.hasMoreElements()) continue;
                if (url != null) break;
                return null;
            } while ("jar".equals((url = e.nextElement()).getProtocol()) && (preferJarKeyWord == null || !url.getPath().contains(preferJarKeyWord)) && preferJarKeyWord != null);
            if ((toReturn = url.getPath()).startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
    }
}

