/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.storage.IStorageProvider;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.FileSystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtil {
    public static final String JOB_TMP_ROOT = "/job_tmp";
    public static final String SOURCE_TABLE_STATS_ROOT = "/source_table_stats";
    public static final String PARQUET_STORAGE_ROOT = "/parquet";
    public static final String DELTA_STORAGE_ROOT = "/delta";
    public static final String DICT_STORAGE_ROOT = "/dict";
    public static final String GLOBAL_DICT_STORAGE_ROOT = "/dict/global_dict";
    public static final String GLOBAL_DICT_V3_STORAGE_ROOT = "/dict/global_dict_v3";
    public static final String SNAPSHOT_STORAGE_ROOT = "/table_snapshot";
    public static final String FLAT_TABLE_STORAGE_ROOT = "/flat_table";
    public static final String FAST_BITMAP_SUFFIX = "_fast_bitmap";
    public static final String TABLE_EXD_STORAGE_ROOT = "/table_exd";
    private static final Logger logger = LoggerFactory.getLogger(HadoopUtil.class);
    private static final transient ThreadLocal<Configuration> hadoopConfig = new ThreadLocal();
    public static final String LOCAL_FILE_PREFIX = "file:///";
    public static final String FILE_PREFIX = "file://";
    public static final String MAPR_FS_PREFIX = "maprfs://";

    private HadoopUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void setCurrentConfiguration(Configuration conf) {
        hadoopConfig.set(conf);
    }

    public static Configuration getCurrentConfiguration() {
        if (hadoopConfig.get() == null) {
            Configuration conf = HadoopUtil.healSickConfig(new Configuration());
            return conf;
        }
        Configuration conf = hadoopConfig.get();
        return conf;
    }

    public static Configuration newLocalConfiguration() {
        Configuration conf = new Configuration(false);
        conf.set("fs.default.name", LOCAL_FILE_PREFIX);
        return conf;
    }

    public static Configuration healSickConfig(Configuration conf) {
        conf.set("yarn.timeline-service.enabled", "false");
        return conf;
    }

    public static Configuration getHadoopConfFromSparkEngine() {
        String hadoopConfDir = HadoopUtil.getHadoopConfDir();
        if (StringUtils.isBlank((CharSequence)hadoopConfDir)) {
            return new Configuration();
        }
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(Paths.get(hadoopConfDir, "core-site.xml").toFile().getAbsolutePath()));
        conf.addResource(new Path(Paths.get(hadoopConfDir, "hdfs-site.xml").toFile().getAbsolutePath()));
        conf.addResource(new Path(Paths.get(hadoopConfDir, "yarn-site.xml").toFile().getAbsolutePath()));
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        kylinConfig.getSparkConfigOverride().forEach((key, value) -> {
            String keyPrefix = "spark.hadoop.";
            if (key.startsWith("spark.hadoop.")) {
                conf.set(key.substring("spark.hadoop.".length()), value);
            }
        });
        return conf;
    }

    public static String getHadoopConfDir() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String hadoopConf = System.getProperty("kylin.hadoop.conf.dir");
        if (!config.getBuildConf().isEmpty()) {
            logger.info("write hadoop conf is {} ", (Object)config.getBuildConf());
            hadoopConf = config.getBuildConf();
        }
        String hadoopConfDirEnv = System.getenv("HADOOP_CONF_DIR");
        if (StringUtils.isEmpty((CharSequence)hadoopConf) && StringUtils.isNotEmpty((CharSequence)hadoopConfDirEnv)) {
            hadoopConf = hadoopConfDirEnv;
        }
        if (StringUtils.isEmpty((CharSequence)hadoopConf) && !config.isUTEnv()) {
            throw new KylinRuntimeException("kylin_hadoop_conf_dir is empty, check if there's error in the output of 'kylin.sh start'");
        }
        return hadoopConf;
    }

    public static FileSystem getWorkingFileSystem() {
        return HadoopUtil.getFileSystem(KylinConfig.readSystemKylinConfig().getHdfsWorkingDirectory(null));
    }

    public static FileSystem getWritingClusterFileSystem() {
        return HadoopUtil.getFileSystem(KylinConfig.readSystemKylinConfig().getWritingClusterWorkingDir());
    }

    public static FileSystem getWriteClusterFileSystem() {
        return HadoopUtil.getFileSystem(KylinConfig.readSystemKylinConfig().getWriteClusterWorkingDir());
    }

    public static FileSystem getWorkingFileSystem(Configuration conf) {
        Path workingPath = new Path(KylinConfig.readSystemKylinConfig().getHdfsWorkingDirectory(null));
        return HadoopUtil.getFileSystem(workingPath, conf);
    }

    public static FileSystem getWorkingFileSystem(Path path) {
        return HadoopUtil.getFileSystem(path);
    }

    public static FileSystem getFileSystem(String path) {
        return HadoopUtil.getFileSystem(new Path(HadoopUtil.makeURI(path)));
    }

    public static FileSystem getFileSystem(Path path) {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        return HadoopUtil.getFileSystem(path, conf);
    }

    public static FileSystem getFileSystem(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new KylinRuntimeException(e);
        }
    }

    public static URI makeURI(String filePath) {
        try {
            return new URI(HadoopUtil.fixWindowsPath(filePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from URI: " + filePath, e);
        }
    }

    public static String fixWindowsPath(String path) {
        if (path.startsWith("C:\\") || path.startsWith("D:\\")) {
            path = LOCAL_FILE_PREFIX + path;
        } else if (path.startsWith("C:/") || path.startsWith("D:/")) {
            path = LOCAL_FILE_PREFIX + path;
        } else if (path.startsWith(FILE_PREFIX) && !path.startsWith(LOCAL_FILE_PREFIX) && path.contains(":\\")) {
            path = path.replace(FILE_PREFIX, LOCAL_FILE_PREFIX);
        }
        if (path.startsWith(LOCAL_FILE_PREFIX)) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String[] parseHiveTableName(String table) {
        int cut = table.indexOf(46);
        String database = cut >= 0 ? table.substring(0, cut).trim() : "DEFAULT";
        String tableName = cut >= 0 ? table.substring(cut + 1).trim() : table.trim();
        return new String[]{database, tableName};
    }

    public static boolean deletePath(Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        if (fs.exists(path)) {
            return fs.delete(path, true);
        }
        return false;
    }

    public static byte[] toBytes(Writable writable) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            writable.write((DataOutput)out);
            out.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new KylinRuntimeException(e);
        }
    }

    public static Path getFilterOnlyPath(FileSystem fs, Path baseDir, String filter) throws IOException {
        if (!fs.exists(baseDir)) {
            return null;
        }
        FileStatus[] fileStatus = fs.listStatus(baseDir, path -> path.getName().startsWith(filter));
        if (fileStatus.length == 1) {
            return fileStatus[0].getPath();
        }
        return null;
    }

    public static String getBackupFolder(KylinConfig kylinConfig) {
        return kylinConfig.getHdfsWorkingDirectory() + "_backup";
    }

    public static String getPathWithoutScheme(String path) {
        if (path.startsWith(FILE_PREFIX)) {
            return path;
        }
        path = path.startsWith("file:") ? path.replace("file:", FILE_PREFIX) : (path.startsWith(MAPR_FS_PREFIX) ? path.replace(MAPR_FS_PREFIX, "") : Path.getPathWithoutSchemeAndAuthority((Path)new Path(path)).toString() + "/");
        return path;
    }

    public static boolean isHdfsCompatibleSchema(String path, KylinConfig kylinConfig) {
        String[] schemas = kylinConfig.getHdfsMetaStoreFileSystemSchemas();
        return Arrays.stream(schemas).anyMatch(s -> path.startsWith(s + "://"));
    }

    public static ContentSummary getContentSummary(FileSystem fileSystem, Path path) throws IOException {
        IStorageProvider provider = (IStorageProvider)ClassUtil.newInstance(KylinConfig.getInstanceFromEnv().getStorageProvider());
        logger.trace("Use provider:{}", (Object)provider.getClass().getCanonicalName());
        return provider.getContentSummary(fileSystem, path);
    }

    public static ContentSummary getContentSummaryFromHdfsKylinConfig(FileSystem fileSystem, Path path, KylinConfig kylinConfig) throws IOException {
        IStorageProvider provider = (IStorageProvider)ClassUtil.newInstance(kylinConfig.getStorageProvider());
        logger.trace("Use provider:{}", (Object)provider.getClass().getCanonicalName());
        return provider.getContentSummary(fileSystem, path);
    }

    public static List<FileStatus> getFileStatusPathsFromHDFSDir(String resPath, boolean isFile) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path path = new Path(resPath);
            FileStatus[] fileStatus = FileSystemUtil.listStatus(fs, path);
            if (isFile) {
                return Stream.of(fileStatus).filter(FileStatus::isFile).collect(Collectors.toList());
            }
            return Stream.of(fileStatus).filter(FileStatus::isDirectory).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, String.format(Locale.ROOT, "get file paths from hdfs [%s] failed!", resPath), e);
        }
    }

    public static void mkdirIfNotExist(String resPath) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path path = new Path(resPath);
        try {
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)new IOException(String.format(Locale.ROOT, "mkdir %s error", resPath), e));
        }
    }

    public static void removeOldFiles(Path path, long maxCount) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try {
            if (!fs.exists(path)) {
                return;
            }
            FileStatus[] fileStatuses = fs.listStatus(path);
            Arrays.sort(fileStatuses, FileStatus::compareTo);
            int i = fileStatuses.length - 1;
            while ((long)i > maxCount - 2L) {
                Path filePath = fileStatuses[i].getPath();
                try {
                    fs.delete(filePath, false);
                    logger.debug("Removed outdated file {}", (Object)filePath);
                }
                catch (IOException e) {
                    logger.error("Error removing outdated file {}", (Object)filePath, (Object)e);
                }
                --i;
            }
        }
        catch (IOException e) {
            logger.error("Error getting path {}", (Object)path, (Object)e);
        }
    }

    public static void uploadFileToHdfs(File file, Path path) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try {
            if (fs.exists(path) && fs.isFile(path)) {
                throw new IllegalArgumentException("The path must be a folder: " + path.getName());
            }
            File[] uploadFiles = file.isDirectory() ? file.listFiles() : new File[]{file};
            for (File fromFile : uploadFiles) {
                Path toPath = new Path(path, fromFile.getName());
                if (fromFile.isDirectory()) {
                    HadoopUtil.uploadFileToHdfs(fromFile, toPath);
                    continue;
                }
                try (FileInputStream fis = new FileInputStream(fromFile);
                     FSDataOutputStream fos = fs.create(toPath, true);){
                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot upload file to hdfs ", e);
        }
    }

    public static void downloadFileFromHdfsWithoutError(Path path, File file) {
        try {
            HadoopUtil.downloadFileFromHdfs(path, file);
        }
        catch (IllegalArgumentException e) {
            logger.error("Skip failed path: " + path.toUri().getPath(), (Throwable)e);
        }
    }

    public static void downloadFileFromHdfs(Path path, File file) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (!file.exists() || file.isFile()) {
            throw new IllegalArgumentException("The file must be an exist folder: " + file.getName());
        }
        try {
            FileStatus[] downloadFiles;
            for (FileStatus fromFile : downloadFiles = fs.listStatus(path)) {
                File toFile = new File(file, fromFile.getPath().getName());
                if (fromFile.isDirectory()) {
                    FileUtils.forceMkdir((File)toFile);
                    HadoopUtil.downloadFileFromHdfs(fromFile.getPath(), toFile);
                    continue;
                }
                try (FSDataInputStream fis = fs.open(fromFile.getPath());
                     FileOutputStream fos = new FileOutputStream(toFile);){
                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                    fos.flush();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot download file from hdfs ", e);
        }
    }

    public static void writeStringToHdfs(String content, Path path) throws IOException {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        HadoopUtil.writeStringToHdfs(fileSystem, content, path);
    }

    public static void writeStringToHdfs(FileSystem fileSystem, String content, Path path) throws IOException {
        try (FSDataOutputStream outputStream = fileSystem.create(path);){
            outputStream.writeUTF(content);
        }
    }

    public static String readStringFromHdfs(FileSystem fileSystem, Path path) throws IOException {
        try (FSDataInputStream inputStream = fileSystem.open(path);){
            String string = inputStream.readUTF();
            return string;
        }
    }

    public static String readStringFromHdfs(Path path) throws IOException {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        return HadoopUtil.readStringFromHdfs(fileSystem, path);
    }
}

