/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private static final AtomicLong poolNumber = new AtomicLong(1L);
    private AtomicLong threadNumber;
    private String namePrefix;

    public NamedThreadFactory(String namePrefix) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix + "-p-" + poolNumber.getAndIncrement();
        this.threadNumber = new AtomicLong(1L);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + "-t-" + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

