/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    private ProcessUtils() {
    }

    public static int getPid(Process process) throws IllegalAccessException, NoSuchFieldException {
        String className = process.getClass().getName();
        Preconditions.checkState((boolean)className.equals("java.lang.UNIXProcess"));
        Field f = process.getClass().getDeclaredField("pid");
        Unsafe.changeAccessibleObject(f, true);
        return f.getInt(process);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAlive(int pid) {
        try {
            Process p = Runtime.getRuntime().exec("ps -e");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
                String line;
                do {
                    if (Strings.isNullOrEmpty((String)(line = input.readLine()))) return false;
                } while (!Objects.equals(line.trim().split("\\s+")[0], pid + ""));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception err) {
            log.info("Exception happened when check <{}>", (Object)pid, (Object)err);
        }
        return false;
    }

    public static String getCurrentId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (Exception exception) {
            return fallback;
        }
    }
}

