/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.Locale;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.DateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityLoggerUtils {
    public static final String SECURITY_LOG_APPENDER = "security";
    private static final Logger securityLogger = LoggerFactory.getLogger((String)"security");
    private static final String LOGIN = "[Operation: login] user:%s, login time:%s, success:%s, ip and port:%s";
    private static final String LOGOUT = "[Operation: log out] user:%s, logout time:%s, ip and port:%s";

    private SecurityLoggerUtils() {
    }

    public static void recordLoginSuccess(String username) {
        String loginSuccessMsg = String.format(Locale.ROOT, LOGIN, username, DateFormat.formatToTimeWithoutMilliStr(System.currentTimeMillis()), Boolean.TRUE, AddressUtil.getLocalInstance());
        try (SetLogCategory logCategory = new SetLogCategory(SECURITY_LOG_APPENDER);){
            securityLogger.info(loginSuccessMsg);
        }
    }

    public static void recordLoginFailed(String username, Exception e) {
        String loginErrorMsg = String.format(Locale.ROOT, LOGIN, username, DateFormat.formatToTimeWithoutMilliStr(System.currentTimeMillis()), Boolean.FALSE, AddressUtil.getLocalInstance());
        try (SetLogCategory logCategory = new SetLogCategory(SECURITY_LOG_APPENDER);){
            securityLogger.error(loginErrorMsg, (Throwable)e);
        }
    }

    public static void recordLogout(String username) {
        String logoutMessage = String.format(Locale.ROOT, LOGOUT, username, DateFormat.formatToTimeWithoutMilliStr(System.currentTimeMillis()), AddressUtil.getLocalInstance());
        try (SetLogCategory logCategory = new SetLogCategory(SECURITY_LOG_APPENDER);){
            securityLogger.info(logoutMessage);
        }
    }
}

