/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.event.StreamingJobDropEvent;
import org.apache.kylin.streaming.event.StreamingJobKillEvent;
import org.apache.kylin.streaming.event.StreamingJobMetaCleanEvent;
import org.apache.kylin.streaming.jobs.scheduler.StreamingScheduler;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.util.JobKiller;
import org.apache.kylin.streaming.util.MetaInfoUpdater;
import org.apache.spark.launcher.SparkAppHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobListener
implements SparkAppHandle.Listener {
    private static final Logger logger = LoggerFactory.getLogger(StreamingJobListener.class);
    private String project;
    private String jobId;
    private String runnable;

    public StreamingJobListener() {
    }

    public StreamingJobListener(String project, String jobId) {
        this.project = project;
        this.jobId = jobId;
    }

    public void stateChanged(SparkAppHandle handler) {
        if (handler.getState().isFinal()) {
            this.runnable = null;
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            StreamingJobManager mgr = StreamingJobManager.getInstance(config, this.project);
            StreamingJobMeta jobMeta = mgr.getStreamingJobByUuid(this.jobId);
            if (this.isFailed(handler.getState()) && !jobMeta.isSkipListener()) {
                logger.warn("The streaming job {} has terminated unexpectedly\u2026", (Object)this.jobId);
                handler.kill();
                JobKiller.killProcess(jobMeta);
                JobKiller.killApplication(this.jobId);
                MetaInfoUpdater.updateJobState(this.project, this.jobId, Sets.newHashSet((Object[])new JobStatusEnum[]{JobStatusEnum.ERROR, JobStatusEnum.STOPPED}), JobStatusEnum.ERROR);
            } else if (this.isFinished(handler.getState())) {
                handler.stop();
                JobKiller.killProcess(jobMeta);
                JobKiller.killApplication(this.jobId);
                MetaInfoUpdater.updateJobState(this.project, this.jobId, Sets.newHashSet((Object[])new JobStatusEnum[]{JobStatusEnum.ERROR, JobStatusEnum.STOPPED}), JobStatusEnum.STOPPED);
            }
        } else if (this.runnable == null && SparkAppHandle.State.RUNNING == handler.getState()) {
            this.runnable = "true";
            MetaInfoUpdater.updateJobState(this.project, this.jobId, JobStatusEnum.RUNNING);
        }
    }

    private boolean isFailed(SparkAppHandle.State state) {
        return SparkAppHandle.State.FAILED == state || SparkAppHandle.State.KILLED == state || SparkAppHandle.State.LOST == state;
    }

    private boolean isFinished(SparkAppHandle.State state) {
        return SparkAppHandle.State.FINISHED == state;
    }

    public void infoChanged(SparkAppHandle handler) {
    }

    @Subscribe
    public void onStreamingJobKill(StreamingJobKillEvent streamingJobKillEvent) {
        String modelId = streamingJobKillEvent.getModelId();
        StreamingScheduler scheduler = StreamingScheduler.getInstance();
        scheduler.killJob(streamingJobKillEvent.getProject(), modelId, JobTypeEnum.STREAMING_MERGE, JobStatusEnum.STOPPED);
        scheduler.killJob(streamingJobKillEvent.getProject(), modelId, JobTypeEnum.STREAMING_BUILD, JobStatusEnum.STOPPED);
    }

    @Subscribe
    public void onStreamingJobDrop(StreamingJobDropEvent streamingJobDropEvent) {
        String modelId = streamingJobDropEvent.getModelId();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StreamingJobManager mgr = StreamingJobManager.getInstance(config, streamingJobDropEvent.getProject());
        String buildJobId = StreamingUtils.getJobId((String)modelId, (String)JobTypeEnum.STREAMING_BUILD.toString());
        String mergeJobId = StreamingUtils.getJobId((String)modelId, (String)JobTypeEnum.STREAMING_MERGE.toString());
        mgr.deleteStreamingJob(buildJobId);
        mgr.deleteStreamingJob(mergeJobId);
    }

    @Subscribe
    public void onStreamingJobMetaCleanEvent(StreamingJobMetaCleanEvent streamingJobMetaCleanEvent) {
        List<Path> deletedPath = streamingJobMetaCleanEvent.getDeletedMetaPath();
        if (CollectionUtils.isEmpty(deletedPath)) {
            logger.debug("path list is empty, skip to delete.");
            return;
        }
        logger.info("begin to delete streaming meta path size:{}", (Object)deletedPath.size());
        deletedPath.forEach(path -> {
            try {
                boolean deleteSuccess = HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)path);
                logger.debug("delete streaming meta {} path:{}", (Object)deleteSuccess, path);
            }
            catch (IOException e) {
                logger.warn("delete streaming meta path:{} error", path, (Object)e);
            }
        });
    }
}

