/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.kylin.measure.hllc.Register;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.measure.hllc.SingleValueRegister;
import org.apache.kylin.measure.hllc.SparseRegister;

public class DenseRegister
implements Register,
Serializable {
    private int m;
    private byte[] register;

    public DenseRegister(int p) {
        this.m = 1 << p;
        this.register = new byte[this.m];
    }

    @Override
    public void set(int pos, byte value) {
        this.register[pos] = value;
    }

    @Override
    public byte get(int pos) {
        return this.register[pos];
    }

    @Override
    public void merge(Register another) {
        if (another.getRegisterType() == RegisterType.DENSE) {
            DenseRegister dr = (DenseRegister)another;
            for (int i = 0; i < this.register.length; ++i) {
                if (dr.register[i] <= this.register[i]) continue;
                this.register[i] = dr.register[i];
            }
        } else if (another.getRegisterType() == RegisterType.SPARSE) {
            SparseRegister sr = (SparseRegister)another;
            Collection<Map.Entry<Integer, Byte>> allValue = sr.getAllValue();
            for (Map.Entry<Integer, Byte> entry : allValue) {
                if (entry.getValue() <= this.register[entry.getKey()]) continue;
                this.register[entry.getKey().intValue()] = entry.getValue();
            }
        } else {
            SingleValueRegister sr = (SingleValueRegister)another;
            if (sr.getSize() > 0 && sr.getValue() > this.register[sr.getSingleValuePos()]) {
                this.register[sr.getSingleValuePos()] = sr.getValue();
            }
        }
    }

    @Override
    public void clear() {
        byte zero = 0;
        Arrays.fill(this.register, zero);
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int i = 0; i < this.m; ++i) {
            if (this.register[i] <= 0) continue;
            ++size;
        }
        return size;
    }

    @Override
    public RegisterType getRegisterType() {
        return RegisterType.DENSE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.register);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DenseRegister other = (DenseRegister)obj;
        return Arrays.equals(this.register, other.register);
    }

    public byte[] getRawRegister() {
        return this.register;
    }
}

