/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveSpanningTree
implements Serializable {
    private static final long serialVersionUID = 5981664173055110627L;
    private static final Logger logger = LoggerFactory.getLogger(AdaptiveSpanningTree.class);
    protected final transient List<TreeNode> treeNodes;
    protected final transient List<TreeNode> level0thNodes;
    protected final double adaptiveThreshold;
    protected final int adaptiveBatchSize;
    protected final String segmentId;
    private final boolean adaptive;
    private transient Map<Long, TreeNode> cachedNodeMap;

    public AdaptiveSpanningTree(KylinConfig config, AdaptiveTreeBuilder builder) {
        this.adaptive = config.isAdaptiveSpanningTreeEnabled();
        this.adaptiveThreshold = config.getAdaptiveSpanningTreeThreshold();
        this.adaptiveBatchSize = config.getAdaptiveSpanningTreeBatchSize();
        this.segmentId = builder.getSegmentId();
        this.treeNodes = builder.buildTreeNodes();
        this.level0thNodes = this.getLevel0thNodes(this.treeNodes);
        this.buildMappings(this.treeNodes);
    }

    public boolean fromFlatTable() {
        return this.level0thNodes.stream().anyMatch(TreeNode::parentIsNull);
    }

    public boolean isSpanned() {
        return this.treeNodes.stream().allMatch(TreeNode::isSpanned);
    }

    public boolean canSpan() {
        return this.treeNodes.stream().anyMatch(TreeNode::nonSpanned);
    }

    public List<TreeNode> span(NDataSegment dataSegment) {
        if (this.adaptive) {
            return this.adaptiveSpan(dataSegment);
        }
        return this.layeredSpan(dataSegment);
    }

    public List<IndexEntity> getLevel0thIndices() {
        return this.level0thNodes.stream().map(TreeNode::getIndex).collect(Collectors.toList());
    }

    public List<IndexEntity> getIndices() {
        return this.treeNodes.stream().map(TreeNode::getIndex).collect(Collectors.toList());
    }

    public List<TreeNode> getFromFlatTableNodes() {
        return this.level0thNodes.stream().filter(TreeNode::parentIsNull).collect(Collectors.toList());
    }

    public List<TreeNode> getRootNodes() {
        return this.level0thNodes.stream().filter(TreeNode::parentNonNull).map(TreeNode::getParent).distinct().collect(Collectors.toList());
    }

    protected void buildMappings(List<TreeNode> nodes) {
        HashMap mappings = Maps.newHashMap();
        nodes.forEach(node -> mappings.put(node.getIndex().getId(), node));
        this.cachedNodeMap = Collections.unmodifiableMap(mappings);
    }

    protected final <T extends Candidate> T getOptimalCandidate(List<T> parents) {
        if (parents.isEmpty()) {
            return null;
        }
        int directParentSize = ((Candidate)parents.get(0)).getNode().getDirectParents().size();
        Preconditions.checkState((directParentSize > 0 ? 1 : 0) != 0, (Object)"Direct parent size should be positive.");
        double fraction = (double)parents.size() / (double)directParentSize;
        if (fraction < this.adaptiveThreshold) {
            return null;
        }
        Candidate candidate = parents.stream().min(Comparator.comparingLong(Candidate::getParentRows)).orElse(null);
        if (Objects.nonNull(candidate)) {
            candidate.setFraction(fraction);
        }
        return (T)candidate;
    }

    protected List<TreeNode> adaptiveSpan(NDataSegment dataSegment) {
        Comparator<Candidate> comparator = Comparator.comparingInt(Candidate::getParentLevel).thenComparingDouble(Candidate::getParentUnfinishedFraction).thenComparingLong(Candidate::getParentRows).thenComparingInt(Candidate::getLocalPriority).thenComparingLong(Candidate::getIndexId);
        return this.treeNodes.stream().filter(TreeNode::nonSpanned).map(node -> {
            if (node.getDirectParents().isEmpty()) {
                Candidate candidate = new Candidate((TreeNode)node, null, null);
                candidate.setFraction(1.0);
                return candidate;
            }
            return this.getOptimalCandidate(this.getParentCandidates((TreeNode)node, dataSegment));
        }).filter(Objects::nonNull).sorted(comparator).limit(this.adaptiveBatchSize).map(this::markSpanned).collect(Collectors.toList());
    }

    protected List<TreeNode> layeredSpan(NDataSegment dataSegment) {
        Comparator<Candidate> comparator = Comparator.comparingLong(Candidate::getIndexId);
        return this.treeNodes.stream().filter(TreeNode::nonSpanned).map(node -> {
            if (node.getDirectParents().isEmpty()) {
                Candidate candidate = new Candidate((TreeNode)node, null, null);
                candidate.setFraction(1.0);
                return candidate;
            }
            List<Candidate> parents = this.getParentCandidates((TreeNode)node, dataSegment);
            if (parents.size() < node.getDirectParents().size()) {
                return null;
            }
            return parents.stream().min(Comparator.comparingLong(Candidate::getParentRows)).orElse(null);
        }).filter(Objects::nonNull).sorted(comparator).map(this::markSpanned).collect(Collectors.toList());
    }

    protected TreeNode markSpanned(Candidate candidate) {
        logger.info("Segment {} spanned node: {}", (Object)this.segmentId, (Object)candidate.getReadableDesc());
        TreeNode node = candidate.getNode();
        TreeNode parent = candidate.getParent();
        node.setSpanned();
        if (Objects.isNull(parent)) {
            return node;
        }
        parent.layout = candidate.getParentLayout();
        node.level = parent.level + 1;
        node.parent = parent;
        node.rootNode = parent.rootNode;
        parent.subtrees.add(node);
        return node;
    }

    private TreeNode getNode(IndexEntity index) {
        Preconditions.checkNotNull((Object)index, (Object)"Index shouldn't be null.");
        Preconditions.checkNotNull(this.cachedNodeMap, (Object)"Node mappings' cache shouldn't be null.");
        return this.cachedNodeMap.get(index.getId());
    }

    private List<Candidate> getParentCandidates(TreeNode node, NDataSegment dataSegment) {
        return node.getDirectParents().stream().map(this::getNode).filter(Objects::nonNull).map(parent -> parent.getLayouts().stream().map(layout -> dataSegment.getLayout(layout.getId())).filter(Objects::nonNull).findAny().map(layout -> new Candidate(node, (TreeNode)parent, (NDataLayout)layout)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<TreeNode> getLevel0thNodes(List<TreeNode> nodes) {
        List targets = nodes.stream().filter(node -> node.level == 0).collect(Collectors.toList());
        Map partitioned = Maps.transformValues(targets.stream().collect(Collectors.partitioningBy(TreeNode::parentIsNull)), partitionedNodes -> {
            if (Objects.isNull(partitionedNodes)) {
                return "[]";
            }
            return partitionedNodes.stream().map(TreeNode::getIndex).map(IndexEntity::getId).distinct().sorted().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
        });
        logger.info("Segment {} nodes build from flat table {}, nodes build from data layout {}.", new Object[]{this.segmentId, partitioned.get(true), partitioned.get(false)});
        return Collections.unmodifiableList(targets);
    }

    protected static class Candidate {
        private final TreeNode node;
        private final TreeNode parent;
        private final NDataLayout dataLayout;
        private double fraction;

        protected Candidate(TreeNode node, TreeNode parent, NDataLayout dataLayout) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkState((parent == null == (dataLayout == null) ? 1 : 0) != 0, (Object)"Both parent and dataLayout must be defined, or neither.");
            this.node = node;
            this.parent = parent;
            this.dataLayout = dataLayout;
        }

        protected TreeNode getNode() {
            return this.node;
        }

        protected TreeNode getParent() {
            return this.parent;
        }

        protected Long getIndexId() {
            return this.node.index.getId();
        }

        protected Integer getParentLevel() {
            if (Objects.isNull(this.parent)) {
                return -1;
            }
            return this.parent.level;
        }

        protected LayoutEntity getParentLayout() {
            Preconditions.checkNotNull((Object)this.dataLayout, (Object)"Parent data layout shouldn't be null.");
            return this.dataLayout.getLayout();
        }

        protected Long getParentRows() {
            if (Objects.isNull(this.dataLayout)) {
                return -1L;
            }
            return this.dataLayout.getRows();
        }

        protected void setFraction(double fraction) {
            this.fraction = fraction;
        }

        protected Double getParentUnfinishedFraction() {
            return 1.0 - this.fraction;
        }

        protected Integer getLocalPriority() {
            return this.node.getLocalPriority();
        }

        protected String getReadableDesc() {
            return "index " + this.node.getIndex().getId() + ", optimal parent " + this.getParentDesc() + ", parent level " + this.getParentLevel() + ", completion rate " + String.format(Locale.ROOT, "%.3f", this.fraction) + ", direct parents " + this.getDirectParentsDesc();
        }

        private String getParentDesc() {
            if (Objects.nonNull(this.parent)) {
                return String.valueOf(this.dataLayout.getLayout().getId());
            }
            if (Objects.isNull(this.node.getParent())) {
                return "flat table";
            }
            return String.valueOf(this.node.getParent().getLayout().getId());
        }

        private String getDirectParentsDesc() {
            return this.node.getDirectParents().stream().map(IndexEntity::getId).map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
        }
    }

    protected static class LayoutNode {
        private final LayoutEntity layout;
        protected boolean spanned = false;

        public LayoutNode(LayoutEntity layout) {
            this.layout = layout;
        }

        protected boolean isSpanned() {
            return this.spanned;
        }

        protected boolean nonSpanned() {
            return !this.spanned;
        }

        protected void setSpanned() {
            this.spanned = true;
        }

        protected LayoutEntity getLayout() {
            return this.layout;
        }
    }

    public static class TreeNode {
        protected TreeNode parent;
        protected TreeNode rootNode;
        protected LayoutEntity layout;
        protected final IndexEntity index;
        protected final List<LayoutNode> layoutNodes;
        protected int level = -1;
        protected final List<TreeNode> subtrees = Lists.newArrayList();
        protected List<IndexEntity> directParents = Collections.emptyList();
        protected int localPriority = -1;

        public TreeNode(IndexEntity index, List<LayoutEntity> layouts) {
            Preconditions.checkNotNull((Object)index);
            Preconditions.checkNotNull(layouts);
            Preconditions.checkArgument((!layouts.isEmpty() ? 1 : 0) != 0, (Object)("No spanning-tree layout in index " + index.getId()));
            this.index = index;
            this.layoutNodes = layouts.stream().map(LayoutNode::new).collect(Collectors.toList());
        }

        public boolean parentIsNull() {
            return Objects.isNull(this.parent);
        }

        public boolean parentNonNull() {
            return !this.parentIsNull();
        }

        public boolean isSpanned() {
            return this.layoutNodes.stream().allMatch(LayoutNode::isSpanned);
        }

        public boolean nonSpanned() {
            return this.layoutNodes.stream().anyMatch(LayoutNode::nonSpanned);
        }

        public void setSpanned() {
            this.layoutNodes.forEach(LayoutNode::setSpanned);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public TreeNode getRootNode() {
            return this.rootNode;
        }

        public List<IndexEntity> getDirectParents() {
            return this.directParents;
        }

        public IndexEntity getIndex() {
            return this.index;
        }

        public LayoutEntity getLayout() {
            Preconditions.checkNotNull((Object)this.layout, (Object)"Parent data layout shouldn't be null.");
            return this.layout;
        }

        public List<LayoutEntity> getLayouts() {
            return Collections.unmodifiableList(this.layoutNodes.stream().map(LayoutNode::getLayout).collect(Collectors.toList()));
        }

        public List<TreeNode> getSubtrees() {
            return this.subtrees;
        }

        public int getNonSpannedCount() {
            return this.layoutNodes.stream().filter(LayoutNode::nonSpanned).map(e -> 1).reduce(0, Integer::sum);
        }

        public int getDimensionSize() {
            return this.index.getEffectiveDimCols().size();
        }

        public void setLocalPriority(int localPriority) {
            this.localPriority = localPriority;
        }

        public int getLocalPriority() {
            return this.localPriority;
        }
    }

    public static class AdaptiveTreeBuilder {
        protected final NDataSegment dataSegment;
        protected final List<IndexEntity> indexPlanIndices;
        protected final Map<IndexEntity, List<LayoutEntity>> indexLayoutsMap;
        protected final SortedSet<IndexEntity> sorted;

        public AdaptiveTreeBuilder(NDataSegment dataSegment, Collection<LayoutEntity> layouts) {
            Preconditions.checkNotNull((Object)dataSegment, (Object)"Data segment shouldn't be null.");
            Preconditions.checkNotNull(layouts, (Object)"Layouts shouldn't be null.");
            this.dataSegment = dataSegment;
            this.indexLayoutsMap = this.getIndexLayoutsMap(layouts);
            this.indexPlanIndices = dataSegment.getIndexPlan().getAllIndexes();
            TreeSet sortedSet0 = Sets.newTreeSet((i1, i2) -> {
                int c = Integer.compare(i1.getDimensions().size(), i2.getDimensions().size());
                if (c == 0) {
                    return Long.compare(i1.getId(), i2.getId());
                }
                return c;
            });
            sortedSet0.addAll(this.indexLayoutsMap.keySet());
            this.sorted = Collections.unmodifiableSortedSet(sortedSet0);
        }

        protected List<TreeNode> buildTreeNodes() {
            HashMap ancestorNodeMap = Maps.newHashMap();
            return Collections.unmodifiableList(this.indexLayoutsMap.entrySet().stream().map(indexLayouts -> {
                IndexEntity index = (IndexEntity)indexLayouts.getKey();
                List layouts = (List)indexLayouts.getValue();
                TreeNode node = new TreeNode(index, layouts);
                List<IndexEntity> directParents = this.getDirectParents(index);
                if (directParents.isEmpty()) {
                    node.level = 0;
                    NDataLayout dataLayout = this.indexPlanIndices.stream().filter(parent -> parent.fullyDerive(index)).map(parent -> parent.getLayouts().stream().map(layout -> this.dataSegment.getLayout(layout.getId())).filter(Objects::nonNull).findAny().orElse(null)).filter(Objects::nonNull).min(Comparator.comparingLong(NDataLayout::getRows)).orElse(null);
                    if (Objects.nonNull(dataLayout)) {
                        TreeNode ancestor = this.getAncestorNode(dataLayout.getLayout(), ancestorNodeMap);
                        ancestor.subtrees.add(node);
                        node.parent = ancestor;
                        node.rootNode = ancestor;
                    }
                } else {
                    node.directParents = directParents;
                }
                node.layoutNodes.forEach(lnode -> {
                    if (Objects.nonNull(this.dataSegment.getLayout(((LayoutNode)lnode).layout.getId()))) {
                        lnode.setSpanned();
                        logger.info("Segment {} skip build layout {}", (Object)this.dataSegment.getId(), (Object)((LayoutNode)lnode).layout.getId());
                    }
                });
                return node;
            }).collect(Collectors.toList()));
        }

        private String getSegmentId() {
            return this.dataSegment.getId();
        }

        private Map<IndexEntity, List<LayoutEntity>> getIndexLayoutsMap(Collection<LayoutEntity> layouts) {
            HashMap mappings = Maps.newHashMap();
            layouts.forEach(layout -> {
                IndexEntity index = layout.getIndex();
                List mappedLayouts = (List)mappings.get(index);
                if (Objects.isNull(mappedLayouts)) {
                    mappedLayouts = Lists.newArrayList();
                    mappings.put(index, mappedLayouts);
                }
                mappedLayouts.add(layout);
            });
            return Collections.unmodifiableMap(mappings);
        }

        private TreeNode getAncestorNode(LayoutEntity layout, Map<Long, TreeNode> ancestorNodeMap) {
            TreeNode ancestor = ancestorNodeMap.get(layout.getIndex().getId());
            if (Objects.isNull(ancestor)) {
                ancestor = new TreeNode(layout.getIndex(), Lists.newArrayList((Object[])new LayoutEntity[]{layout}));
                ancestor.layout = layout;
                ancestor.layoutNodes.forEach(LayoutNode::setSpanned);
                ancestorNodeMap.put(layout.getIndex().getId(), ancestor);
            }
            return ancestor;
        }

        protected final List<IndexEntity> getDirectParents(IndexEntity index) {
            ArrayList candidates = Lists.newArrayList();
            this.sorted.stream().filter(e -> e.fullyDerive(index)).forEach(e -> {
                if (e.equals(index)) {
                    return;
                }
                if (candidates.stream().anyMatch(e::fullyDerive)) {
                    return;
                }
                candidates.add(e);
            });
            return Collections.unmodifiableList(candidates);
        }
    }
}

