/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.exception.OutOfMaxCombinationException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Iterators;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.collect.UnmodifiableIterator;
import org.apache.kylin.metadata.cube.cuboid.CuboidBigInteger;
import org.apache.kylin.metadata.cube.cuboid.CuboidScheduler;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.cuboid.OrderedSet;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KECuboidSchedulerV2
extends CuboidScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KECuboidSchedulerV2.class);
    private final int measureSize;
    private final transient OrderedSet<CuboidScheduler.ColOrder> allColOrders;

    KECuboidSchedulerV2(IndexPlan indexPlan, RuleBasedIndex ruleBasedAggIndex, boolean skipAll) {
        super(indexPlan, ruleBasedAggIndex);
        long maxCombinationSize;
        BigInteger max = ruleBasedAggIndex.getFullMask();
        this.measureSize = ruleBasedAggIndex.getMeasures().size();
        this.allColOrders = new OrderedSet();
        if (max.bitCount() == 0 || skipAll) {
            return;
        }
        if (ruleBasedAggIndex.getBaseLayoutEnabled() == null) {
            ruleBasedAggIndex.setBaseLayoutEnabled(true);
        }
        if (Boolean.TRUE.equals(ruleBasedAggIndex.getBaseLayoutEnabled())) {
            this.allColOrders.add(new CuboidScheduler.ColOrder(ruleBasedAggIndex.getDimensions(), ruleBasedAggIndex.getMeasures()));
        }
        maxCombinationSize = (maxCombinationSize = this.getAggGroupCombinationSize() * 10L) < 0L ? Integer.MAX_VALUE : maxCombinationSize;
        for (NAggregationGroup agg : ruleBasedAggIndex.getAggregationGroups()) {
            this.allColOrders.addAll((Collection<CuboidScheduler.ColOrder>)this.calculateCuboidsForAggGroup(agg));
            if ((long)this.allColOrders.size() <= maxCombinationSize) continue;
            throw new OutOfMaxCombinationException((ErrorCodeProducer)ErrorCodeServer.OUT_OF_MAX_DIM_COMBINATION, new Object[]{maxCombinationSize});
        }
    }

    @Override
    public int getCuboidCount() {
        return this.allColOrders.size();
    }

    @Override
    public void validateOrder() {
    }

    @Override
    public void updateOrder() {
    }

    @Override
    public List<CuboidScheduler.ColOrder> getAllColOrders() {
        return this.allColOrders.getSortedList();
    }

    @Override
    public List<CuboidScheduler.ColOrder> calculateCuboidsForAggGroup(NAggregationGroup agg) {
        OrderedSet cuboidHolder = new OrderedSet();
        Set<CuboidBigInteger> children = this.getOnTreeParentsByLayer(Sets.newHashSet((Object[])new CuboidBigInteger[]{new CuboidBigInteger(BigInteger.ZERO)}), agg);
        while (!children.isEmpty()) {
            if ((long)(cuboidHolder.size() + children.size()) > this.getAggGroupCombinationSize()) {
                throw new OutOfMaxCombinationException((ErrorCodeProducer)ErrorCodeServer.OUT_OF_MAX_DIM_COMBINATION, new Object[]{this.getAggGroupCombinationSize()});
            }
            cuboidHolder.addAll(children);
            children = this.getOnTreeParentsByLayer(children, agg);
        }
        return cuboidHolder.stream().map(c -> {
            CuboidScheduler.ColOrder colOrder = this.extractDimAndMeaFromBigInt(c.getDimMeas());
            colOrder.getDimensions().sort(Comparator.comparingInt(x -> ArrayUtils.indexOf((Object[])agg.getIncludes(), (Object)x)));
            return colOrder;
        }).collect(Collectors.toList());
    }

    private Set<CuboidBigInteger> getOnTreeParentsByLayer(Collection<CuboidBigInteger> children, NAggregationGroup agg) {
        OrderedSet<CuboidBigInteger> parents = new OrderedSet<CuboidBigInteger>();
        for (CuboidBigInteger child : children) {
            parents.addAll(this.getOnTreeParents(child, agg));
        }
        UnmodifiableIterator filteredParent = Iterators.filter(parents.iterator(), cuboidId -> {
            if (cuboidId == null) {
                return false;
            }
            return agg.checkDimCap(cuboidId.getDimMeas());
        });
        parents = new OrderedSet();
        while (filteredParent.hasNext()) {
            parents.add(filteredParent.next());
        }
        return parents;
    }

    private Set<CuboidBigInteger> getOnTreeParents(CuboidBigInteger child, NAggregationGroup agg) {
        OrderedSet<CuboidBigInteger> parentCandidate = new OrderedSet<CuboidBigInteger>();
        BigInteger tmpChild = child.getDimMeas();
        if (tmpChild.equals(agg.getPartialCubeFullMask())) {
            return parentCandidate;
        }
        if (!agg.getMandatoryColumnMask().equals(agg.getMeasureMask())) {
            if (agg.isMandatoryOnlyValid()) {
                if (this.fillBit(tmpChild, agg.getMandatoryColumnMask(), parentCandidate)) {
                    return parentCandidate;
                }
            } else {
                tmpChild = tmpChild.or(agg.getMandatoryColumnMask());
            }
        }
        for (BigInteger normal : agg.getNormalDimMeas()) {
            this.fillBit(tmpChild, normal, parentCandidate);
        }
        for (BigInteger joint : agg.getJoints()) {
            this.fillBit(tmpChild, joint, parentCandidate);
        }
        for (NAggregationGroup.HierarchyMask hierarchy : agg.getHierarchyMasks()) {
            for (BigInteger mask : hierarchy.getAllMasks()) {
                if (this.fillBit(tmpChild, mask, parentCandidate)) break;
            }
        }
        return parentCandidate;
    }

    private boolean fillBit(BigInteger origin, BigInteger other, Set<CuboidBigInteger> coll) {
        if (!origin.and(other).equals(other)) {
            coll.add(new CuboidBigInteger(origin.or(other), this.measureSize));
            return true;
        }
        return false;
    }
}

