/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.IncludedLayoutOptStrategy;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizer;
import org.apache.kylin.metadata.cube.optimization.LowFreqLayoutOptStrategy;
import org.apache.kylin.metadata.cube.optimization.MergedLayoutOptStrategy;
import org.apache.kylin.metadata.cube.optimization.SimilarLayoutOptStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class IndexOptimizerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexOptimizerFactory.class);
    private static final AbstractOptStrategy INCLUDED_OPT_STRATEGY = new IncludedLayoutOptStrategy();
    private static final AbstractOptStrategy LOW_FREQ_OPT_STRATEGY = new LowFreqLayoutOptStrategy();
    private static final AbstractOptStrategy SIMILAR_OPT_STRATEGY = new SimilarLayoutOptStrategy();
    private static final AbstractOptStrategy MERGED_OPT_STRATEGY = new MergedLayoutOptStrategy();

    private IndexOptimizerFactory() {
    }

    public static IndexOptimizer getOptimizer(NDataflow dataflow, boolean needAggressiveOpt, boolean needLog) {
        IndexOptimizer optimizer = new IndexOptimizer(needLog);
        int indexOptimizationLevel = KylinConfig.getInstanceFromEnv().getIndexOptimizationLevel();
        if (indexOptimizationLevel == 1) {
            optimizer.getStrategiesForAuto().add(INCLUDED_OPT_STRATEGY);
        } else if (indexOptimizationLevel == 2) {
            optimizer.getStrategiesForAuto().addAll(Lists.newArrayList((Object[])new AbstractOptStrategy[]{INCLUDED_OPT_STRATEGY, LOW_FREQ_OPT_STRATEGY}));
        } else if (indexOptimizationLevel == 3) {
            optimizer.getStrategiesForAuto().addAll(Lists.newArrayList((Object[])new AbstractOptStrategy[]{INCLUDED_OPT_STRATEGY, LOW_FREQ_OPT_STRATEGY}));
            optimizer.getStrategiesForManual().add(SIMILAR_OPT_STRATEGY);
        }
        if (needAggressiveOpt) {
            optimizer.getStrategiesForAuto().clear();
            optimizer.getStrategiesForAuto().addAll(Lists.newArrayList((Object[])new AbstractOptStrategy[]{INCLUDED_OPT_STRATEGY, LOW_FREQ_OPT_STRATEGY, MERGED_OPT_STRATEGY}));
        }
        IndexOptimizerFactory.printLog(needLog, indexOptimizationLevel, dataflow.getIndexPlan().isFastBitmapEnabled());
        return optimizer;
    }

    private static void printLog(boolean needLog, int indexOptimizationLevel, boolean isFastBitmapEnabled) {
        if (!needLog) {
            return;
        }
        if (indexOptimizationLevel == 3 && isFastBitmapEnabled) {
            log.info("Routing to index optimization level two for fastBitMap enabled.");
        } else if (indexOptimizationLevel == 3 || indexOptimizationLevel == 2 || indexOptimizationLevel == 1) {
            log.info("Routing to index optimization level " + indexOptimizationLevel + ".");
        } else if (indexOptimizationLevel == 0) {
            log.info("Routing to index optimization level zero, no optimization.");
        } else {
            log.error("Not supported index optimization level");
        }
    }
}

