/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedLayoutOptStrategy
extends AbstractOptStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergedLayoutOptStrategy.class);

    public MergedLayoutOptStrategy() {
        this.setType(GarbageLayoutType.MERGED);
    }

    @Override
    protected Set<Long> doCollect(List<LayoutEntity> inputLayouts, NDataflow dataflow, boolean needLog) {
        HashSet garbageLayouts = Sets.newHashSet();
        List<Set<LayoutEntity>> sameDimAggLayouts = IndexPlanReduceUtil.collectSameDimAggLayouts(inputLayouts);
        garbageLayouts.addAll(sameDimAggLayouts.stream().flatMap(Collection::stream).map(LayoutEntity::getId).collect(Collectors.toSet()));
        if (needLog) {
            log.info("In dataflow({}), MergeLayoutOptStrategy found garbage laoyouts: {}.", (Object)dataflow.getId(), (Object)garbageLayouts);
        }
        return garbageLayouts;
    }

    @Override
    protected void skipOptimizeIndex(List<LayoutEntity> inputLayouts) {
        inputLayouts.removeIf(layout -> layout.isBase() || IndexEntity.isTableIndex(layout.getId()));
    }
}

