/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm.genetic;

import java.util.BitSet;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.DummyLocalizable;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.kylin.metadata.cube.planner.algorithm.genetic.BitsChromosome;

public class BitsOnePointCrossover
implements CrossoverPolicy {
    public ChromosomePair crossover(Chromosome first, Chromosome second) throws DimensionMismatchException, MathIllegalArgumentException {
        if (!(first instanceof BitsChromosome) || !(second instanceof BitsChromosome)) {
            throw new MathIllegalArgumentException((Localizable)new DummyLocalizable("bits one-point crossover only works on BitsChromosome"), new Object[0]);
        }
        return this.crossover((BitsChromosome)first, (BitsChromosome)second);
    }

    private ChromosomePair crossover(BitsChromosome first, BitsChromosome second) throws DimensionMismatchException {
        int length = first.getLength();
        if (length != second.getLength()) {
            throw new DimensionMismatchException(second.getLength(), length);
        }
        BitSet parent1Key = first.getRepresentation();
        BitSet parent2Key = second.getRepresentation();
        BitSet child1Key = new BitSet(length);
        BitSet child2Key = new BitSet(length);
        int crossoverIndex = 1 + GeneticAlgorithm.getRandomGenerator().nextInt(length - 2);
        BitSet a = (BitSet)parent1Key.clone();
        a.clear(crossoverIndex, length);
        BitSet b = (BitSet)parent2Key.clone();
        b.clear(0, crossoverIndex);
        BitSet c = (BitSet)parent1Key.clone();
        c.clear(crossoverIndex, length);
        BitSet d = (BitSet)parent2Key.clone();
        d.clear(0, crossoverIndex);
        child1Key.or(a);
        child1Key.or(d);
        child2Key.or(c);
        child2Key.or(b);
        return new ChromosomePair((Chromosome)first.newBitsChromosome(child1Key), (Chromosome)second.newBitsChromosome(child2Key));
    }
}

