/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.query.util.SqlFunctionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ComputedColumnDesc
extends RootPersistentEntity
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ComputedColumnDesc.class);
    private static final String CC_PREFIX = "_CC_";
    @JsonProperty
    private String tableIdentity;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tableAlias;
    @JsonProperty
    private String columnName;
    @JsonProperty
    private String expression;
    @JsonProperty
    private String innerExpression;
    @JsonProperty
    private String datatype;
    @JsonProperty
    private String comment;
    @JsonProperty
    private String expressionMD5;

    public void init(NDataModel model, String rootFactTableName) {
        Map<String, TableRef> aliasMap = model.getAliasMap();
        Set<String> aliasSet = aliasMap.keySet();
        Preconditions.checkNotNull((Object)this.tableIdentity, (Object)"tableIdentity is null");
        Preconditions.checkNotNull((Object)this.columnName, (Object)"columnName is null");
        if (!model.isSeekingCCAdvice()) {
            Preconditions.checkNotNull((Object)this.expression, (Object)"expression is null");
        }
        Preconditions.checkNotNull((Object)this.datatype, (Object)"datatype is null");
        if (this.tableAlias == null) {
            this.tableAlias = this.tableIdentity.substring(this.tableIdentity.indexOf(46) + 1);
        }
        Preconditions.checkState((boolean)this.tableIdentity.equals(this.tableIdentity.trim()), (Object)"tableIdentity of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.tableAlias.equals(this.tableAlias.trim()), (Object)"tableAlias of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.columnName.equals(this.columnName.trim()), (Object)"columnName of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.datatype.equals(this.datatype.trim()), (Object)"datatype of ComputedColumnDesc has heading/tailing whitespace");
        this.tableIdentity = this.tableIdentity.toUpperCase(Locale.ROOT);
        this.tableAlias = this.tableAlias.toUpperCase(Locale.ROOT);
        this.columnName = this.columnName.toUpperCase(Locale.ROOT);
        TableRef hostTblRef = model.findTable(this.tableAlias);
        if (!model.isFactTable(hostTblRef)) {
            throw new IllegalArgumentException("Computed column has to be defined on fact table or limited lookup table");
        }
        if ("true".equals(System.getProperty("needCheckCC"))) {
            try {
                ComputedColumnDesc.simpleParserCheck(this.expression, aliasSet);
                this.expression = CalciteParser.normalize(this.expression);
            }
            catch (Exception e) {
                String legacyHandled = this.handleLegacyCC(this.expression, rootFactTableName, aliasSet);
                if (legacyHandled != null) {
                    this.expression = CalciteParser.normalize(legacyHandled);
                }
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_COMPUTED_COLUMN_EXPRESSION, Throwables.getRootCause((Throwable)e));
            }
        }
    }

    public MetadataType resourceType() {
        return MetadataType.COMPUTE_COLUMN;
    }

    @VisibleForTesting
    public static String getComputedColumnInternalNamePrefix() {
        return CC_PREFIX;
    }

    public static String getOriginCcName(String ccNameWithPrefix) {
        return ccNameWithPrefix.startsWith(CC_PREFIX) ? ccNameWithPrefix.replaceFirst(CC_PREFIX, "") : ccNameWithPrefix;
    }

    public String getIdentityCcName() {
        return this.tableIdentity + "." + this.columnName;
    }

    private String handleLegacyCC(String expr, String rootFact, Set<String> aliasSet) {
        try {
            String ret = CalciteParser.insertAliasInExpr(expr, rootFact);
            ComputedColumnDesc.simpleParserCheck(ret, aliasSet);
            return ret;
        }
        catch (Exception e) {
            logger.error("failed to handle legacy CC '{}' for {}", (Object)expr, (Object)e.getMessage());
            return null;
        }
    }

    public static void simpleParserCheck(String expr, final Set<String> aliasSet) {
        SqlNode sqlNode = CalciteParser.getReadonlyExpNode(expr);
        SqlBasicVisitor<Object> sqlVisitor = new SqlBasicVisitor<Object>(){

            public Object visit(SqlIdentifier id) {
                if (id.names.size() != 2 || !aliasSet.contains(id.names.get(0))) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getColumnUnrecognized(), id));
                }
                return null;
            }

            public Object visit(SqlCall unresolvedCall) {
                SqlCall call = SqlFunctionUtil.resolveCallIfNeed((SqlNode)unresolvedCall);
                if (call instanceof SqlBasicCall) {
                    if (call.getOperator() instanceof SqlAsOperator) {
                        throw new IllegalArgumentException("Computed column expression should not contain keyword AS");
                    }
                    if (call.getOperator() instanceof SqlAggFunction || MeasureTypeFactory.getUDAFs().containsKey(call.getOperator().getName())) {
                        throw new IllegalArgumentException("Computed column expression should not contain any aggregate functions: " + call.getOperator().getName());
                    }
                }
                return call.getOperator().acceptCall((SqlVisitor)this, call);
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
    }

    public String getFullName() {
        return this.tableAlias + "." + this.columnName;
    }

    public String getIdentName() {
        return this.tableIdentity + "." + this.columnName;
    }

    public void setInnerExpression(String innerExpression) {
        this.innerExpression = innerExpression;
    }

    public String getInnerExpression() {
        if (StringUtils.isEmpty((CharSequence)this.innerExpression)) {
            return this.expression;
        }
        return this.innerExpression;
    }

    public String getUniqueContent() {
        return String.format(Locale.ROOT, "%s_%s", this.innerExpression, this.tableIdentity);
    }

    public boolean isAutoCC() {
        return this.getColumnName().startsWith("CC_AUTO_");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputedColumnDesc)) {
            return false;
        }
        ComputedColumnDesc other = (ComputedColumnDesc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableIdentity = this.getTableIdentity();
        String other$tableIdentity = other.getTableIdentity();
        if (this$tableIdentity == null ? other$tableIdentity != null : !this$tableIdentity.equals(other$tableIdentity)) {
            return false;
        }
        String this$tableAlias = this.getTableAlias();
        String other$tableAlias = other.getTableAlias();
        if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$datatype = this.getDatatype();
        String other$datatype = other.getDatatype();
        return !(this$datatype == null ? other$datatype != null : !this$datatype.equals(other$datatype));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComputedColumnDesc;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableIdentity = this.getTableIdentity();
        result = result * 59 + ($tableIdentity == null ? 43 : $tableIdentity.hashCode());
        String $tableAlias = this.getTableAlias();
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $datatype = this.getDatatype();
        result = result * 59 + ($datatype == null ? 43 : $datatype.hashCode());
        return result;
    }

    @Generated
    public ComputedColumnDesc() {
    }

    @Generated
    public String getTableIdentity() {
        return this.tableIdentity;
    }

    @Generated
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public String getDatatype() {
        return this.datatype;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getExpressionMD5() {
        return this.expressionMD5;
    }

    @Generated
    public void setTableIdentity(String tableIdentity) {
        this.tableIdentity = tableIdentity;
    }

    @Generated
    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    @Generated
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setExpressionMD5(String expressionMD5) {
        this.expressionMD5 = expressionMD5;
    }

    @Generated
    public String toString() {
        return "ComputedColumnDesc(tableIdentity=" + this.getTableIdentity() + ", tableAlias=" + this.getTableAlias() + ", columnName=" + this.getColumnName() + ", expression=" + this.getExpression() + ", innerExpression=" + this.getInnerExpression() + ", datatype=" + this.getDatatype() + ", comment=" + this.getComment() + ", expressionMD5=" + this.getExpressionMD5() + ")";
    }
}

