/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class FunctionDesc
implements Serializable {
    public static final String FUNC_SUM = "SUM";
    public static final String FUNC_MIN = "MIN";
    public static final String FUNC_MAX = "MAX";
    public static final String FUNC_COLLECT_SET = "COLLECT_SET";
    public static final String FUNC_COUNT = "COUNT";
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String FUNC_BITMAP_UUID = "BITMAP_UUID";
    public static final String FUNC_BITMAP_COUNT = "BITMAP_COUNT";
    public static final String FUNC_INTERSECT_COUNT = "INTERSECT_COUNT";
    public static final String FUNC_INTERSECT_VALUE = "INTERSECT_VALUE";
    public static final String FUNC_INTERSECT_BITMAP_UUID = "INTERSECT_BITMAP_UUID";
    public static final String FUNC_INTERSECT_COUNT_V2 = "INTERSECT_COUNT_V2";
    public static final String FUNC_INTERSECT_VALUE_V2 = "INTERSECT_VALUE_V2";
    public static final String FUNC_INTERSECT_BITMAP_UUID_V2 = "INTERSECT_BITMAP_UUID_V2";
    public static final String FUNC_BITMAP_BUILD = "BITMAP_BUILD";
    public static final String FUNC_INTERSECT_BITMAP_UUID_DISTINCT = "INTERSECT_BITMAP_UUID_DISTINCT";
    public static final String FUNC_INTERSECT_BITMAP_UUID_COUNT = "INTERSECT_BITMAP_UUID_COUNT";
    public static final String FUNC_INTERSECT_BITMAP_UUID_VALUE = "INTERSECT_BITMAP_UUID_VALUE";
    public static final String FUNC_INTERSECT_BITMAP_UUID_VALUE_ALL = "INTERSECT_BITMAP_UUID_VALUE_ALL";
    public static final String FUNC_UNION_BITMAP_UUID_DISTINCT = "UNION_BITMAP_UUID_DISTINCT";
    public static final String FUNC_UNION_BITMAP_UUID_COUNT = "UNION_BITMAP_UUID_COUNT";
    public static final String FUNC_UNION_BITMAP_UUID_VALUE = "UNION_BITMAP_UUID_VALUE";
    public static final String FUNC_UNION_BITMAP_UUID_VALUE_ALL = "UNION_BITMAP_UUID_VALUE_ALL";
    public static final String FUNC_CORR = "CORR";
    public static final String FUNC_COUNT_DISTINCT_HLLC10 = "hllc(10)";
    public static final String FUNC_COUNT_DISTINCT_BIT_MAP = "bitmap";
    public static final String FUNC_PERCENTILE = "PERCENTILE_APPROX";
    public static final String FUNC_GROUPING = "GROUPING";
    public static final String FUNC_TOP_N = "TOP_N";
    public static final String FUNC_SUM_LC = "SUM_LC";
    public static final ImmutableSet<String> DIMENSION_AS_MEASURES = ImmutableSet.builder().add((Object[])new String[]{"MAX", "MIN", "COUNT_DISTINCT"}).build();
    public static final ImmutableSet<String> NOT_SUPPORTED_FUNCTION = ImmutableSet.builder().build();
    public static final ImmutableSet<String> NOT_SUPPORTED_FUNCTION_TABLE_INDEX = ImmutableSet.builder().add((Object)"COLLECT_SET").build();
    private static final Map<String, String> EXPRESSION_DEFAULT_TYPE_MAP = Maps.newHashMap();
    public static final String PARAMETER_TYPE_CONSTANT = "constant";
    public static final String PARAMETER_TYPE_COLUMN = "column";
    public static final String PARAMETER_TYPE_MATH_EXPRESSION = "math_expression";
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="parameters")
    private List<ParameterDesc> parameters;
    @JsonProperty(value="returntype")
    private String returnType;
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> configuration = Maps.newLinkedHashMap();
    private DataType returnDataType;
    private MeasureType<?> measureType;
    private boolean isDimensionAsMetric = false;

    public static FunctionDesc newInstance(String expression, List<ParameterDesc> parameters, String returnType) {
        FunctionDesc r = new FunctionDesc();
        r.expression = expression == null ? null : expression.toUpperCase(Locale.ROOT);
        r.parameters = parameters;
        r.returnType = returnType;
        r.returnDataType = DataType.getType(returnType);
        return r;
    }

    public static FunctionDesc newCountOne() {
        return FunctionDesc.newInstance(FUNC_COUNT, Lists.newArrayList((Object[])new ParameterDesc[]{ParameterDesc.newInstance("1")}), "bigint");
    }

    public static String proposeReturnType(String expression, String colDataType) {
        return FunctionDesc.proposeReturnType(expression, colDataType, Maps.newHashMap(), false);
    }

    public static String proposeReturnType(String expression, String colDataType, Map<String, String> override) {
        return FunctionDesc.proposeReturnType(expression, colDataType, override, false);
    }

    public static String proposeReturnType(String expression, String colDataType, Map<String, String> override, boolean saveCheck) {
        if (saveCheck) {
            switch (expression) {
                case "SUM": 
                case "PERCENTILE_APPROX": {
                    if (colDataType == null || !DataType.getType(colDataType).isStringFamily()) break;
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MEASURE_DATA_TYPE, String.format(Locale.ROOT, "Invalid column type %s for measure %s", colDataType, expression));
                }
            }
        }
        if (FUNC_SUM_LC.equals(expression)) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)colDataType), (Object)"SUM_LC Measure's input type shouldn't be null or empty");
            FunctionDesc.checkSumLCDataType(colDataType);
        }
        String returnType = override.getOrDefault(expression, EXPRESSION_DEFAULT_TYPE_MAP.getOrDefault(expression, colDataType));
        if (FUNC_SUM.equals(expression) || FUNC_SUM_LC.equals(expression)) {
            if (colDataType != null) {
                DataType type = DataType.getType(returnType);
                if (type.isIntegerFamily()) {
                    returnType = "bigint";
                } else if (type.isDecimal()) {
                    returnType = String.format(Locale.ROOT, "decimal(%d,%d)", DataType.decimalBoundedPrecision(type.getPrecision() + 10), DataType.decimalBoundedScale(type.getScale()));
                }
            } else {
                returnType = "decimal(19,4)";
            }
        }
        return returnType;
    }

    private static void checkSumLCDataType(String dataTypeName) {
        DataType dataType = DataType.getType(dataTypeName);
        if (!dataType.isNumberFamily()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_SUM_LC_INVALID_DATA_TYPE, new Object[]{dataType, DataType.NUMBER_FAMILY});
        }
    }

    private static void checkSumLCTimeColDataType(String dataTypeName) {
        DataType dataType = DataType.getType(dataTypeName);
        if (dataType.isTinyInt() || dataType.isFloat() || dataType.isDouble() || dataType.isDecimal() || dataType.isBoolean()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_SUM_LC_INVALID_TIMESTAMP_TYPE, new Object[]{dataType});
        }
    }

    public void init(NDataModel model) {
        this.expression = this.expression.toUpperCase(Locale.ROOT);
        if (this.expression.equals("PERCENTILE")) {
            this.expression = FUNC_PERCENTILE;
        }
        List<ParameterDesc> paramList = this.getParameters();
        for (int i = 0; i < paramList.size(); ++i) {
            ParameterDesc p = paramList.get(i);
            if (!p.isColumnType()) continue;
            TblColRef colRef = model.findColumn(p.getValue());
            p.setValue(colRef.getIdentity());
            p.setColRef(colRef);
            if (this.expression.equals(FUNC_SUM_LC)) {
                if (i == 0) {
                    this.returnType = FunctionDesc.proposeReturnType(this.expression, colRef.getDatatype(), Maps.newHashMap(), model.isSaveCheck());
                    this.returnDataType = DataType.getType(this.returnType);
                    continue;
                }
                FunctionDesc.checkSumLCTimeColDataType(colRef.getDatatype());
                continue;
            }
            this.returnDataType = DataType.getType(FunctionDesc.proposeReturnType(this.expression, colRef.getDatatype(), Maps.newHashMap(), model.isSaveCheck()));
        }
        if (!this.expression.equals(FUNC_SUM_LC)) {
            if (this.returnDataType == null) {
                this.returnDataType = DataType.getType("bigint");
            }
            if (!StringUtils.isEmpty((CharSequence)this.returnType)) {
                this.returnDataType = DataType.getType(this.returnType);
            }
            this.returnType = this.returnDataType.toString();
        }
    }

    private void reInitMeasureType() {
        if (this.isDimensionAsMetric && this.isCountDistinct()) {
            this.measureType = MeasureTypeFactory.createNoRewriteFieldsMeasureType(this.getExpression(), this.getReturnDataType());
            this.returnDataType = DataType.getType("dim_dc");
        } else {
            this.measureType = MeasureTypeFactory.create(this.getExpression(), this.getReturnDataType());
        }
    }

    public MeasureType getMeasureType() {
        if (this.isDimensionAsMetric && !this.isCountDistinct()) {
            return null;
        }
        if (this.measureType == null) {
            this.reInitMeasureType();
        }
        return this.measureType;
    }

    public boolean needRewrite() {
        if (this.getMeasureType() == null) {
            return false;
        }
        return this.getMeasureType().needRewrite();
    }

    public boolean needRewriteField() {
        if (!this.needRewrite()) {
            return false;
        }
        return this.getMeasureType().needRewriteField();
    }

    public String getRewriteFieldName() {
        if (this.isCountConstant()) {
            return "_KY_COUNT__";
        }
        if (this.isCountDistinct()) {
            return "_KY_" + this.getFullExpressionInAlphabetOrder().replaceAll("[(),. ]", "_");
        }
        return "_KY_" + this.getFullExpression().replaceAll("[(),. ]", "_");
    }

    public DataType getRewriteFieldType() {
        if (this.getMeasureType() instanceof BasicMeasureType) {
            if (this.isMax() || this.isMin()) {
                return this.getColRefs().get(0).getType();
            }
            if (this.isSum()) {
                if (this.parameters.get(0).isConstant()) {
                    return this.returnDataType;
                }
                return this.getColRefs().get(0).getType();
            }
            if (this.isCount()) {
                return DataType.getType("bigint");
            }
            throw new IllegalArgumentException("unknown measure type " + this.getMeasureType());
        }
        return DataType.ANY;
    }

    public List<TblColRef> getColRefs() {
        if (CollectionUtils.isEmpty(this.parameters)) {
            return Lists.newArrayList();
        }
        return this.parameters.stream().filter(ParameterDesc::isColumnType).map(ParameterDesc::getColRef).collect(Collectors.toList());
    }

    public Collection<TblColRef> getSourceColRefs() {
        HashSet<TblColRef> neededCols = new HashSet<TblColRef>();
        for (TblColRef colRef : this.getColRefs()) {
            neededCols.addAll(colRef.getSourceColumns());
        }
        return neededCols;
    }

    public static boolean nonSupportFunTableIndex(List<FunctionDesc> aggregations) {
        for (FunctionDesc functionDesc : aggregations) {
            if (!NOT_SUPPORTED_FUNCTION_TABLE_INDEX.contains((Object)functionDesc.expression)) continue;
            return true;
        }
        return false;
    }

    public ColumnDesc newFakeRewriteColumn(String rewriteFiledName, TableDesc sourceTable) {
        ColumnDesc fakeCol = new ColumnDesc();
        fakeCol.setName(rewriteFiledName);
        fakeCol.setDatatype(this.getRewriteFieldType().toString());
        if (this.isCountConstant()) {
            fakeCol.setNullable(false);
        }
        fakeCol.init(sourceTable);
        return fakeCol;
    }

    public ColumnDesc newFakeRewriteColumn(TableDesc sourceTable) {
        return this.newFakeRewriteColumn(this.getRewriteFieldName(), sourceTable);
    }

    public boolean isMin() {
        return FUNC_MIN.equalsIgnoreCase(this.expression);
    }

    public boolean isMax() {
        return FUNC_MAX.equalsIgnoreCase(this.expression);
    }

    public boolean isSum() {
        return FUNC_SUM.equalsIgnoreCase(this.expression);
    }

    public boolean isCount() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression);
    }

    public boolean isCountOnColumn() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression) && CollectionUtils.isNotEmpty(this.parameters) && this.parameters.get(0).isColumnType();
    }

    public boolean isAggregateOnConstant() {
        return !this.isCount() && CollectionUtils.isNotEmpty(this.parameters) && this.parameters.get(0).isConstantParameterDesc();
    }

    public boolean isCountConstant() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression) && (CollectionUtils.isEmpty(this.parameters) || this.parameters.get(0).isConstant() || this.parameters.get(0).isConstantParameterDesc());
    }

    public boolean isCountDistinct() {
        return FUNC_COUNT_DISTINCT.equalsIgnoreCase(this.expression);
    }

    public boolean isGrouping() {
        return FUNC_GROUPING.equalsIgnoreCase(this.expression);
    }

    public String getFullExpression() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        for (ParameterDesc desc : this.parameters) {
            sb.append(desc.getValue());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    public String getFullExpressionInAlphabetOrder() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        List flatParams = this.parameters.stream().map(ParameterDesc::getValue).collect(Collectors.toList());
        Collections.sort(flatParams);
        sb.append(Joiner.on((String)",").join(flatParams));
        sb.append(")");
        return sb.toString();
    }

    public boolean isDimensionAsMetric() {
        return this.isDimensionAsMetric;
    }

    public void setDimensionAsMetric(boolean isDimensionAsMetric) {
        this.isDimensionAsMetric = isDimensionAsMetric;
        if (this.measureType != null) {
            this.reInitMeasureType();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getParameterCount() {
        return CollectionUtils.isEmpty(this.parameters) ? 0 : this.parameters.size();
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public DataType getReturnDataType() {
        return this.returnDataType;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public boolean isDatatypeSuitable(DataType dataType) {
        switch (this.expression) {
            case "SUM": 
            case "TOP_N": {
                List<String> suitableTypes = Arrays.asList("tinyint", "smallint", "integer", "bigint", "float", "double", "decimal");
                return suitableTypes.contains(dataType.getName());
            }
            case "PERCENTILE_APPROX": {
                List<String> suitableTypes = Arrays.asList("tinyint", "smallint", "integer", "bigint");
                return suitableTypes.contains(dataType.getName());
            }
        }
        return true;
    }

    public boolean canAnsweredByDimensionAsMeasure() {
        return DIMENSION_AS_MEASURES.contains((Object)this.expression) && CollectionUtils.isNotEmpty(this.parameters) && "UNKNOWN_ALIAS".equals(this.parameters.get(0).getColRef().getTableAlias());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        boolean isConstant = this.isCountConstant() || CollectionUtils.isEmpty(this.parameters);
        result = 31 * result + (isConstant ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDesc other = (FunctionDesc)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.isCountDistinct()) {
            if (CollectionUtils.isEmpty(this.parameters)) {
                return !CollectionUtils.isNotEmpty(other.getParameters());
            }
            return this.parametersEqualInArbitraryOrder(this.parameters, other.getParameters());
        }
        if (this.isCountConstant() && ((FunctionDesc)obj).isCountConstant()) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.parameters)) {
            return !CollectionUtils.isNotEmpty(other.getParameters());
        }
        return Objects.equals(this.parameters, other.getParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.parameters.forEach(parameter -> {
            sb.append(parameter.toString());
            sb.append(",");
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return "FunctionDesc [expression=" + this.expression + ", parameter=" + sb.toString() + ", returnType=" + this.returnType + "]";
    }

    public String toStringWithoutAlias() {
        StringBuilder sb = new StringBuilder();
        this.parameters.forEach(parameter -> {
            sb.append(parameter.toStringWithoutAlias());
            sb.append(",");
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return "FunctionDesc [expression=" + this.expression + ", parameter=" + sb + ", returnType=" + this.returnType + "]";
    }

    private boolean parametersEqualInArbitraryOrder(List<ParameterDesc> parameters, List<ParameterDesc> otherParameters) {
        return parameters.containsAll(otherParameters) && otherParameters.containsAll(parameters);
    }

    @Generated
    public List<ParameterDesc> getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(List<ParameterDesc> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    static {
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_TOP_N, "topn(100, 4)");
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_COUNT_DISTINCT, FUNC_COUNT_DISTINCT_BIT_MAP);
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_PERCENTILE, "percentile(100)");
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_COUNT, "bigint");
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_COLLECT_SET, "ARRAY");
        EXPRESSION_DEFAULT_TYPE_MAP.put(FUNC_CORR, "double");
    }
}

