/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.metadata.Manager;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.RecItemSet;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportModelContext
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportModelContext.class);
    public static final String MODEL_REC_PATH = MetadataType.TMP_REC + "/%s.%s";
    private final String targetProject;
    private final KylinConfig importKylinConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
    private final ResourceStore importResourceStore = new InMemResourceStore(this.importKylinConfig);
    private final KylinConfig targetKylinConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
    private final ResourceStore targetResourceStore;
    private final NDataModelManager originalDataModelManager;
    private final NDataflowManager originalDataflowManager;
    private final NDataModelManager targetDataModelManager;
    private final NTableMetadataManager targetTableMetadataManager;
    private final NIndexPlanManager targetIndexPlanManger;
    private final NDataModelManager importDataModelManager;
    private final NTableMetadataManager importTableMetadataManager;
    private final NIndexPlanManager importIndexPlanManager;
    private final List<TableDesc> targetMissTableList;
    private final List<TableDesc> loadTableList;
    private final Map<String, String> newModels;
    private final List<String> unImportModels;

    public ImportModelContext(String targetProject, String srcProject, Map<String, RawResource> rawResourceMap) {
        this(targetProject, srcProject, rawResourceMap, Maps.newHashMap(), Lists.newArrayList());
    }

    public ImportModelContext(String targetProject, String srcProject, Map<String, RawResource> rawResourceMap, Map<String, String> newModels, List<String> unImportModels) {
        this.targetProject = targetProject;
        this.newModels = newModels;
        this.unImportModels = unImportModels;
        ResourceStore.setRS((KylinConfig)this.importKylinConfig, (ResourceStore)this.importResourceStore);
        this.targetResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.targetKylinConfig);
        rawResourceMap.forEach((resPath, raw) -> {
            try {
                ByteSource wrap;
                if (!targetProject.equals(raw.getProject())) {
                    raw.setProject(targetProject);
                    MetadataType metaType = raw.getMetaType();
                    if (MetadataType.WITH_PROJECT_PREFIX_METADATA.contains(metaType)) {
                        raw.setMetaKey(raw.getMetaKey().replaceFirst(srcProject + "\\.", targetProject + "."));
                        resPath = raw.generateKeyWithType();
                    }
                    JsonNode je = (JsonNode)JsonUtil.readValue((byte[])raw.getContent(), JsonNode.class);
                    ObjectNode contentJsonMap = JsonUtil.valueToTree((Object)je);
                    contentJsonMap.put("project", targetProject);
                    wrap = ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)contentJsonMap));
                } else {
                    wrap = raw.getByteSource();
                }
                this.importResourceStore.putResourceWithoutCheck(resPath, wrap, raw.getTs().longValue(), 0L);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write resource, this context is broken", e);
            }
        });
        String targetProjectPath = MetadataType.mergeKeyWithType((String)targetProject, (MetadataType)MetadataType.PROJECT);
        this.importResourceStore.checkAndPutResource(targetProjectPath, this.targetResourceStore.getResource(targetProjectPath).getByteSource(), -1L);
        this.originalDataModelManager = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), targetProject);
        this.originalDataflowManager = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), targetProject);
        this.targetDataModelManager = NDataModelManager.getInstance(this.targetKylinConfig, targetProject);
        this.targetTableMetadataManager = NTableMetadataManager.getInstance(this.targetKylinConfig, targetProject);
        this.targetIndexPlanManger = NIndexPlanManager.getInstance(this.targetKylinConfig, targetProject);
        this.importDataModelManager = NDataModelManager.getInstance(this.importKylinConfig, targetProject);
        this.importTableMetadataManager = NTableMetadataManager.getInstance(this.importKylinConfig, targetProject);
        this.importIndexPlanManager = NIndexPlanManager.getInstance(this.importKylinConfig, targetProject);
        this.targetKylinConfig.setProperty("kylin.metadata.validate-computed-column", "false");
        Pair<List<TableDesc>, List<TableDesc>> pairTable = this.getPairTable();
        this.targetMissTableList = (List)pairTable.getFirst();
        this.loadTableList = (List)pairTable.getSecond();
        this.loadTable();
        this.loadModel();
    }

    private Pair<List<TableDesc>, List<TableDesc>> getPairTable() {
        ArrayList missTables = Lists.newArrayList();
        ArrayList loadTables = Lists.newArrayList();
        List<TableDesc> tables = this.importTableMetadataManager.listAllTables();
        for (TableDesc tableDesc : tables) {
            TableDesc newTable = this.targetTableMetadataManager.copy(tableDesc);
            TableDesc originalTable = this.targetTableMetadataManager.getTableDesc(newTable.getIdentity());
            newTable.setLastModified(System.currentTimeMillis());
            if (Objects.isNull(originalTable)) {
                newTable.setMvcc(-1L);
                missTables.add(newTable);
            } else {
                newTable.setMvcc(originalTable.getMvcc());
            }
            loadTables.add(newTable);
        }
        return Pair.newPair((Object)missTables, (Object)loadTables);
    }

    private void loadTable() {
        for (TableDesc tableDesc : this.loadTableList) {
            this.targetTableMetadataManager.saveSourceTable(tableDesc);
        }
    }

    private void createNewModel(NDataModel newDataModel, NDataModel importModel) throws IOException {
        newDataModel.setProject(this.targetProject);
        newDataModel.setAlias(this.newModels.getOrDefault(importModel.getAlias(), newDataModel.getAlias()));
        newDataModel.setUuid(RandomUtil.randomUUIDStr());
        newDataModel.setMvcc(-1L);
        newDataModel.setLastModified(System.currentTimeMillis());
        Manager ccManager = (Manager)this.targetKylinConfig.getManager(this.targetProject, ComputedColumnManager.class);
        ImportModelContext.updateCcMvccIfNeed(newDataModel, ccManager);
        this.targetDataModelManager.createDataModelDesc(newDataModel, "");
        IndexPlan indexPlan = this.importIndexPlanManager.getIndexPlanByModelAlias(importModel.getAlias()).copy();
        indexPlan.setUuid(newDataModel.getUuid());
        indexPlan = this.targetIndexPlanManger.copy(indexPlan);
        indexPlan.setProject(this.targetProject);
        indexPlan.setMvcc(-1L);
        indexPlan.setLastModified(System.currentTimeMillis());
        this.targetIndexPlanManger.createIndexPlan(indexPlan);
        this.reorderRecommendations(importModel.getUuid(), newDataModel.getUuid(), Collections.emptyMap());
    }

    private static Map<Integer, Integer> prepareIdChangedMap(NDataModel originalDataModel, NDataModel newDataModel) {
        boolean exists;
        HashMap<Integer, Integer> idChangedMap = new HashMap<Integer, Integer>();
        int columnMaxId = originalDataModel.getAllNamedColumns().stream().map(NDataModel.NamedColumn::getId).mapToInt(Integer::intValue).max().orElse(1);
        int measureMaxId = originalDataModel.getAllMeasures().stream().map(NDataModel.Measure::getId).mapToInt(Integer::intValue).max().orElse(100000);
        HashSet existIds = Sets.newHashSet();
        for (NDataModel.NamedColumn namedColumn : newDataModel.getAllNamedColumns()) {
            int id;
            exists = originalDataModel.getAllNamedColumns().stream().anyMatch(original -> Objects.equals(original.getId(), namedColumn.getId()) && Objects.equals(original.getAliasDotColumn(), namedColumn.getAliasDotColumn()) && Objects.equals((Object)original.getStatus(), (Object)namedColumn.getStatus()));
            if (!exists && !Objects.equals(id = originalDataModel.getAllNamedColumns().stream().filter(original -> original.getAliasDotColumn().equals(namedColumn.getAliasDotColumn()) && original.isExist() == namedColumn.isExist() && !idChangedMap.containsValue(original.getId()) && !existIds.contains(original.getId())).mapToInt(NDataModel.NamedColumn::getId).findFirst().orElse(++columnMaxId), namedColumn.getId())) {
                idChangedMap.put(namedColumn.getId(), id);
                namedColumn.setId(id);
            }
            existIds.add(namedColumn.getId());
        }
        for (NDataModel.Measure measure : newDataModel.getAllMeasures()) {
            Integer id;
            exists = originalDataModel.getAllMeasures().stream().anyMatch(original -> Objects.equals(original.getId(), measure.getId()) && Objects.equals(original.getName(), measure.getName()) && Objects.equals(original.isTomb(), measure.isTomb()));
            if (!exists && !Objects.equals(id = originalDataModel.getAllMeasures().stream().filter(original -> original.getName().equals(measure.getName()) && original.isTomb() == measure.isTomb() && !idChangedMap.containsValue(original.getId()) && !existIds.contains(original.getId())).map(NDataModel.Measure::getId).findFirst().orElse(++measureMaxId), measure.getId())) {
                idChangedMap.put(measure.getId(), id);
                measure.setId(id);
            }
            existIds.add(measure.getId());
        }
        return idChangedMap;
    }

    private void updateModel(NDataModel newDataModel, NDataModel originalDataModel, boolean hasModelOverrideProps) {
        newDataModel.setUuid(originalDataModel.getUuid());
        newDataModel.setProject(this.targetProject);
        newDataModel.setLastModified(System.currentTimeMillis());
        newDataModel.setMvcc(originalDataModel.getMvcc());
        if (!hasModelOverrideProps) {
            newDataModel.setSegmentConfig(originalDataModel.getSegmentConfig());
        }
        this.updateDataModelDescAndCC(newDataModel);
    }

    private void updateDataModelDescAndCC(NDataModel importModel) {
        String uuid = importModel.getUuid();
        NDataModel dataModelDesc = this.targetDataModelManager.getDataModelDesc(uuid);
        if (dataModelDesc == null) {
            throw new IllegalArgumentException("Model '" + uuid + "' does not exist.");
        }
        importModel.init(this.targetKylinConfig, this.targetProject, this.targetDataModelManager.getCCRelatedModels(importModel));
        Manager ccManager = (Manager)this.targetKylinConfig.getManager(this.targetProject, ComputedColumnManager.class);
        NDataModelManager.NDataModelUpdater updater = copy -> {
            importModel.copyPropertiesTo(copy);
            ImportModelContext.updateCcMvccIfNeed(copy, ccManager);
        };
        this.targetDataModelManager.updateDataModel(importModel.getUuid(), updater);
    }

    private static void updateCcMvccIfNeed(NDataModel copy, Manager<ComputedColumnDesc> ccManager) {
        if (copy.getComputedColumnUuids() != null) {
            ArrayList<ComputedColumnDesc> ccList = new ArrayList<ComputedColumnDesc>();
            copy.getComputedColumnDescs().forEach(cc -> {
                ComputedColumnDesc copiedCc = ccManager.copy((ComputedColumnDesc)cc);
                copiedCc.setMvcc(ccManager.get(cc.getUuid()).map(RootPersistentEntity::getMvcc).orElse(-1L));
                ccList.add(copiedCc);
            });
            copy.setComputedColumnDescs(ccList);
        }
    }

    private void updateIndexPlan(NDataModel originalDataModel, IndexPlan targetIndexPlan, boolean hasModelOverrideProps) {
        this.targetIndexPlanManger.updateIndexPlan(originalDataModel.getUuid(), copyForWrite -> {
            if (targetIndexPlan.getRuleBasedIndex() != null) {
                copyForWrite.setRuleBasedIndex(targetIndexPlan.getRuleBasedIndex());
            } else {
                copyForWrite.setRuleBasedIndex(new RuleBasedIndex());
            }
            if (targetIndexPlan.getIndexes() != null) {
                copyForWrite.setIndexes(targetIndexPlan.getIndexes());
            } else {
                copyForWrite.setIndexes(Lists.newArrayList());
            }
            copyForWrite.getToBeDeletedIndexes().clear();
            if (targetIndexPlan.getToBeDeletedIndexes() != null) {
                copyForWrite.getToBeDeletedIndexes().addAll(targetIndexPlan.getToBeDeletedIndexes());
            } else {
                copyForWrite.getToBeDeletedIndexes().clear();
            }
            if (hasModelOverrideProps) {
                copyForWrite.setOverrideProps(targetIndexPlan.getOverrideProps());
            }
            if (targetIndexPlan.getAggShardByColumns() != null) {
                copyForWrite.setAggShardByColumns(targetIndexPlan.getAggShardByColumns());
            }
        });
    }

    private void loadModel() {
        HashMap exceptionMap = new HashMap();
        this.importDataModelManager.listAllModels().stream().filter(dataModel -> !this.unImportModels.contains(dataModel.getAlias())).forEach(dataModel -> {
            try {
                NDataModel originalDataModel;
                NDataModel newDataModel = this.importDataModelManager.copyForWrite((NDataModel)((Object)dataModel));
                NDataflow df = this.originalDataflowManager.getDataflowByModelAlias(newDataModel.getAlias());
                if (df != null && df.checkBrokenWithRelatedInfo()) {
                    originalDataModel = this.originalDataModelManager.getDataModelDescWithoutInit(df.getUuid());
                    originalDataModel.setBroken(true);
                } else {
                    originalDataModel = this.originalDataModelManager.getDataModelDescByAlias(newDataModel.getAlias());
                }
                if (this.newModels.containsKey(dataModel.getAlias()) || originalDataModel == null) {
                    this.createNewModel(newDataModel, (NDataModel)((Object)dataModel));
                } else {
                    Map<Integer, Integer> idChangedMap = ImportModelContext.prepareIdChangedMap(originalDataModel, newDataModel);
                    IndexPlan targetIndexPlan = this.importIndexPlanManager.getIndexPlanByModelAlias(newDataModel.getAlias()).copy();
                    boolean hasModelOverrideProps = newDataModel.getSegmentConfig() != null && newDataModel.getSegmentConfig().getAutoMergeEnabled() != null && newDataModel.getSegmentConfig().getAutoMergeEnabled() != false || !targetIndexPlan.getOverrideProps().isEmpty();
                    this.updateModel(newDataModel, originalDataModel, hasModelOverrideProps);
                    this.reorderIndexPlan(targetIndexPlan, idChangedMap);
                    this.reorderRecommendations(dataModel.getUuid(), newDataModel.getUuid(), idChangedMap);
                    this.updateIndexPlan(originalDataModel, targetIndexPlan, hasModelOverrideProps);
                }
            }
            catch (Exception e) {
                log.warn("Import model {} exception", (Object)dataModel.getAlias(), (Object)e);
                exceptionMap.put(dataModel.getAlias(), e);
            }
        });
        if (!exceptionMap.isEmpty()) {
            String details = exceptionMap.entrySet().stream().map(entry -> this.handleException((String)entry.getKey(), (Exception)entry.getValue())).collect(Collectors.joining("\n"));
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_METADATA_FILE_ERROR, String.format(Locale.ROOT, "%s%n%s", MsgPicker.getMsg().getImportModelException(), details), exceptionMap.values());
        }
    }

    private void reorderIndexPlan(IndexPlan copy, Map<Integer, Integer> idChangedMap) {
        List<IndexEntity> list;
        List<IndexEntity> indexes;
        RuleBasedIndex ruleBasedIndex;
        if (idChangedMap.isEmpty()) {
            return;
        }
        if (copy.getAggShardByColumns() != null) {
            copy.setAggShardByColumns(copy.getAggShardByColumns().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        }
        if ((ruleBasedIndex = copy.getRuleBasedIndex()) != null) {
            ruleBasedIndex.setDimensions(ruleBasedIndex.getDimensions().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
            ruleBasedIndex.setMeasures(ruleBasedIndex.getMeasures().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
            for (NAggregationGroup nAggregationGroup : ruleBasedIndex.getAggregationGroups()) {
                nAggregationGroup.setIncludes((Integer[])Arrays.stream(nAggregationGroup.getIncludes()).map(id -> idChangedMap.getOrDefault(id, (Integer)id)).toArray(Integer[]::new));
                nAggregationGroup.setMeasures((Integer[])Arrays.stream(nAggregationGroup.getMeasures()).map(id -> idChangedMap.getOrDefault(id, (Integer)id)).toArray(Integer[]::new));
                SelectRule selectRule = nAggregationGroup.getSelectRule();
                selectRule.setHierarchyDims((Integer[][])Arrays.stream(selectRule.getHierarchyDims()).map(pair -> (Integer[])Arrays.stream(pair).map(id -> idChangedMap.getOrDefault(id, (Integer)id)).toArray(Integer[]::new)).toArray(x$0 -> new Integer[x$0][]));
                selectRule.setMandatoryDims((Integer[])Arrays.stream(selectRule.getMandatoryDims()).map(id -> idChangedMap.getOrDefault(id, (Integer)id)).toArray(Integer[]::new));
                selectRule.setJointDims((Integer[][])Arrays.stream(selectRule.getJointDims()).map(pair -> (Integer[])Arrays.stream(pair).map(id -> idChangedMap.getOrDefault(id, (Integer)id)).toArray(Integer[]::new)).toArray(x$0 -> new Integer[x$0][]));
            }
        }
        if ((indexes = copy.getIndexes()) != null) {
            for (IndexEntity index : indexes) {
                ImportModelContext.reorderIndex(index, idChangedMap);
            }
        }
        if ((list = copy.getToBeDeletedIndexes()) != null) {
            for (IndexEntity index : list) {
                ImportModelContext.reorderIndex(index, idChangedMap);
            }
        }
    }

    private static void reorderIndex(IndexEntity index, Map<Integer, Integer> idChangedMap) {
        index.setDimensions(index.getDimensions().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        index.setMeasures(index.getMeasures().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        for (LayoutEntity layout : index.getLayouts()) {
            ImportModelContext.reorderLayout(layout, idChangedMap);
        }
    }

    private static void reorderLayout(LayoutEntity layout, Map<Integer, Integer> idChangedMap) {
        layout.setColOrder(layout.getColOrder().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        layout.setShardByColumns(layout.getShardByColumns().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        layout.setPartitionByColumns(layout.getPartitionByColumns().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
        layout.setSortByColumns(layout.getSortByColumns().stream().map(id -> idChangedMap.getOrDefault(id, (Integer)id)).collect(Collectors.toList()));
    }

    private void reorderRecommendations(String modelId, String targetModelId, Map<Integer, Integer> idChangedMap) throws IOException {
        RawResource resource = this.importResourceStore.getResource(String.format(Locale.ROOT, MODEL_REC_PATH, this.targetProject, modelId));
        if (resource != null) {
            List<RawRecItem> rawRecItems = ImportModelContext.parseRawRecItems(this.importResourceStore, this.targetProject, modelId);
            ImportModelContext.reorderRecommendations(rawRecItems, idChangedMap);
            RecItemSet recItemSet = new RecItemSet(targetModelId, this.targetProject, rawRecItems);
            this.targetResourceStore.checkAndPutResource(recItemSet.getResourcePath(), ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)((Object)recItemSet))), -1L);
        }
    }

    public static List<RawRecItem> reorderRecommendations(List<RawRecItem> rawRecItems, Map<Integer, Integer> idChangedMap) {
        for (RawRecItem rawRecItem : rawRecItems) {
            rawRecItem.setDependIDs(IntStream.of(rawRecItem.getDependIDs()).map(id -> idChangedMap.getOrDefault(id, id)).toArray());
            RecItemV2 recEntity = rawRecItem.getRecEntity();
            switch (rawRecItem.getType()) {
                case MEASURE: {
                    NDataModel.Measure measure = ((MeasureRecItemV2)recEntity).getMeasure();
                    measure.setId(idChangedMap.getOrDefault(measure.getId(), measure.getId()));
                    break;
                }
                case DIMENSION: {
                    NDataModel.NamedColumn column = ((DimensionRecItemV2)recEntity).getColumn();
                    column.setId(idChangedMap.getOrDefault(column.getId(), column.getId()));
                    break;
                }
                case REMOVAL_LAYOUT: 
                case ADDITIONAL_LAYOUT: {
                    LayoutEntity layout = ((LayoutRecItemV2)recEntity).getLayout();
                    ImportModelContext.reorderLayout(layout, idChangedMap);
                    break;
                }
            }
        }
        return rawRecItems;
    }

    private String handleException(String modelAlias, Exception exception) {
        if (exception instanceof RuntimeException && exception.getMessage() != null && exception.getMessage().contains("call on Broken Entity")) {
            return String.format(Locale.ROOT, MsgPicker.getMsg().getImportBrokenModel(), modelAlias);
        }
        return exception.getMessage();
    }

    public static List<RawRecItem> parseRawRecItems(ResourceStore resourceStore, String project, String modelId) throws IOException {
        ArrayList<RawRecItem> rawRecItems = new ArrayList<RawRecItem>();
        RawResource resource = resourceStore.getResource(String.format(Locale.ROOT, MODEL_REC_PATH, project, modelId));
        if (resource != null) {
            try (InputStream inputStream = resource.getByteSource().openStream();){
                JsonNode recEntity = (JsonNode)JsonUtil.readValue((InputStream)inputStream, JsonNode.class);
                JsonNode rawRecItemsNode = recEntity.get("rec_items");
                if (rawRecItemsNode != null) {
                    for (JsonNode jsonNode : rawRecItemsNode) {
                        rawRecItems.add(ImportModelContext.parseRawRecItem(jsonNode));
                    }
                }
            }
        }
        return rawRecItems;
    }

    private static RawRecItem parseRawRecItem(JsonNode recItemNode) throws IOException {
        RawRecItem rawRecItem = (RawRecItem)JsonUtil.readValue((String)recItemNode.toString(), RawRecItem.class);
        rawRecItem.setRecEntity(RawRecItem.toRecItem(recItemNode.get("recEntity").toString(), (byte)rawRecItem.getType().id()));
        return rawRecItem;
    }

    @Override
    public void close() {
        if (this.targetResourceStore != null) {
            this.targetResourceStore.close();
        }
        this.importResourceStore.close();
    }

    @Generated
    public String getTargetProject() {
        return this.targetProject;
    }

    @Generated
    public KylinConfig getImportKylinConfig() {
        return this.importKylinConfig;
    }

    @Generated
    public KylinConfig getTargetKylinConfig() {
        return this.targetKylinConfig;
    }

    @Generated
    public List<TableDesc> getTargetMissTableList() {
        return this.targetMissTableList;
    }

    @Generated
    public List<TableDesc> getLoadTableList() {
        return this.loadTableList;
    }

    @Generated
    public Map<String, String> getNewModels() {
        return this.newModels;
    }
}

