/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util.scd2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.scd2.SCD2CondChecker;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinDesc;

public class Scd2Simplifier {
    public static final Scd2Simplifier INSTANCE = new Scd2Simplifier();

    public SimplifiedJoinDesc simplifyScd2Conditions(@Nullable JoinDesc joinDesc) {
        if (Objects.isNull(joinDesc)) {
            return null;
        }
        List<NonEquiJoinCondition.SimplifiedJoinCondition> equalJoinPairs = this.buildAndCheckEqualConditions(joinDesc);
        List<NonEquiJoinCondition.SimplifiedJoinCondition> nonEqualJoinPairs = this.buildAndCheckNeqConditions(joinDesc);
        SCD2CondChecker.INSTANCE.checkFkPkPairUnique(equalJoinPairs, nonEqualJoinPairs);
        SimplifiedJoinDesc convertedJoinDesc = new SimplifiedJoinDesc();
        convertedJoinDesc.setSimplifiedNonEquiJoinConditions(nonEqualJoinPairs);
        convertedJoinDesc.simplifyEqualJoinPairs(equalJoinPairs);
        return convertedJoinDesc;
    }

    private List<NonEquiJoinCondition.SimplifiedJoinCondition> buildAndCheckNeqConditions(JoinDesc joinDesc) {
        NonEquiJoinCondition nonEquiJoinCondition = joinDesc.getNonEquiJoinCondition();
        if (Objects.isNull(nonEquiJoinCondition) || nonEquiJoinCondition.getOp() != SqlKind.AND) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_CAN_ONLY_CONNECT_BY_AND, new Object[0]);
        }
        ArrayList nonEqualJoinPairs = Lists.newArrayList();
        for (NonEquiJoinCondition nonEquivCond : nonEquiJoinCondition.getOperands()) {
            NonEquiJoinCondition.SimplifiedJoinCondition scd2Cond = this.simplifySCD2ChildCond(nonEquivCond, joinDesc);
            if (Objects.isNull(scd2Cond)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_CONTAINS_ILLEGAL_EXPRESSIONS, new Object[0]);
            }
            nonEqualJoinPairs.add(scd2Cond);
        }
        if (!SCD2CondChecker.INSTANCE.checkSCD2NonEquiJoinCondPair(nonEqualJoinPairs)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_CONDITION_MUST_APPEAR_IN_PAIRS, new Object[0]);
        }
        if (CollectionUtils.isEmpty((Collection)nonEqualJoinPairs)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_REQUIRES_AT_LEAST_ONE_NON_EQUAL_CONDITION, new Object[0]);
        }
        return nonEqualJoinPairs;
    }

    List<NonEquiJoinCondition.SimplifiedJoinCondition> buildAndCheckEqualConditions(JoinDesc joinDesc) {
        String[] fks = joinDesc.getForeignKey();
        String[] pks = joinDesc.getPrimaryKey();
        ArrayList<NonEquiJoinCondition.SimplifiedJoinCondition> simplifiedFksPks = new ArrayList<NonEquiJoinCondition.SimplifiedJoinCondition>();
        for (int i = 0; i < fks.length; ++i) {
            simplifiedFksPks.add(new NonEquiJoinCondition.SimplifiedJoinCondition(fks[i], pks[i], SqlKind.EQUALS));
        }
        if (CollectionUtils.isEmpty(simplifiedFksPks)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_REQUIRES_AT_LEAST_ONE_EQUAL_CONDITION, new Object[0]);
        }
        return simplifiedFksPks;
    }

    public TblColRef[] extractNeqFks(@Nonnull JoinDesc joinDesc) {
        Preconditions.checkNotNull((Object)joinDesc, (Object)"joinDesc is null");
        List<TblColRef> fkList = this.simplifyScd2Conditions(joinDesc).getSimplifiedNonEquiJoinConditions().stream().map(NonEquiJoinCondition.SimplifiedJoinCondition::getFk).distinct().collect(Collectors.toList());
        TblColRef[] fks = new TblColRef[fkList.size()];
        fkList.toArray(fks);
        return fks;
    }

    boolean isValidScd2JoinDesc(@Nullable JoinDesc joinDesc) {
        try {
            return this.simplifyScd2Conditions(joinDesc) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public NonEquiJoinCondition.SimplifiedJoinCondition simplifySCD2ChildCond(NonEquiJoinCondition neqCondition, JoinDesc joinDesc) {
        if (neqCondition.getType() != NonEquiJoinCondition.Type.EXPRESSION || neqCondition.getOperands().length != 2) {
            return null;
        }
        List scd2Pairs = Arrays.stream(neqCondition.getOperands()).map(nonEquiJoinConditionChild -> {
            if (nonEquiJoinConditionChild.getOp() == SqlKind.CAST && nonEquiJoinConditionChild.getOperands().length == 1) {
                return nonEquiJoinConditionChild.getOperands()[0];
            }
            return nonEquiJoinConditionChild;
        }).filter(nonEquiJoinConditionChild -> nonEquiJoinConditionChild.getOperands().length == 0 || nonEquiJoinConditionChild.getType() == NonEquiJoinCondition.Type.COLUMN).map(nonEquiJoinCondition1 -> new Pair((Object)nonEquiJoinCondition1.getValue(), (Object)nonEquiJoinCondition1.getColRef())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(scd2Pairs) || scd2Pairs.size() != 2) {
            return null;
        }
        Pair left = (Pair)scd2Pairs.get(0);
        Pair right = (Pair)scd2Pairs.get(1);
        String[] fks = joinDesc.getForeignKey();
        if (fks.length == 0) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_REQUIRES_AT_LEAST_ONE_NON_EQUAL_CONDITION, new Object[0]);
        }
        String fkTableAlias = StringUtils.split((String)fks[0], (char)'.')[0];
        String fkTableAliasOfNeqCondition = StringUtils.split((String)((String)left.getFirst()), (char)'.')[0];
        return fkTableAliasOfNeqCondition.equalsIgnoreCase(fkTableAlias) ? new NonEquiJoinCondition.SimplifiedJoinCondition((String)left.getKey(), (TblColRef)left.getValue(), (String)right.getKey(), (TblColRef)right.getValue(), neqCondition.getOp()) : new NonEquiJoinCondition.SimplifiedJoinCondition((String)right.getKey(), (TblColRef)right.getValue(), (String)left.getKey(), (TblColRef)left.getValue(), SCD2CondChecker.inverse(neqCondition.getOp()));
    }
}

