/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CCRecItemV2
extends RecItemV2
implements Serializable {
    @JsonProperty(value="cc")
    private ComputedColumnDesc cc;

    public int[] genDependIds(NDataModel dataModel) {
        Preconditions.checkArgument((this.cc != null ? 1 : 0) != 0, (Object)"CCRecItemV2 without computed column object.");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.cc.getExpression()), (Object)"Computed column expression cannot be null.");
        List<Pair<String, String>> exprIdentifiers = ComputedColumnUtil.ExprIdentifierFinder.getExprIdentifiers(this.cc.getExpression());
        int[] arr = new int[exprIdentifiers.size()];
        ImmutableBiMap<Integer, TblColRef> effectiveCols = dataModel.getEffectiveCols();
        HashMap map = Maps.newHashMap();
        effectiveCols.forEach((k, v) -> map.put(v.getIdentity(), k));
        for (int i = 0; i < exprIdentifiers.size(); ++i) {
            String columnName = (String)exprIdentifiers.get(i).getFirst() + "." + (String)exprIdentifiers.get(i).getSecond();
            Integer integer = (Integer)map.get(columnName);
            Preconditions.checkArgument((integer != null ? 1 : 0) != 0, (Object)"Computed column referred to a column not on model.");
            arr[i] = integer;
        }
        return arr;
    }

    @Override
    public int[] genDependIds(Map<String, RawRecItem> nonLayoutUniqueFlagRecMap, String content, NDataModel dataModel) {
        return this.genDependIds(dataModel);
    }

    @Generated
    public ComputedColumnDesc getCc() {
        return this.cc;
    }

    @Generated
    public void setCc(ComputedColumnDesc cc) {
        this.cc = cc;
    }
}

