/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.query.util.JdbcTableUtil;
import org.apache.kylin.metadata.state.ShareStateMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareStateUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShareStateUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String CREATE_SHARE_STATE_TABLE = "create.sharestate.store.table";
    private static final String CREATE_SHARE_STATE_INDEX1 = "create.sharestate.store.tableindex1";

    private ShareStateUtil() {
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String tableName) {
        return (SqlSessionFactory)Singletons.getInstance((String)"share-state-sql-session-factory", SqlSessionFactory.class, clz -> {
            JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
            Environment environment = new Environment("share state", (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(ShareStateMapper.class);
            ShareStateUtil.createShareStateIfNotExist((BasicDataSource)dataSource, tableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createShareStateIfNotExist(BasicDataSource dataSource, String tableName) throws SQLException, IOException {
        if (JdbcTableUtil.isTableExist(dataSource, tableName)) {
            return;
        }
        try (Connection connection = dataSource.getConnection();){
            Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_SHARE_STATE_TABLE), tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_SHARE_STATE_INDEX1), tableName, tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
    }
}

