/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.metadata.streaming.JdbcStreamingJobRecordStore;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobRecordManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobRecordManager.class);
    private final JdbcStreamingJobRecordStore jdbcRawRecStore = new JdbcStreamingJobRecordStore(KylinConfig.getInstanceFromEnv());

    public static StreamingJobRecordManager getInstance() {
        return (StreamingJobRecordManager)Singletons.getInstance(StreamingJobRecordManager.class);
    }

    private StreamingJobRecordManager() throws Exception {
    }

    public int insert(StreamingJobRecord record) {
        return this.jdbcRawRecStore.insert(record);
    }

    public void dropTable() throws SQLException {
        this.jdbcRawRecStore.dropTable();
    }

    public void deleteStreamingJobRecord() {
        this.jdbcRawRecStore.deleteStreamingJobRecord(-1L);
    }

    public void deleteStreamingJobRecord(long startTime) {
        this.jdbcRawRecStore.deleteStreamingJobRecord(startTime);
    }

    public void deleteIfRetainTimeReached() {
        long retainTime = new Date(System.currentTimeMillis() - KylinConfig.getInstanceFromEnv().getStreamingJobStatsSurvivalThreshold() * 24L * 60L * 60L * 1000L).getTime();
        this.jdbcRawRecStore.deleteStreamingJobRecord(retainTime);
    }

    public List<StreamingJobRecord> queryByJobId(String jobId) {
        return this.jdbcRawRecStore.queryByJobId(jobId);
    }

    public StreamingJobRecord getLatestOneByJobId(String jobId) {
        return this.jdbcRawRecStore.getLatestOneByJobId(jobId);
    }
}

