/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosLoginManager {
    public static final String KEYTAB_SUFFIX = ".keytab";
    public static final String TMP_KEYTAB_SUFFIX = "_tmp.keytab";
    private static final Logger logger = LoggerFactory.getLogger(KerberosLoginManager.class);

    public static KerberosLoginManager getInstance() {
        return (KerberosLoginManager)Singletons.getInstance(KerberosLoginManager.class);
    }

    public UserGroupInformation getProjectUGI(String projectName) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance(config);
        ProjectInstance project = projectManager.getProject(projectName);
        String principal = project.getPrincipal();
        try {
            if (project.isProjectKerberosEnabled()) {
                String keytabPath = this.wrapAndDownloadKeytab(projectName);
                return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytabPath);
            }
            return UserGroupInformation.getLoginUser();
        }
        catch (Exception e) {
            try {
                return UserGroupInformation.getLoginUser();
            }
            catch (Exception ex) {
                logger.error("Fetch login user error. project {}, principal {}", new Object[]{projectName, principal, ex});
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_KERBEROS_FILE, MsgPicker.getMsg().getKerberosInfoError(), (Throwable)e);
            }
        }
    }

    private String wrapAndDownloadKeytab(String projectName) throws Exception {
        String kylinConfHome;
        File kFile;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance(config);
        ProjectInstance project = projectManager.getProject(projectName);
        String principal = project.getPrincipal();
        String keytab = project.getKeytab();
        String keytabPath = null;
        if (project.isProjectKerberosEnabled() && !(kFile = new File(keytabPath = new Path(kylinConfHome = KapConfig.getKylinConfDirAtBestEffort(), principal + KEYTAB_SUFFIX).toString())).exists()) {
            FileUtils.decoderBase64File((String)keytab, (String)keytabPath);
        }
        return keytabPath;
    }

    public void checkKerberosInfo(String principal, String keytab) {
        try {
            UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_KERBEROS_FILE, MsgPicker.getMsg().getKerberosInfoError(), (Throwable)e);
        }
    }

    public void checkAndReplaceProjectKerberosInfo(String project, String principal) throws IOException {
        String kylinConfHome = KapConfig.getKylinConfDirAtBestEffort();
        String keytab = new Path(kylinConfHome, principal + TMP_KEYTAB_SUFFIX).toString();
        this.checkKerberosInfo(principal, keytab);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        if (!this.checkExistsTablesAccess(ugi, project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getProjectHivePermissionError());
        }
    }

    @VisibleForTesting
    boolean checkExistsTablesAccess(UserGroupInformation ugi, String project) {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance(kapConfig.getKylinConfig());
        return (Boolean)ugi.doAs(() -> {
            ProjectInstance projectInstance = projectManager.getProject(project);
            ImmutableSet<String> tables = projectInstance.getTables();
            AtomicBoolean accessible = new AtomicBoolean(true);
            NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
            Map<Integer, List<TableDesc>> tableMap = tables.stream().map(tableMetadataManager::getTableDesc).collect(Collectors.groupingBy(TableDesc::getSourceType));
            tableMap.forEach((sourceType, tableDescSet) -> {
                ISourceMetadataExplorer explorer = SourceFactory.getSource(sourceType, (KylinConfig)projectInstance.getConfig()).getSourceMetadataExplorer();
                accessible.set(accessible.get() && explorer.checkTablesAccess(tableDescSet.stream().map(ATable::getIdentity).collect(Collectors.toSet())));
            });
            return accessible.get();
        });
    }
}

