/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.source.ISource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceFactory.class);
    private static final Cache<String, ISource> sourceMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).removalListener(entry -> {
        ISource s = (ISource)entry.getValue();
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                log.error("Failed to close ISource: {}", (Object)s.getClass().getName(), (Object)e);
            }
        }
    }).build();

    private SourceFactory() {
    }

    public static ISource getSparkSource() {
        return SourceFactory.getSource(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISource getSource(ISourceAware aware) {
        String key = SourceFactory.createSourceCacheKey(aware);
        Class<SourceFactory> clazz = SourceFactory.class;
        synchronized (SourceFactory.class) {
            ISource source = (ISource)sourceMap.getIfPresent((Object)key);
            if (source != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return source;
            }
            source = SourceFactory.createSource(aware);
            sourceMap.put((Object)key, (Object)source);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return source;
        }
    }

    public static ISource getSource(int sourceType) {
        return SourceFactory.getSource(sourceType, KylinConfig.getInstanceFromEnv());
    }

    public static ISource getSource(final int sourceType, final KylinConfig kylinConfig) {
        return SourceFactory.getSource(new ISourceAware(){

            @Override
            public int getSourceType() {
                return sourceType;
            }

            @Override
            public KylinConfig getConfig() {
                return kylinConfig;
            }
        });
    }

    private static ISource createSource(ISourceAware aware) {
        Map sources = KylinConfig.getInstanceFromEnv().getSourceEngines();
        String clazz = (String)sources.get(aware.getSourceType());
        try {
            return (ISource)ClassUtil.forName((String)clazz, ISource.class).getDeclaredConstructor(KylinConfig.class).newInstance(aware.getConfig());
        }
        catch (Exception e) {
            log.error("Failed to create source: SourceType={}", (Object)aware.getSourceType());
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_JDBC_SOURCE_CONFIG, MsgPicker.getMsg().getJdbcConnectionInfoWrong(), (Throwable)e);
        }
    }

    private static String createSourceCacheKey(ISourceAware aware) {
        StringBuilder builder = new StringBuilder();
        builder.append(aware.getSourceType()).append('|');
        KylinConfig config = aware.getConfig();
        builder.append(config.getJdbcConnectionUrl()).append('|');
        builder.append(config.getJdbcUser()).append('|');
        builder.append(config.getJdbcPass()).append('|');
        builder.append(config.getJdbcDriver()).append('|');
        builder.append(config.getJdbcDialect()).append('|');
        builder.append(config.getJdbcAdaptorClass()).append('|');
        builder.append(config.getJdbcConvertToLowerCase()).append('|');
        if (8 == aware.getSourceType()) {
            builder.append(config.getSourceJDBCExtend()).append('|');
        }
        return builder.toString();
    }

    public static <T> T createEngineAdapter(ISourceAware table, Class<T> engineInterface) {
        return SourceFactory.getSource(table).adaptToBuildEngine(engineInterface);
    }
}

