/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import reactor.core.publisher.Flux;

@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
public class SimpleReactiveDiscoveryProperties {
    private Map<String, List<DefaultServiceInstance>> instances = new HashMap<String, List<DefaultServiceInstance>>();
    private DefaultServiceInstance local = new DefaultServiceInstance();
    private int order = 0;

    public Flux<ServiceInstance> getInstances(String service) {
        return Flux.fromIterable((Iterable)this.instances.getOrDefault(service, Collections.emptyList()));
    }

    Map<String, List<DefaultServiceInstance>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<DefaultServiceInstance>> instances) {
        this.instances = instances;
    }

    public DefaultServiceInstance getLocal() {
        return this.local;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @PostConstruct
    public void init() {
        for (String key : this.instances.keySet()) {
            for (DefaultServiceInstance instance : this.instances.get(key)) {
                instance.setServiceId(key);
            }
        }
    }
}

