/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.function.Predicate;
import org.springframework.util.AntPathMatcher;

public class PathSelectors {
    private PathSelectors() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<String> any() {
        return each -> true;
    }

    public static Predicate<String> none() {
        return each -> false;
    }

    public static Predicate<String> regex(final String pathRegex) {
        return new Predicate<String>(){

            @Override
            public boolean test(String input) {
                return input.matches(pathRegex);
            }
        };
    }

    public static Predicate<String> ant(final String antPattern) {
        return new Predicate<String>(){

            @Override
            public boolean test(String input) {
                AntPathMatcher matcher = new AntPathMatcher();
                return matcher.match(antPattern, input);
            }
        };
    }
}

