/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.MethodParameter;

public class ResolvedMethodParameter {
    private final int parameterIndex;
    private final List<Annotation> annotations;
    private final String defaultName;
    private final ResolvedType parameterType;

    public ResolvedMethodParameter(String paramName, MethodParameter methodParameter, ResolvedType parameterType) {
        this(methodParameter.getParameterIndex(), paramName, Stream.of(methodParameter.getParameterAnnotations()).collect(Collectors.toList()), parameterType);
    }

    public ResolvedMethodParameter(int parameterIndex, String defaultName, List<Annotation> annotations, ResolvedType parameterType) {
        this.parameterIndex = parameterIndex;
        this.defaultName = defaultName;
        this.parameterType = parameterType;
        this.annotations = annotations;
    }

    public ResolvedType getParameterType() {
        return this.parameterType;
    }

    public boolean hasParameterAnnotations() {
        return !this.annotations.isEmpty();
    }

    public boolean hasParameterAnnotation(Class<? extends Annotation> annotation) {
        return this.annotations.stream().anyMatch(annotation::isInstance);
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.annotations.stream().filter(annotation::isInstance).findFirst();
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Optional<String> defaultName() {
        return Optional.ofNullable(this.defaultName);
    }

    public ResolvedMethodParameter replaceResolvedParameterType(ResolvedType parameterType) {
        return new ResolvedMethodParameter(this.parameterIndex, this.defaultName, this.annotations, parameterType);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ResolvedMethodParameter annotate(Annotation annotation) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(this.annotations);
        annotations.add(annotation);
        return new ResolvedMethodParameter(this.parameterIndex, this.defaultName, annotations, this.parameterType);
    }
}

