/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ModelBuilder;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.TypeNameIndexingAdapter;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.UniqueTypeNameAdapter;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ComparisonCondition;
import springfox.documentation.spring.web.scanners.MergingContext;

@Component
@Deprecated
public class ApiModelReader {
    private static final Logger LOG = LoggerFactory.getLogger(ApiModelReader.class);
    private final ModelProvider modelProvider;
    private final TypeResolver typeResolver;
    private final DocumentationPluginsManager pluginsManager;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public ApiModelReader(@Qualifier(value="cachedModels") ModelProvider modelProvider, TypeResolver typeResolver, DocumentationPluginsManager pluginsManager, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor) {
        this.modelProvider = modelProvider;
        this.typeResolver = typeResolver;
        this.pluginsManager = pluginsManager;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
    }

    public Map<String, Set<Model>> read(RequestMappingContext context) {
        TreeMap<String, Set<Model>> mergedModelMap = new TreeMap<String, Set<Model>>();
        HashMap uniqueModels = new HashMap();
        HashMap parameterModelMap = new HashMap();
        TypeNameIndexingAdapter adapter = new TypeNameIndexingAdapter();
        Set<Class> ignorableTypes = context.getIgnorableParameterTypes();
        Set<ModelContext> modelContexts = this.pluginsManager.modelContexts(context);
        for (Map.Entry<String, Set<Model>> entry : context.getModelMap().entrySet()) {
            entry.getValue().stream().filter(model -> !uniqueModels.containsKey(model.getName())).forEach(model -> {
                adapter.registerType(model.getName(), model.getId());
                uniqueModels.put(model.getName(), model);
                parameterModelMap.put(model.getId(), (String)entry.getKey());
            });
        }
        for (ModelContext rootContext : modelContexts) {
            HashMap<String, Model> modelBranch = new HashMap<String, Model>();
            HashMap<String, ModelContext> contextMap = new HashMap<String, ModelContext>();
            this.markIgnorablesAsHasSeen(this.typeResolver, ignorableTypes, rootContext);
            Optional<Model> pModel = this.modelProvider.modelFor(rootContext);
            List<Object> branchRoots = new ArrayList();
            if (pModel.isPresent()) {
                LOG.debug("Generated parameter model id: {}, name: {}", (Object)pModel.get().getId(), (Object)pModel.get().getName());
                modelBranch.put(pModel.get().getId(), pModel.get());
                contextMap.put(pModel.get().getId(), rootContext);
                branchRoots.add(rootContext.getModelId());
            } else {
                branchRoots = this.findBranchRoots(rootContext);
                LOG.debug("Did not find any parameter models for {}", (Object)rootContext.getType());
            }
            Map<ResolvedType, Model> dependencies = this.modelProvider.dependencies(rootContext);
            for (ResolvedType type : dependencies.keySet()) {
                ModelContext childContext = ModelContext.fromParent(rootContext, type);
                modelBranch.put(dependencies.get(type).getId(), dependencies.get(type));
                contextMap.put(dependencies.get(type).getId(), childContext);
            }
            if (modelBranch.isEmpty()) continue;
            MergingContext mergingContext = ApiModelReader.createMergingContext(rootContext.getParameterId(), Collections.unmodifiableMap(uniqueModels), Collections.unmodifiableMap(parameterModelMap), Collections.unmodifiableMap(modelBranch), Collections.unmodifiableMap(contextMap));
            branchRoots.stream().filter(modelBranch::containsKey).forEach(rootId -> this.mergeModelBranch(adapter, mergingContext.toRootId((String)rootId)));
            Set<Model> updatedModels = this.updateModels(rootContext.getParameterId(), modelBranch.values(), contextMap, adapter);
            mergedModelMap.put(rootContext.getParameterId(), updatedModels);
            updatedModels.stream().filter(model -> !uniqueModels.containsKey(model.getName())).forEach(model -> {
                uniqueModels.put(model.getName(), model);
                parameterModelMap.put(model.getId(), rootContext.getParameterId());
            });
        }
        return Collections.unmodifiableMap(mergedModelMap);
    }

    private Set<ComparisonCondition> mergeModelBranch(UniqueTypeNameAdapter adapter, MergingContext mergingContext) {
        Set<String> nodes = this.collectNodes(adapter, mergingContext);
        HashSet<ComparisonCondition> dependencies = new HashSet<ComparisonCondition>();
        HashSet<String> currentDependencies = new HashSet<String>();
        boolean allowableToSearchTheSame = true;
        HashMap<String, Optional<String>> comparisonConditions = new HashMap<String, Optional<String>>();
        Set<String> parametersTo = new HashSet<String>();
        for (String modelId : nodes) {
            if (adapter.getTypeName(ApiModelReader.toTypeId(mergingContext.getParameterId(), modelId)).isPresent()) continue;
            if (!mergingContext.hasSeenBefore(modelId)) {
                MergingContext childMergingContext = ApiModelReader.createChildMergingContext(modelId, !currentDependencies.isEmpty(), parametersTo, dependencies, mergingContext);
                Set newDependencies = childMergingContext.getComparisonCondition(modelId).map(reenteredCondition -> new HashSet<ComparisonCondition>(Collections.singletonList(reenteredCondition))).orElseGet(() -> this.mergeModelBranch(adapter, childMergingContext));
                if (newDependencies.isEmpty()) {
                    allowableToSearchTheSame = false;
                    parametersTo = new HashSet();
                    continue;
                }
                newDependencies.stream().peek(d -> ApiModelReader.checkCondition(d, false)).filter(d -> !d.getConditions().isEmpty()).forEach(p -> {
                    dependencies.add((ComparisonCondition)p);
                    currentDependencies.addAll(p.getConditions());
                });
                if (!allowableToSearchTheSame) continue;
                ComparisonCondition currentCondition = this.currentCondition(modelId, newDependencies);
                if (currentCondition.getConditions().isEmpty()) {
                    comparisonConditions.put(modelId, currentCondition.getModelsTo().stream().map(mergingContext::getModelParameter).findFirst());
                    continue;
                }
                parametersTo = ApiModelReader.modelsToParameters(currentCondition.getModelsTo(), mergingContext);
            } else {
                currentDependencies.add(modelId);
                if (!allowableToSearchTheSame) continue;
                Optional<Set<String>> megedParameters = this.mergeParameters(modelId, parametersTo, mergingContext);
                parametersTo = megedParameters.orElseGet(HashSet::new);
                allowableToSearchTheSame = megedParameters.isPresent();
            }
            comparisonConditions.put(modelId, Optional.empty());
        }
        HashSet<String> sameModels = new HashSet<String>();
        if (allowableToSearchTheSame) {
            sameModels.addAll(this.findSameModels(comparisonConditions, parametersTo, adapter, mergingContext));
            currentDependencies.remove(mergingContext.getRootId());
        }
        return this.mergeConditions(sameModels, currentDependencies, dependencies, adapter, mergingContext);
    }

    private ComparisonCondition currentCondition(String modelId, Set<ComparisonCondition> newDependencies) {
        List conditions = newDependencies.stream().filter(comparisonCondition -> comparisonCondition.getModelFor().equals(modelId)).collect(Collectors.toCollection(ArrayList::new));
        if (conditions.size() > 1) {
            throw new IllegalStateException("Ambiguous conditions for one model.");
        }
        if (conditions.size() == 0) {
            throw new IllegalStateException("Condition is not present.");
        }
        return (ComparisonCondition)conditions.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> findSameModels(Map<String, Optional<String>> parametersMatching, Set<String> allowedParameters, UniqueTypeNameAdapter adapter, MergingContext mergingContext) {
        if (allowedParameters.isEmpty()) {
            allowedParameters = new HashSet<String>(Collections.singletonList(""));
        }
        Model rootModel = mergingContext.getRootModel();
        ModelBuilder rootModelBuilder = new ModelBuilder(rootModel);
        HashSet<String> sameModels = new HashSet<String>();
        String modelForTypeName = rootModel.getType().getErasedType().getName();
        Set<Model> modelsToCompare = mergingContext.getSimilarTypeModels(modelForTypeName);
        for (String parameter : allowedParameters) {
            ArrayList<ModelReference> subTypes = new ArrayList<ModelReference>();
            for (ModelReference modelReference : rootModel.getSubTypes()) {
                void var14_18;
                Optional<String> modelId = ApiModelReader.getModelId(modelReference);
                if (modelId.isPresent() && mergingContext.containsModel(modelId.get())) {
                    String sModelId = modelId.get();
                    ModelContext modelContext = Optional.ofNullable(parametersMatching.get(sModelId)).map(op -> op.orElse(parameter)).map(p -> ApiModelReader.pseudoContext(p, mergingContext.getModelContext(sModelId))).orElseGet(() -> mergingContext.getModelContext(sModelId));
                    ModelReference modelReference2 = ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, adapter.getNames()).apply(mergingContext.getModel(sModelId).getType());
                }
                subTypes.add((ModelReference)var14_18);
            }
            HashMap<String, ModelProperty> newProperties = new HashMap<String, ModelProperty>(rootModel.getProperties());
            for (String propertyName : rootModel.getProperties().keySet()) {
                ModelProperty property = rootModel.getProperties().get(propertyName);
                ModelReference modelReference3 = property.getModelRef();
                Optional<String> modelId = ApiModelReader.getModelId(modelReference3);
                if (!modelId.isPresent() || !mergingContext.containsModel(modelId.get())) continue;
                String sModelId = modelId.get();
                ModelContext modelContext = Optional.ofNullable(parametersMatching.get(sModelId)).map(op -> op.orElse(parameter)).map(p -> ApiModelReader.pseudoContext(p, mergingContext.getModelContext(sModelId))).orElseGet(() -> mergingContext.getModelContext(sModelId));
                newProperties.put(propertyName, new ModelPropertyBuilder(property).build().updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, adapter.getNames())));
            }
            Model model = rootModelBuilder.properties(newProperties).subTypes(subTypes).build();
            modelsToCompare.stream().filter(m -> StringUtils.isEmpty((Object)parameter) || parameter.equals(mergingContext.getModelParameter(m.getId()))).filter(m -> m.equalsIgnoringName(modelToCompare)).map(Model::getId).findFirst().ifPresent(sameModels::add);
        }
        return sameModels;
    }

    private Set<ComparisonCondition> mergeConditions(Set<String> sameModels, Set<String> currentDependencies, Set<ComparisonCondition> dependencies, UniqueTypeNameAdapter adapter, MergingContext mergingContext) {
        String parameterId = mergingContext.getParameterId();
        if (!sameModels.isEmpty()) {
            ComparisonCondition currentCondition = new ComparisonCondition(mergingContext.getRootId(), sameModels, currentDependencies);
            dependencies = this.filterDependencies(dependencies, ApiModelReader.modelsToParameters(sameModels, mergingContext), mergingContext);
            dependencies.add(currentCondition);
            if (currentCondition.getConditions().isEmpty()) {
                for (ComparisonCondition depComparisonCondition : dependencies) {
                    HashSet<String> conditions = new HashSet<String>(depComparisonCondition.getConditions());
                    conditions.remove(currentCondition.getModelFor());
                    ApiModelReader.checkCondition(new ComparisonCondition(depComparisonCondition.getModelFor(), depComparisonCondition.getModelsTo(), conditions), true);
                    adapter.setEqualityFor(ApiModelReader.toTypeId(parameterId, depComparisonCondition.getModelFor()), new ArrayList<String>(depComparisonCondition.getModelsTo()).get(0));
                }
                return new HashSet<ComparisonCondition>(Collections.singletonList(currentCondition));
            }
            HashSet<ComparisonCondition> newDependencies = new HashSet<ComparisonCondition>();
            for (ComparisonCondition depComparisonCondition : dependencies) {
                HashSet<String> conditions = new HashSet<String>(depComparisonCondition.getConditions());
                conditions.remove(currentCondition.getModelFor());
                conditions.addAll(currentCondition.getConditions());
                newDependencies.add(new ComparisonCondition(depComparisonCondition.getModelFor(), depComparisonCondition.getModelsTo(), conditions));
            }
            return newDependencies;
        }
        adapter.registerUniqueType(mergingContext.getRootModel().getName(), ApiModelReader.toTypeId(parameterId, mergingContext.getRootId()));
        for (ComparisonCondition depComparisonCondition : dependencies) {
            String modelId = depComparisonCondition.getModelFor();
            adapter.registerUniqueType(mergingContext.getModel(modelId).getName(), ApiModelReader.toTypeId(parameterId, modelId));
        }
        return new HashSet<ComparisonCondition>();
    }

    private List<String> findBranchRoots(ModelContext rootContext) {
        ArrayList<String> roots = new ArrayList<String>();
        ResolvedType resolvedType = rootContext.alternateEvaluatedType();
        if (resolvedType.isArray()) {
            ResolvedType elementType = resolvedType.getArrayElementType();
            roots.addAll(this.findBranchRoots(ModelContext.fromParent(rootContext, elementType)));
        } else {
            for (ResolvedType parameter : resolvedType.getTypeParameters()) {
                roots.addAll(this.findBranchRoots(ModelContext.fromParent(rootContext, parameter)));
            }
            roots.add(ModelContext.fromParent(rootContext, resolvedType).getModelId());
        }
        return roots;
    }

    private Set<String> collectNodes(UniqueTypeNameAdapter adapter, MergingContext mergingContext) {
        Optional<String> modelId;
        Model rootModel = mergingContext.getRootModel();
        TreeSet<String> nodes = new TreeSet<String>();
        for (ModelReference modelReference : rootModel.getSubTypes()) {
            Optional<String> modelId2 = ApiModelReader.getModelId(modelReference);
            if (!modelId2.isPresent() || !mergingContext.containsModel(modelId2.get())) continue;
            nodes.add(modelId2.get());
        }
        ModelContext rootModelContext = mergingContext.getModelContext(mergingContext.getRootId());
        for (ResolvedType type : rootModel.getType().getTypeParameters()) {
            modelId = ModelContext.fromParent(rootModelContext, rootModelContext.alternateFor(type)).getModelId();
            if (!mergingContext.containsModel((String)((Object)modelId))) continue;
            nodes.add((String)((Object)modelId));
        }
        for (ModelProperty modelProperty : rootModel.getProperties().values()) {
            modelId = ApiModelReader.getModelId(modelProperty.getModelRef());
            if (!modelId.isPresent() || !mergingContext.containsModel((String)modelId.get())) continue;
            nodes.add((String)modelId.get());
        }
        nodes.removeIf(node -> adapter.getTypeName(ApiModelReader.toTypeId(rootModelContext.getParameterId(), node)).isPresent());
        return nodes;
    }

    private Optional<Set<String>> mergeParameters(String modelId, Set<String> existingParameters, MergingContext mergingContext) {
        if (modelId.equals(mergingContext.getRootId())) {
            return Optional.of(existingParameters);
        }
        HashSet<String> parameters = new HashSet<String>(existingParameters);
        for (Map.Entry<String, Set<String>> entry : mergingContext.getCircles().entrySet()) {
            if (entry.getValue().contains(modelId)) continue;
            if (parameters.isEmpty()) {
                parameters.addAll(mergingContext.getCircleParameters(entry.getKey()));
            } else {
                parameters.retainAll(mergingContext.getCircleParameters(entry.getKey()));
            }
            if (!parameters.isEmpty()) continue;
            return Optional.empty();
        }
        String modelForTypeName = mergingContext.getModel(modelId).getType().getErasedType().getName();
        Set<Model> similarTypeModels = mergingContext.getSimilarTypeModels(modelForTypeName);
        Set candidateParameters = similarTypeModels.stream().map(model -> mergingContext.getModelParameter(model.getId())).collect(Collectors.toCollection(HashSet::new));
        if (parameters.isEmpty()) {
            parameters.addAll(candidateParameters);
        } else {
            parameters.retainAll(candidateParameters);
        }
        if (parameters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(parameters);
    }

    private Set<ComparisonCondition> filterDependencies(Set<ComparisonCondition> dependencies, Set<String> parameters, MergingContext mergingContext) {
        return dependencies.stream().map(condition -> {
            Set modelsTo = condition.getModelsTo().stream().filter(modelId -> parameters.contains(mergingContext.getModelParameter((String)modelId))).collect(Collectors.toCollection(HashSet::new));
            return new ComparisonCondition(condition.getModelFor(), modelsTo, condition.getConditions());
        }).collect(Collectors.toCollection(HashSet::new));
    }

    private Model updateModel(Model model, Map<String, ModelContext> contextMap, UniqueTypeNameAdapter adapter) {
        Optional<String> modelId;
        for (String string : model.getProperties().keySet()) {
            ModelProperty property = model.getProperties().get(string);
            modelId = ApiModelReader.getModelId(property.getModelRef());
            if (!modelId.isPresent() || !contextMap.containsKey(modelId.get())) continue;
            property.updateModelRef(ResolvedTypes.modelRefFactory(contextMap.get(modelId.get()), this.enumTypeDeterminer, this.typeNameExtractor, adapter.getNames()));
        }
        ArrayList<ModelReference> subTypes = new ArrayList<ModelReference>();
        for (ModelReference oldModelRef : model.getSubTypes()) {
            modelId = ApiModelReader.getModelId(oldModelRef);
            if (modelId.isPresent() && contextMap.containsKey(modelId.get())) {
                ModelContext modelContext = contextMap.get(modelId.get());
                subTypes.add(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, adapter.getNames()).apply(modelContext.getType()));
                continue;
            }
            subTypes.add(oldModelRef);
        }
        ModelContext modelContext = contextMap.get(model.getId());
        String name = this.typeNameExtractor.typeName(modelContext, adapter.getNames());
        return new ModelBuilder(modelContext.getTypeId()).name(name).qualifiedType(model.getQualifiedType()).description(model.getDescription()).baseModel(model.getBaseModel()).discriminator(model.getDiscriminator()).type(model.getType()).example(model.getExample()).xml(model.getXml()).properties(model.getProperties()).subTypes(subTypes).build();
    }

    private Set<Model> updateModels(String parameterId, Collection<Model> models, Map<String, ModelContext> contextMap, UniqueTypeNameAdapter adapter) {
        models.forEach(model -> {
            String typeId = ApiModelReader.toTypeId(parameterId, model.getId());
            if (!adapter.getTypeName(typeId).isPresent()) {
                adapter.registerUniqueType(model.getName(), typeId);
            }
        });
        return models.stream().map(model -> this.updateModel((Model)model, contextMap, adapter)).collect(Collectors.toCollection(HashSet::new));
    }

    private static ModelContext pseudoContext(String parameterId, ModelContext context) {
        return ModelContext.inputParam(parameterId, context.getGroupName(), context.getType(), Optional.empty(), new HashSet<ResolvedType>(), context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericNamingStrategy(), Collections.unmodifiableSet(new HashSet()));
    }

    private static void checkCondition(ComparisonCondition condition, boolean conditionalPresenceCheck) {
        if (conditionalPresenceCheck && !condition.getConditions().isEmpty()) {
            throw new IllegalStateException("Equality with conditions is not allowed.");
        }
        if (condition.getConditions().isEmpty() && condition.getModelsTo().size() > 1) {
            throw new IllegalStateException("Ambiguous models equality when conditions is empty.");
        }
    }

    private static Optional<String> getModelId(ModelReference ref) {
        ModelReference refT = ref;
        while (true) {
            if (refT.getModelId().isPresent()) {
                return refT.getModelId();
            }
            if (!refT.itemModel().isPresent()) break;
            refT = refT.itemModel().get();
        }
        return Optional.empty();
    }

    private static String toTypeId(String parameterId, String modelId) {
        return parameterId + "_" + modelId;
    }

    private static Set<String> modelsToParameters(Set<String> models, MergingContext mergingContext) {
        return models.stream().map(mergingContext::getModelParameter).collect(Collectors.toCollection(HashSet::new));
    }

    private void markIgnorablesAsHasSeen(TypeResolver typeResolver, Set<Class> ignorableParameterTypes, ModelContext modelContext) {
        for (Class ignorableParameterType : ignorableParameterTypes) {
            modelContext.seen(typeResolver.resolve((Type)ignorableParameterType, new Type[0]));
        }
    }

    private static MergingContext createChildMergingContext(String modelId, boolean isCircle, Set<String> parameters, Set<ComparisonCondition> dependencies, MergingContext mergingContext) {
        if (isCircle) {
            return mergingContext.toRootId(modelId, dependencies, parameters);
        }
        return mergingContext.toRootId(modelId);
    }

    private static MergingContext createMergingContext(String parameterId, Map<String, Model> uniqueModels, Map<String, String> parameterModelMap, Map<String, Model> currentBranch, Map<String, ModelContext> contextMap) {
        HashMap<String, Set<Model>> typedModelMap = new HashMap<String, Set<Model>>();
        for (Model model : uniqueModels.values()) {
            String rawType = model.getType().getErasedType().getName();
            HashSet<Model> models = new HashSet<Model>();
            models.add(model);
            if (typedModelMap.containsKey(rawType)) {
                models.addAll((Collection)typedModelMap.get(rawType));
            }
            typedModelMap.put(rawType, Collections.unmodifiableSet(models));
        }
        return new MergingContext(parameterId, typedModelMap, parameterModelMap, currentBranch, contextMap);
    }
}

