/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import io.swagger.annotations.ApiModelProperty;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class ApiModelPropertyPropertyBuilder
implements ModelPropertyBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final ModelSpecificationFactory modelSpecifications;

    @Autowired
    public ApiModelPropertyPropertyBuilder(DescriptionResolver descriptions, ModelSpecificationFactory modelSpecifications) {
        this.descriptions = descriptions;
        this.modelSpecifications = modelSpecifications;
    }

    @Override
    public void apply(ModelPropertyContext context) {
        Optional<Object> annotation = Optional.empty();
        if (context.getAnnotatedElement().isPresent()) {
            annotation = annotation.map(Optional::of).orElse(ApiModelProperties.findApiModePropertyAnnotation(context.getAnnotatedElement().get()));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            annotation = annotation.map(Optional::of).orElse(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), ApiModelProperty.class));
        }
        if (annotation.isPresent()) {
            ModelSpecification modelSpecification = annotation.map(a -> {
                if (!a.dataType().isEmpty()) {
                    return this.modelSpecifications.create(context.getOwner(), ApiModelProperties.toType(context.getResolver()).apply((ApiModelProperty)a));
                }
                return null;
            }).orElse(null);
            Optional<Object> finalAnnotation = annotation;
            context.getSpecificationBuilder().description(annotation.map(ApiModelProperties.toDescription(this.descriptions)).orElse(null)).readOnly(annotation.map(ApiModelProperty::readOnly).orElse(false)).isHidden(annotation.map(ApiModelProperty::hidden).orElse(false)).type(modelSpecification).position(annotation.map(ApiModelProperty::position).orElse(0)).required(annotation.map(ApiModelProperty::required).orElse(false)).example(annotation.map(ApiModelProperties.toExample()).orElse(null)).enumerationFacet(e -> e.allowedValues((AllowableValues)finalAnnotation.map(ApiModelProperties.toAllowableValues()).orElse(null)));
            context.getBuilder().allowableValues(annotation.map(ApiModelProperties.toAllowableValues()).orElse(null)).required(annotation.map(ApiModelProperty::required).orElse(false)).readOnly(annotation.map(ApiModelProperty::readOnly).orElse(false)).description(annotation.map(ApiModelProperties.toDescription(this.descriptions)).orElse(null)).isHidden(annotation.map(ApiModelProperty::hidden).orElse(false)).type(annotation.map(ApiModelProperties.toType(context.getResolver())).orElse(null)).position(annotation.map(ApiModelProperty::position).orElse(0)).example(annotation.map(ApiModelProperties.toExample()).orElse(null));
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

