/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.SizeBasedFileRewriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.PropertyUtil;

public abstract class SizeBasedDataRewriter
extends SizeBasedFileRewriter<FileScanTask, DataFile> {
    public static final String DELETE_FILE_THRESHOLD = "delete-file-threshold";
    public static final int DELETE_FILE_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    private int deleteFileThreshold;

    protected SizeBasedDataRewriter(Table table) {
        super(table);
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll(super.validOptions()).add((Object)DELETE_FILE_THRESHOLD).build();
    }

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.deleteFileThreshold = this.deleteFileThreshold(options);
    }

    @Override
    protected Iterable<FileScanTask> filterFiles(Iterable<FileScanTask> tasks) {
        return Iterables.filter(tasks, task -> this.wronglySized(task) || this.tooManyDeletes((FileScanTask)task));
    }

    private boolean tooManyDeletes(FileScanTask task) {
        return task.deletes() != null && task.deletes().size() >= this.deleteFileThreshold;
    }

    @Override
    protected Iterable<List<FileScanTask>> filterFileGroups(List<List<FileScanTask>> groups) {
        return Iterables.filter(groups, this::shouldRewrite);
    }

    private boolean shouldRewrite(List<FileScanTask> group) {
        return this.enoughInputFiles(group) || this.enoughContent(group) || this.tooMuchContent(group) || this.anyTaskHasTooManyDeletes(group);
    }

    private boolean anyTaskHasTooManyDeletes(List<FileScanTask> group) {
        return group.stream().anyMatch(this::tooManyDeletes);
    }

    @Override
    protected long defaultTargetFileSize() {
        return PropertyUtil.propertyAsLong(this.table().properties(), "write.target-file-size-bytes", 0x20000000L);
    }

    private int deleteFileThreshold(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, DELETE_FILE_THRESHOLD, Integer.MAX_VALUE);
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"'%s' is set to %s but must be >= 0", (Object)DELETE_FILE_THRESHOLD, (int)value);
        return value;
    }
}

