/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.processor;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.common.utils.StringUtils;
import io.kyligence.config.core.conf.ExternalConfigProperties;
import io.kyligence.config.core.loader.IExternalConfigLoader;
import io.kyligence.config.external.loader.FileExternalConfigLoader;
import io.kyligence.config.external.loader.NacosExternalConfigLoader;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class ExternalConfigEnvironmentProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ExternalConfigEnvironmentProcessor.class);
    private NacosConfigProperties nacosConfigProperties;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            ExternalConfigProperties externalConfigProperties = (ExternalConfigProperties)Binder.get((Environment)environment).bind("kylin.external.config", ExternalConfigProperties.class).get();
            for (ExternalConfigProperties.ExternalConfigInfo info : externalConfigProperties.getInfos()) {
                Class<?> serviceClass;
                Object externalConfig = null;
                String targetClass = info.getTarget();
                Map properties = info.getProperties();
                if (!properties.containsKey("activateConfig")) {
                    properties.put("activateConfig", "true");
                }
                if (info.getType().equals("nacos")) {
                    if (StringUtils.isEmpty((String)info.getConfigLoaderClass())) {
                        externalConfig = new NacosExternalConfigLoader(properties, this.getNacosConfigProperties((Environment)environment), (Environment)environment);
                    } else {
                        serviceClass = Class.forName(info.getConfigLoaderClass());
                        externalConfig = (IExternalConfigLoader)serviceClass.getDeclaredConstructor(Map.class, NacosConfigProperties.class, Environment.class).newInstance(properties, this.getNacosConfigProperties((Environment)environment), environment);
                    }
                } else if (info.getType().equals("file")) {
                    if (StringUtils.isEmpty((String)info.getConfigLoaderClass())) {
                        externalConfig = new FileExternalConfigLoader(properties);
                    } else {
                        serviceClass = Class.forName(info.getConfigLoaderClass());
                        externalConfig = (IExternalConfigLoader)serviceClass.getDeclaredConstructor(Map.class).newInstance(properties);
                    }
                }
                if (externalConfig == null) continue;
                this.setField(targetClass, (IExternalConfigLoader)externalConfig);
            }
        }
        catch (Exception e) {
            logger.warn("parse failed ", (Throwable)e);
        }
    }

    public int getOrder() {
        return -2147483438;
    }

    private void setField(String clazz, IExternalConfigLoader configLoader) throws ClassNotFoundException {
        Field configLoaderField = ReflectionUtils.findField(Class.forName(clazz), (String)"configLoader");
        configLoaderField.setAccessible(true);
        ReflectionUtils.setField((Field)configLoaderField, null, (Object)configLoader);
    }

    private NacosConfigProperties getNacosConfigProperties(final Environment environment) {
        if (this.nacosConfigProperties == null) {
            this.nacosConfigProperties = (NacosConfigProperties)Binder.get((Environment)environment, (BindHandler)new AbstractBindHandler(){

                public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
                    if (result instanceof NacosConfigProperties) {
                        ((NacosConfigProperties)result).setEnvironment(environment);
                        ((NacosConfigProperties)result).init();
                    }
                    return result;
                }
            }).bind("spring.cloud.nacos.config", NacosConfigProperties.class).get();
        }
        return this.nacosConfigProperties;
    }
}

