/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.common;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparderQueryTest$
implements Logging {
    public static SparderQueryTest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderQueryTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean same(Dataset<Row> sparkDF, Dataset<Row> kylinAnswer, boolean checkOrder) {
        boolean bl;
        Option<String> option = this.checkAnswerBySeq(this.castDataType(sparkDF, kylinAnswer), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])kylinAnswer.collect()), checkOrder, this.checkAnswerBySeq$default$4());
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.value();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public boolean same$default$3() {
        return false;
    }

    public String checkAnswer(Dataset<Row> sparkDF, Dataset<Row> kylinAnswer, boolean checkOrder) {
        String string;
        Option<String> option = this.checkAnswerBySeq(this.castDataType(sparkDF, kylinAnswer), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])kylinAnswer.collect()), checkOrder, this.checkAnswerBySeq$default$4());
        if (option instanceof Some) {
            String errorMessage;
            Some some = (Some)option;
            string = errorMessage = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = null;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public boolean checkAnswer$default$3() {
        return false;
    }

    public Option<String> checkAnswerBySeq(Dataset<Row> sparkDF, Seq<Row> kylinAnswer, boolean checkOrder, boolean checkToRDD) {
        Seq seq;
        Object object = checkToRDD ? BoxesRunTime.boxToLong((long)sparkDF.rdd().count()) : BoxedUnit.UNIT;
        try {
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkDF.collect())).toSeq();
        }
        catch (Exception e) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n             |Exception thrown while executing query:\n             |").append(sparkDF.queryExecution()).append("\n             |== Exception ==\n             |").append(e).append("\n             |").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.stackTraceToString((Throwable)e)).append("\n          ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        Seq sparkAnswer = seq;
        return this.sameRows((Seq<Row>)sparkAnswer, kylinAnswer, checkOrder).map((Function1 & Serializable & scala.Serializable)results -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |Results do not match for query:\n         |Timezone: ").append(TimeZone.getDefault()).append("\n         |Timezone Env: ").append(scala.sys.package$.MODULE$.env().getOrElse((Object)"TZ", (Function0 & Serializable & scala.Serializable)() -> "")).append("\n         |\n         |").append(sparkDF.queryExecution()).append("\n         |== Results ==\n         |").append((String)results).append("\n       ").toString())).stripMargin());
    }

    public boolean checkAnswerBySeq$default$3() {
        return false;
    }

    public boolean checkAnswerBySeq$default$4() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        void var3_3;
        Seq converted = (Seq)answer.map((Function1 & Serializable & scala.Serializable)row -> MODULE$.prepareRow((Row)row), Seq$.MODULE$.canBuildFrom());
        return !isSorted ? (Seq)converted.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$) : var3_3;
    }

    public Row prepareRow(Row row) {
        return Row$.MODULE$.fromSeq((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_11;
            boolean bl = false;
            double d = 0.0;
            Object object = x0$1;
            if (object == null) {
                return var1_11;
            }
            if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                BigDecimal bigDecimal2 = package$.MODULE$.BigDecimal().apply(bigDecimal).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                return var1_11;
            }
            if (object instanceof Double) {
                bl = true;
                d = BoxesRunTime.unboxToDouble((Object)object);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    None$ none$ = None$.MODULE$;
                    return var1_11;
                }
            }
            if (bl) {
                Double d2 = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.BigDecimal().apply(d).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toString())).toDouble());
                return var1_11;
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                Seq seq = Predef$.MODULE$.genericArrayOps(object2).toSeq();
                return var1_11;
            }
            if (object instanceof Row) {
                Row row = (Row)object;
                Row row2 = MODULE$.prepareRow(row);
                return var1_11;
            }
            Object object3 = object;
            return var1_11;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public Option<String> sameRows(Seq<Row> sparkAnswer, Seq<Row> kylinAnswer, boolean isSorted) {
        Seq<Row> seq = this.prepareAnswer(sparkAnswer, isSorted);
        Seq<Row> seq2 = this.prepareAnswer(kylinAnswer, isSorted);
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            String string = new StringBuilder(21).append("== Kylin Answer - ").append(kylinAnswer.size()).append(" ==").toString();
            String string2 = new StringBuilder(21).append("== Spark Answer - ").append(sparkAnswer.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n           |== Results ==\n           |").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide((Seq)((SeqLike)this.prepareAnswer(kylinAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), (Seq)((SeqLike)this.prepareAnswer(sparkAnswer, isSorted).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        return None$.MODULE$;
    }

    public boolean sameRows$default$3() {
        return false;
    }

    public void checkAggregatesWithTol(Row actualAnswer, Row expectedAnswer, double absTol) {
        Predef$.MODULE$.require(actualAnswer.length() == expectedAnswer.length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("actual answer length ").append(actualAnswer.length()).append(" != ").append("expected answer length ").append(expectedAnswer.length()).toString());
        ((IterableLike)actualAnswer.toSeq().zip((GenIterable)expectedAnswer.toSeq(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparderQueryTest$.$anonfun$checkAggregatesWithTol$2(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isCharType(Integer dataType) {
        return BoxesRunTime.equalsNumObject((Number)dataType, (Object)BoxesRunTime.boxToInteger((int)1)) || BoxesRunTime.equalsNumObject((Number)dataType, (Object)BoxesRunTime.boxToInteger((int)12));
    }

    private boolean isIntType(org.apache.kylin.metadata.query.StructField structField) {
        int dataType;
        List intList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-6, 5, 4, -5}));
        return intList.contains((Object)BoxesRunTime.boxToInteger((int)(dataType = structField.getDataType())));
    }

    private boolean isBinaryType(org.apache.kylin.metadata.query.StructField structField) {
        int dataType;
        List intList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2, -3, -4}));
        return intList.contains((Object)BoxesRunTime.boxToInteger((int)(dataType = structField.getDataType())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isArrayType(org.apache.kylin.metadata.query.StructField field) {
        String string = field.getDataTypeName();
        String string2 = "ARRAY<STRING>";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field.getDataTypeName();
        String string4 = "ARRAY";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public boolean isSameDataType(org.apache.kylin.metadata.query.StructField cubeStructField, org.apache.kylin.metadata.query.StructField sparkStructField) {
        if (cubeStructField.getDataType() == sparkStructField.getDataType()) {
            return true;
        }
        if (cubeStructField.getDataType() == 2000) {
            return true;
        }
        if (this.isCharType(Predef$.MODULE$.int2Integer(cubeStructField.getDataType())) && this.isCharType(Predef$.MODULE$.int2Integer(sparkStructField.getDataType()))) {
            return true;
        }
        if (this.isIntType(cubeStructField) && this.isIntType(sparkStructField)) {
            return true;
        }
        if (this.isBinaryType(cubeStructField) && this.isBinaryType(sparkStructField)) {
            return true;
        }
        return this.isArrayType(cubeStructField) && this.isArrayType(sparkStructField);
    }

    public Dataset<Row> castDataType(Dataset<Row> sparkResult, Dataset<Row> cubeResult) {
        Seq newNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkResult.schema().names())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append(((String)name._1()).replaceAll("\\.", "_")).append("_").append(name._2$mcI$sp()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        Dataset newDf = sparkResult.toDF(newNames);
        Seq columns = (Seq)((TraversableLike)newDf.schema().zip((GenIterable)cubeResult.schema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField sparkField = (StructField)tuple2._1();
            StructField kylinField = (StructField)tuple2._2();
            Column column = !sparkField.dataType().sameType(kylinField.dataType()) ? functions$.MODULE$.col(sparkField.name()).cast(kylinField.dataType()) : functions$.MODULE$.col(sparkField.name());
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        return newDf.select(columns);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$2(double absTol$1, Tuple2 x0$1) {
        Object expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object actual = tuple2._1();
            Object expected2 = tuple2._2();
            if (actual instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)actual);
                if (expected2 instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)expected2);
                    Predef$.MODULE$.assert(scala.math.package$.MODULE$.abs(d - d2) < absTol$1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("actual answer ").append(d).append(" not within ").append(absTol$1).append(" of correct answer ").append(d2).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object actual = tuple2._1();
        Predef$.MODULE$.assert(BoxesRunTime.equals((Object)actual, (Object)(expected = tuple2._2())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(actual).append(" did not equal ").append(expected).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparderQueryTest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

