/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.status.TaskDataWrapper;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStoreIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0003\u0006\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003g\u0001\u0011\u0005q\rC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003p\u0001\u0011\u0005qOA\u0005BaB\u001cF/\u0019;vg*\u00111\u0002D\u0001\b[\u0016$(/[2t\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017\u0001D:qCJ\\7i\u001c8uKb$\bC\u0001\u000f\u001e\u001b\u0005a\u0011B\u0001\u0010\r\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0003\u0005\u00065\t\u0001\raG\u0001\u0012O\u0016$H+Y:l\u0019\u0006,hn\u00195US6,Gc\u0001\u0014*]A\u0011QcJ\u0005\u0003QY\u0011a\u0001R8vE2,\u0007\"\u0002\u0016\u0004\u0001\u0004Y\u0013aB:uC\u001e,\u0017\n\u001a\t\u0003+1J!!\f\f\u0003\u0007%sG\u000fC\u00030\u0007\u0001\u0007a%\u0001\u0005rk\u0006tG/\u001b7f\u0003%\u00198-\u00198UCN\\7\u000f\u0006\u00033\u0003\n{EC\u0001\u00144\u0011\u0015!D\u00011\u00016\u0003\t1g\u000e\u0005\u0003\u0016mar\u0014BA\u001c\u0017\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002:y5\t!H\u0003\u0002<\u0019\u000511\u000f^1ukNL!!\u0010\u001e\u0003\u001fQ\u000b7o\u001b#bi\u0006<&/\u00199qKJ\u0004\"!F \n\u0005\u00013\"\u0001\u0002'p]\u001eDQA\u000b\u0003A\u0002-BQa\u0011\u0003A\u0002\u0011\u000bQ!\u001b8eKb\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$\u0017\u001b\u0005A%BA%\u0013\u0003\u0019a$o\\8u}%\u00111JF\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L-!)q\u0006\u0002a\u0001M\u0005\u0019r-\u001a;K_\n\u001cF/Y4fgN+X.\\1ssR\u0019!kY3\u0011\u0007MC6L\u0004\u0002U-:\u0011q)V\u0005\u0002/%\u0011qKF\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0002TKFT!a\u0016\f\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016A\u0001<2\u0015\t\u0001'(A\u0002ba&L!AY/\u0003/Q\u000b7o['fiJL7\rR5tiJL'-\u001e;j_:\u001c\b\"\u00023\u0006\u0001\u0004Y\u0013!\u00026pE&#\u0007\"B\u0018\u0006\u0001\u00041\u0013\u0001C4fiN#\u0018mZ3\u0015\u0005!t\u0007cA\u000bjW&\u0011!N\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005qa\u0017BA7\r\u00059\u0019\u0006/\u0019:l'R\fw-Z%oM>DQA\u000b\u0004A\u0002-\n!bZ3u\u0015>\u0014G)\u0019;b)\t\tX\u000fE\u0002T1J\u0004\"\u0001X:\n\u0005Ql&a\u0002&pE\u0012\u000bG/\u0019\u0005\u0006m\u001e\u0001\r\u0001R\u0001\tU>\u0014wI]8vaR\u0011\u00010\u001f\t\u0004+%\u0014\b\"\u00023\t\u0001\u0004Y\u0003")
public class AppStatus {
    private final SparkContext sparkContext;

    public double getTaskLaunchTime(int stageId, double quantile) {
        return this.scanTasks(stageId, "lt", quantile, (Function1<TaskDataWrapper, Object>)(Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.launchTime()));
    }

    public double scanTasks(int stageId, String index, double quantile, Function1<TaskDataWrapper, Object> fn) {
        int[] stageKey = new int[]{stageId, 0};
        long count = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.sparkContext.statusStore().store().view(TaskDataWrapper.class).parent((Object)stageKey).index("ert").first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToLong((long)AppStatus.$anonfun$scanTasks$2(it))));
        long idx = package$.MODULE$.min((long)(quantile * (double)count), count - 1L);
        return BoxesRunTime.unboxToDouble((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.sparkContext.statusStore().store().view(TaskDataWrapper.class).parent((Object)stageKey).index(index).first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToDouble((double)AppStatus.$anonfun$scanTasks$4(idx, fn, it))));
    }

    public Seq<TaskMetricDistributions> getJobStagesSummary(int jobId, double quantile) {
        return (Seq)this.getJobData(jobId).map((Function1 & Serializable & scala.Serializable)jobData -> (Seq)jobData.stageIds().flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.sparkContext.statusStore().taskSummary(BoxesRunTime.unboxToInt((Object)stageId), 0, new double[]{quantile})), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Option<SparkStageInfo> getStage(int stageId) {
        return this.sparkContext.statusTracker().getStageInfo(stageId);
    }

    public Seq<JobData> getJobData(String jobGroup) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.sparkContext.statusTracker().getJobIdsForGroup(jobGroup))).map((Function1 & Serializable & scala.Serializable)jobId -> this.getJobData(BoxesRunTime.unboxToInt((Object)jobId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDefined())))).map((Function1 & Serializable & scala.Serializable)x$2 -> (JobData)x$2.get(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Option<JobData> getJobData(int jobId) {
        Some some;
        try {
            some = new Some((Object)this.sparkContext.statusStore().job(jobId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$scanTasks$2(KVStoreIterator it) {
        void var1_1;
        long _count = 0L;
        while (it.hasNext()) {
            ++_count;
            it.skip(1L);
        }
        return (long)var1_1;
    }

    public static final /* synthetic */ double $anonfun$scanTasks$4(long idx$1, Function1 fn$1, KVStoreIterator it) {
        double d;
        double last = Double.NaN;
        long currentIdx = -1L;
        if (idx$1 == currentIdx) {
            d = last;
        } else {
            long diff = idx$1 - currentIdx;
            currentIdx = idx$1;
            d = it.skip(diff - 1L) ? (last = (double)BoxesRunTime.unboxToLong((Object)fn$1.apply(it.next()))) : Double.NaN;
        }
        return d;
    }

    public AppStatus(SparkContext sparkContext) {
        this.sparkContext = sparkContext;
    }
}

